/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.postgresql.Driver;
import org.postgresql.PGConnection;

public class DriverWrapper
extends Driver {
    public static final String POSTGRES_PROTOCOL = "jdbc:postgresql:";
    public static final String POSTGIS_PROTOCOL = "jdbc:postgresql_postGIS:";
    public static final String REVISION = "$Revision: 1.10 $";
    protected static TypesAdder ta72 = null;
    protected static TypesAdder ta74 = null;
    protected static TypesAdder ta80 = null;
    protected TypesAdder typesAdder = DriverWrapper.getTypesAdder(this);

    protected static TypesAdder getTypesAdder(Driver driver) throws SQLException {
        if (driver.getMajorVersion() == 7) {
            if (driver.getMinorVersion() >= 3) {
                if (ta74 == null) {
                    ta74 = DriverWrapper.loadTypesAdder("74");
                }
                return ta74;
            }
            if (ta72 == null) {
                ta72 = DriverWrapper.loadTypesAdder("72");
            }
            return ta72;
        }
        if (ta80 == null) {
            ta80 = DriverWrapper.loadTypesAdder("80");
        }
        return ta80;
    }

    private static final TypesAdder loadTypesAdder(String string) throws SQLException {
        try {
            Class<?> clazz = Class.forName("org.postgis.DriverWrapper$TypesAdder" + string);
            return (TypesAdder)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new SQLException("Cannot create TypesAdder instance! " + exception.getMessage());
        }
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        string = this.mangleURL(string);
        Connection connection = super.connect(string, properties);
        this.typesAdder.addGT(connection, this.useLW(connection));
        return connection;
    }

    protected boolean useLW(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("null is no valid parameter");
        }
        return false;
    }

    public boolean acceptsURL(String string) throws SQLException {
        try {
            string = this.mangleURL(string);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return super.acceptsURL(string);
    }

    public static String getVersion() {
        return "PostGisWrapper $Revision: 1.10 $, wrapping " + Driver.getVersion();
    }

    public static void addGISTypes(PGConnection pGConnection) throws SQLException {
        DriverWrapper.loadTypesAdder("74").addGT((Connection)pGConnection, false);
    }

    public static void addGISTypes80(PGConnection pGConnection) throws SQLException {
        DriverWrapper.loadTypesAdder("80").addGT((Connection)pGConnection, false);
    }

    public static void addGISTypes72(org.postgresql.Connection connection) throws SQLException {
        DriverWrapper.loadTypesAdder("72").addGT((Connection)connection, false);
    }

    protected String mangleURL(String string) throws SQLException {
        String string2 = this.getProtoString();
        if (string.startsWith(string2)) {
            return POSTGRES_PROTOCOL + string.substring(string2.length());
        }
        throw new SQLException("Unknown protocol or subprotocol in url " + string);
    }

    protected String getProtoString() {
        return POSTGIS_PROTOCOL;
    }

    public DriverWrapper() throws SQLException {
        if (super.getMajorVersion() > 8 || super.getMinorVersion() > 1) {
            Driver.debug((String)(((Object)((Object)this)).getClass().getName() + " loaded TypesAdder: " + this.typesAdder.getClass().getName()));
        }
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)((Object)new DriverWrapper()));
        }
        catch (SQLException sQLException) {
            Driver.info((String)"Error registering PostGIS Wrapper Driver", (Exception)sQLException);
        }
    }

    protected static abstract class TypesAdder {
        public final void addGT(Connection connection, boolean bl) throws SQLException {
            if (bl) {
                this.addBinaryGeometries(connection);
            } else {
                this.addGeometries(connection);
            }
            this.addBoxen(connection);
        }

        public abstract void addGeometries(Connection var1) throws SQLException;

        public abstract void addBoxen(Connection var1) throws SQLException;

        public abstract void addBinaryGeometries(Connection var1) throws SQLException;

        protected TypesAdder() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected static class TypesAdder80
    extends TypesAdder {
        static /* synthetic */ Class class$org$postgis$PGgeometry;
        static /* synthetic */ Class class$org$postgis$PGbox3d;
        static /* synthetic */ Class class$org$postgis$PGbox2d;
        static /* synthetic */ Class class$org$postgis$PGgeometryLW;

        public void addGeometries(Connection connection) throws SQLException {
            PGConnection pGConnection = (PGConnection)connection;
            Class clazz = class$org$postgis$PGgeometry;
            if (clazz == null) {
                clazz = class$org$postgis$PGgeometry = TypesAdder80.class("[Lorg.postgis.PGgeometry;", false);
            }
            pGConnection.addDataType("geometry", clazz);
        }

        public void addBoxen(Connection connection) throws SQLException {
            PGConnection pGConnection = (PGConnection)connection;
            Class clazz = class$org$postgis$PGbox3d;
            if (clazz == null) {
                clazz = class$org$postgis$PGbox3d = TypesAdder80.class("[Lorg.postgis.PGbox3d;", false);
            }
            pGConnection.addDataType("box3d", clazz);
            Class clazz2 = class$org$postgis$PGbox2d;
            if (clazz2 == null) {
                clazz2 = class$org$postgis$PGbox2d = TypesAdder80.class("[Lorg.postgis.PGbox2d;", false);
            }
            pGConnection.addDataType("box2d", clazz2);
        }

        public void addBinaryGeometries(Connection connection) throws SQLException {
            PGConnection pGConnection = (PGConnection)connection;
            Class clazz = class$org$postgis$PGgeometryLW;
            if (clazz == null) {
                clazz = class$org$postgis$PGgeometryLW = TypesAdder80.class("[Lorg.postgis.PGgeometryLW;", false);
            }
            pGConnection.addDataType("geometry", clazz);
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        protected TypesAdder80() {
        }
    }

    protected static class TypesAdder72
    extends TypesAdder {
        public void addGeometries(Connection connection) {
            org.postgresql.Connection connection2 = (org.postgresql.Connection)connection;
            connection2.addDataType("geometry", "org.postgis.PGgeometry");
        }

        public void addBoxen(Connection connection) {
            org.postgresql.Connection connection2 = (org.postgresql.Connection)connection;
            connection2.addDataType("box3d", "org.postgis.PGbox3d");
            connection2.addDataType("box2d", "org.postgis.PGbox2d");
        }

        public void addBinaryGeometries(Connection connection) {
            org.postgresql.Connection connection2 = (org.postgresql.Connection)connection;
            connection2.addDataType("geometry", "org.postgis.PGgeometryLW");
        }

        protected TypesAdder72() {
        }
    }

    protected static final class TypesAdder74
    extends TypesAdder {
        public final void addGeometries(Connection connection) {
            PGConnection pGConnection = (PGConnection)connection;
            pGConnection.addDataType("geometry", "org.postgis.PGgeometry");
        }

        public final void addBoxen(Connection connection) {
            PGConnection pGConnection = (PGConnection)connection;
            pGConnection.addDataType("box3d", "org.postgis.PGbox3d");
            pGConnection.addDataType("box2d", "org.postgis.PGbox2d");
        }

        public final void addBinaryGeometries(Connection connection) {
            PGConnection pGConnection = (PGConnection)connection;
            pGConnection.addDataType("geometry", "org.postgis.PGgeometryLW");
        }

        protected TypesAdder74() {
        }
    }
}

