/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.domain.valueobject;

import com.gisgraphy.domain.valueobject.GISSource;
import com.gisgraphy.domain.valueobject.SpeedMode;
import com.gisgraphy.helper.URLUtils;
import com.gisgraphy.street.StreetType;
import com.vividsolutions.jts.geom.Point;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="result")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StreetDistance {
    @XmlTransient
    protected static final Logger logger = LoggerFactory.getLogger(StreetDistance.class);
    private String name;
    @XmlTransient
    private Point location;
    private Double distance;
    private Long gid;
    private Long openstreetmapId;
    private StreetType streetType;
    private String streetRef;
    private Boolean oneWay;
    private String countryCode;
    private Double length;
    private Double lat;
    private Double lng;
    private String isIn;
    private String isInPlace;
    private String isInAdm;
    private String adm1Name;
    private String adm2Name;
    private String adm3Name;
    private String adm4Name;
    private String adm5Name;
    private String isInZip;
    private String fullyQualifiedName;
    private Integer lanes;
    private Boolean toll;
    private String surface;
    private String maxSpeed;
    private SpeedMode speedMode;
    private String maxSpeedBackward;
    private Integer azimuthStart;
    private Integer azimuthEnd;
    private String label;
    private String labelPostal;
    private Set<String> alternateLabels;
    private String zipCode;
    private GISSource source;

    public String getStreetRef() {
        return this.streetRef;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelPostal() {
        return this.labelPostal;
    }

    public Set<String> getAlternateLabels() {
        return this.alternateLabels;
    }

    public GISSource getSource() {
        return this.source;
    }

    public Integer getLanes() {
        return this.lanes;
    }

    public Boolean getToll() {
        return this.toll;
    }

    public String getSurface() {
        return this.surface;
    }

    public String getMaxSpeed() {
        return this.maxSpeed;
    }

    public String getMaxSpeedBackward() {
        return this.maxSpeedBackward;
    }

    public Integer getAzimuthStart() {
        return this.azimuthStart;
    }

    public Integer getAzimuthEnd() {
        return this.azimuthEnd;
    }

    public void updateFields() {
        if (this.location != null) {
            this.lat = this.location.getY();
            this.lng = this.location.getX();
        }
    }

    public String getName() {
        return this.name;
    }

    public Double getDistance() {
        return this.distance;
    }

    public Long getGid() {
        return this.gid;
    }

    public Long getOpenstreetmapId() {
        return this.openstreetmapId;
    }

    public StreetType getStreetType() {
        return this.streetType;
    }

    public Boolean getOneWay() {
        return this.oneWay;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public Double getLength() {
        return this.length;
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getLng() {
        return this.lng;
    }

    @XmlTransient
    public Point getLocation() {
        return this.location;
    }

    public String getIsIn() {
        return this.isIn;
    }

    public String getIsInPlace() {
        return this.isInPlace;
    }

    public String getIsInAdm() {
        return this.isInAdm;
    }

    public String getAdm1Name() {
        return this.adm1Name;
    }

    public void setAdm1Name(String adm1Name) {
        this.adm1Name = adm1Name;
    }

    public String getAdm2Name() {
        return this.adm2Name;
    }

    public void setAdm2Name(String adm2Name) {
        this.adm2Name = adm2Name;
    }

    public String getAdm3Name() {
        return this.adm3Name;
    }

    public void setAdm3Name(String adm3Name) {
        this.adm3Name = adm3Name;
    }

    public String getAdm4Name() {
        return this.adm4Name;
    }

    public void setAdm4Name(String adm4Name) {
        this.adm4Name = adm4Name;
    }

    public String getAdm5Name() {
        return this.adm5Name;
    }

    public void setAdm5Name(String adm5Name) {
        this.adm5Name = adm5Name;
    }

    public String getIsInZip() {
        return this.isInZip;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public String getOpenstreetmapUrl() {
        return URLUtils.createOpenstreetmapMapUrlForStreet(this.location);
    }

    public SpeedMode getSpeedMode() {
        return this.speedMode;
    }

    public static class StreetDistanceBuilder {
        private final StreetDistance streetDistance = new StreetDistance();

        public static StreetDistanceBuilder streetDistance() {
            return new StreetDistanceBuilder();
        }

        private StreetDistanceBuilder() {
        }

        public StreetDistance build() {
            this.streetDistance.updateFields();
            return this.streetDistance;
        }

        public StreetDistanceBuilder withName(String name) {
            this.streetDistance.name = name;
            return this;
        }

        public StreetDistanceBuilder withOpenstreetMapId(Long openstreetmapId) {
            this.streetDistance.openstreetmapId = openstreetmapId;
            return this;
        }

        public StreetDistanceBuilder withLocation(Point location) {
            this.streetDistance.location = location;
            return this;
        }

        public StreetDistanceBuilder withDistance(Double distance) {
            this.streetDistance.distance = distance;
            return this;
        }

        public StreetDistanceBuilder withGid(Long gid) {
            this.streetDistance.gid = gid;
            return this;
        }

        public StreetDistanceBuilder withStreetType(StreetType streetType) {
            this.streetDistance.streetType = streetType;
            return this;
        }

        public StreetDistanceBuilder withStreetRef(String streetRef) {
            this.streetDistance.streetRef = streetRef;
            return this;
        }

        public StreetDistanceBuilder withOneWay(Boolean oneWay) {
            this.streetDistance.oneWay = oneWay;
            return this;
        }

        public StreetDistanceBuilder withLength(Double length) {
            this.streetDistance.length = length;
            return this;
        }

        public StreetDistanceBuilder withCountryCode(String countryCode) {
            if (countryCode != null) {
                this.streetDistance.countryCode = countryCode.toUpperCase();
            }
            return this;
        }

        public StreetDistanceBuilder withIsIn(String isIn) {
            this.streetDistance.isIn = isIn;
            return this;
        }

        public StreetDistanceBuilder withIsInPlace(String isInPlace) {
            this.streetDistance.isInPlace = isInPlace;
            return this;
        }

        public StreetDistanceBuilder withIsInAdm(String isInAdm) {
            this.streetDistance.isInAdm = isInAdm;
            return this;
        }

        public StreetDistanceBuilder withIsInZip(String isInZip) {
            this.streetDistance.isInZip = isInZip;
            return this;
        }

        public StreetDistanceBuilder withLanes(Integer lanes) {
            this.streetDistance.lanes = lanes;
            return this;
        }

        public StreetDistanceBuilder withToll(Boolean toll) {
            this.streetDistance.toll = toll;
            return this;
        }

        public StreetDistanceBuilder withSurface(String surface) {
            this.streetDistance.surface = surface;
            return this;
        }

        public StreetDistanceBuilder withMaxSpeed(String maxSpeed) {
            this.streetDistance.maxSpeed = maxSpeed;
            return this;
        }

        public StreetDistanceBuilder withMaxSpeedBackward(String maxSpeedBackward) {
            this.streetDistance.maxSpeedBackward = maxSpeedBackward;
            return this;
        }

        public StreetDistanceBuilder withAzimuthStart(Integer azimuthStart) {
            this.streetDistance.azimuthStart = azimuthStart;
            return this;
        }

        public StreetDistanceBuilder withAzimuthEnd(Integer azimuthEnd) {
            this.streetDistance.azimuthEnd = azimuthEnd;
            return this;
        }

        public StreetDistanceBuilder withFullyQualifiedName(String fullyQualifiedName) {
            this.streetDistance.fullyQualifiedName = fullyQualifiedName;
            return this;
        }
    }
}

