/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.clickstream.config;

import com.opensymphony.clickstream.config.ClickstreamConfig;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigLoader {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$clickstream$config$ConfigLoader == null ? (class$com$opensymphony$clickstream$config$ConfigLoader = ConfigLoader.class$("com.opensymphony.clickstream.config.ConfigLoader")) : class$com$opensymphony$clickstream$config$ConfigLoader));
    private ClickstreamConfig config;
    private static ConfigLoader singleton;
    static /* synthetic */ Class class$com$opensymphony$clickstream$config$ConfigLoader;

    public static ConfigLoader getInstance() {
        if (singleton == null) {
            singleton = new ConfigLoader();
        }
        return singleton;
    }

    private ConfigLoader() {
    }

    public synchronized ClickstreamConfig getConfig() {
        if (this.config != null) {
            return this.config;
        }
        InputStream is = this.getInputStream("clickstream.xml");
        if (is == null) {
            is = this.getInputStream("/clickstream.xml");
        }
        if (is == null) {
            is = this.getInputStream("META-INF/clickstream-default.xml");
        }
        if (is == null) {
            is = this.getInputStream("/META-INF/clickstream-default.xml");
        }
        this.config = new ClickstreamConfig();
        try {
            log.debug((Object)"Loading config");
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, (DefaultHandler)new ConfigHandler());
            return this.config;
        }
        catch (SAXException e) {
            log.error((Object)"Could not parse config XML", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            log.error((Object)"Could not read config from stream", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            log.fatal((Object)"Could not obtain SAX parser", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        catch (RuntimeException e) {
            log.fatal((Object)"RuntimeException", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.fatal((Object)"Exception", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    private InputStream getInputStream(String resourceName) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            (class$com$opensymphony$clickstream$config$ConfigLoader == null ? (class$com$opensymphony$clickstream$config$ConfigLoader = ConfigLoader.class$("com.opensymphony.clickstream.config.ConfigLoader")) : class$com$opensymphony$clickstream$config$ConfigLoader).getClassLoader().getResourceAsStream(resourceName);
        }
        return is;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConfigHandler
    extends DefaultHandler {
        private ConfigHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("logger")) {
                ConfigLoader.this.config.setLoggerClass(attributes.getValue("class"));
            } else if (qName.equals("bot-host")) {
                ConfigLoader.this.config.addBotHost(attributes.getValue("name"));
            } else if (qName.equals("bot-agent")) {
                ConfigLoader.this.config.addBotAgent(attributes.getValue("name"));
            }
        }
    }
}

