/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UserLayer;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.ExpressionVisitor;

public class StyleAttributeExtractor
extends FilterAttributeExtractor
implements StyleVisitor {
    boolean defaultGeometryUsed = false;

    public boolean getDefaultGeometryUsed() {
        return this.defaultGeometryUsed;
    }

    public void visit(Style style) {
        FeatureTypeStyle[] ftStyles = style.getFeatureTypeStyles();
        for (int i = 0; i < ftStyles.length; ++i) {
            ftStyles[i].accept((StyleVisitor)this);
        }
    }

    public void visit(Rule rule) {
        Graphic[] legendGraphics;
        Symbolizer[] symbolizers;
        Filter filter = rule.getFilter();
        if (filter != null) {
            filter.accept((FilterVisitor)this, null);
        }
        if ((symbolizers = rule.getSymbolizers()) != null) {
            for (int i = 0; i < symbolizers.length; ++i) {
                Symbolizer symbolizer = symbolizers[i];
                symbolizer.accept((StyleVisitor)this);
            }
        }
        if ((legendGraphics = rule.getLegendGraphic()) != null) {
            // empty if block
        }
    }

    public void visit(FeatureTypeStyle fts) {
        Rule[] rules = fts.getRules();
        for (int i = 0; i < rules.length; ++i) {
            Rule rule = rules[i];
            rule.accept((StyleVisitor)this);
        }
    }

    public void visit(Fill fill) {
        if (fill.getBackgroundColor() != null) {
            fill.getBackgroundColor().accept((ExpressionVisitor)this, null);
        }
        if (fill.getColor() != null) {
            fill.getColor().accept((ExpressionVisitor)this, null);
        }
        if (fill.getGraphicFill() != null) {
            fill.getGraphicFill().accept((StyleVisitor)this);
        }
        if (fill.getOpacity() != null) {
            fill.getOpacity().accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(Stroke stroke) {
        if (stroke.getColor() != null) {
            stroke.getColor().accept((ExpressionVisitor)this, null);
        }
        if (stroke.getDashOffset() != null) {
            stroke.getDashOffset().accept((ExpressionVisitor)this, null);
        }
        if (stroke.getGraphicFill() != null) {
            stroke.getGraphicFill().accept((StyleVisitor)this);
        }
        if (stroke.getGraphicStroke() != null) {
            stroke.getGraphicStroke().accept((StyleVisitor)this);
        }
        if (stroke.getLineCap() != null) {
            stroke.getLineCap().accept((ExpressionVisitor)this, null);
        }
        if (stroke.getLineJoin() != null) {
            stroke.getLineJoin().accept((ExpressionVisitor)this, null);
        }
        if (stroke.getOpacity() != null) {
            stroke.getOpacity().accept((ExpressionVisitor)this, null);
        }
        if (stroke.getWidth() != null) {
            stroke.getWidth().accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        }
        if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        }
        if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        }
        if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        }
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        }
    }

    public void visit(RasterSymbolizer rs) {
        if (rs.getGeometryPropertyName() != null) {
            this.attributeNames.add(rs.getGeometryPropertyName());
        }
        if (rs.getImageOutline() != null) {
            rs.getImageOutline().accept((StyleVisitor)this);
        }
        if (rs.getOpacity() != null) {
            rs.getOpacity().accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(PointSymbolizer ps) {
        if (ps.getGeometryPropertyName() != null) {
            this.attributeNames.add(ps.getGeometryPropertyName());
        } else {
            this.defaultGeometryUsed = true;
        }
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept((StyleVisitor)this);
        }
    }

    public void visit(LineSymbolizer line) {
        if (line.getGeometryPropertyName() != null) {
            this.attributeNames.add(line.getGeometryPropertyName());
        } else {
            this.defaultGeometryUsed = true;
        }
        if (line.getStroke() != null) {
            line.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        if (poly.getGeometryPropertyName() != null) {
            this.attributeNames.add(poly.getGeometryPropertyName());
        } else {
            this.defaultGeometryUsed = true;
        }
        if (poly.getStroke() != null) {
            poly.getStroke().accept((StyleVisitor)this);
        }
        if (poly.getFill() != null) {
            poly.getFill().accept((StyleVisitor)this);
        }
    }

    public void visit(TextSymbolizer text) {
        if (text.getGeometryPropertyName() != null) {
            this.attributeNames.add(text.getGeometryPropertyName());
        } else {
            this.defaultGeometryUsed = true;
        }
        if (text instanceof TextSymbolizer2 && ((TextSymbolizer2)text).getGraphic() != null) {
            ((TextSymbolizer2)text).getGraphic().accept((StyleVisitor)this);
        }
        if (text.getFill() != null) {
            text.getFill().accept((StyleVisitor)this);
        }
        if (text.getHalo() != null) {
            text.getHalo().accept((StyleVisitor)this);
        }
        if (text.getFonts() != null) {
            Font[] fonts = text.getFonts();
            for (int i = 0; i < fonts.length; ++i) {
                Font font = fonts[i];
                if (font.getFontFamily() != null) {
                    font.getFontFamily().accept((ExpressionVisitor)this, null);
                }
                if (font.getFontSize() != null) {
                    font.getFontSize().accept((ExpressionVisitor)this, null);
                }
                if (font.getFontStyle() != null) {
                    font.getFontStyle().accept((ExpressionVisitor)this, null);
                }
                if (font.getFontWeight() == null) continue;
                font.getFontWeight().accept((ExpressionVisitor)this, null);
            }
        }
        if (text.getHalo() != null) {
            text.getHalo().accept((StyleVisitor)this);
        }
        if (text.getLabel() != null) {
            text.getLabel().accept((ExpressionVisitor)this, null);
        }
        if (text.getPlacement() != null) {
            text.getPlacement().accept((StyleVisitor)this);
        }
        if (text.getPriority() != null) {
            text.getPriority().accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(Graphic gr) {
        if (gr.getSymbols() != null) {
            Symbol[] symbols = gr.getSymbols();
            for (int i = 0; i < symbols.length; ++i) {
                Symbol symbol = symbols[i];
                symbol.accept((StyleVisitor)this);
            }
        }
        if (gr.getOpacity() != null) {
            gr.getOpacity().accept((ExpressionVisitor)this, null);
        }
        if (gr.getRotation() != null) {
            gr.getRotation().accept((ExpressionVisitor)this, null);
        }
        if (gr.getSize() != null) {
            gr.getSize().accept((ExpressionVisitor)this, null);
        }
        if (gr.getDisplacement() != null) {
            gr.getDisplacement().accept((StyleVisitor)this);
        }
    }

    public void visit(Mark mark) {
        if (mark.getFill() != null) {
            mark.getFill().accept((StyleVisitor)this);
        }
        if (mark.getStroke() != null) {
            mark.getStroke().accept((StyleVisitor)this);
        }
        if (mark.getRotation() != null) {
            mark.getRotation().accept((ExpressionVisitor)this, null);
        }
        if (mark.getSize() != null) {
            mark.getSize().accept((ExpressionVisitor)this, null);
        }
        if (mark.getWellKnownName() != null) {
            mark.getWellKnownName().accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(ExternalGraphic exgr) {
    }

    public void visit(PointPlacement pp) {
        if (pp.getAnchorPoint() != null) {
            pp.getAnchorPoint().accept((StyleVisitor)this);
        }
        if (pp.getDisplacement() != null) {
            pp.getDisplacement().accept((StyleVisitor)this);
        }
        if (pp.getRotation() != null) {
            pp.getRotation().accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(AnchorPoint ap) {
        if (ap.getAnchorPointX() != null) {
            ap.getAnchorPointX().accept((ExpressionVisitor)this, null);
        }
        if (ap.getAnchorPointY() != null) {
            ap.getAnchorPointY().accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(Displacement dis) {
        if (dis.getDisplacementX() != null) {
            dis.getDisplacementX().accept((ExpressionVisitor)this, null);
        }
        if (dis.getDisplacementY() != null) {
            dis.getDisplacementY().accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(LinePlacement lp) {
        if (lp.getPerpendicularOffset() != null) {
            lp.getPerpendicularOffset().accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(Halo halo) {
        if (halo.getFill() != null) {
            halo.getFill().accept((StyleVisitor)this);
        }
        if (halo.getRadius() != null) {
            halo.getRadius().accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(StyledLayerDescriptor sld) {
        StyledLayer[] layers = sld.getStyledLayers();
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i] instanceof NamedLayer) {
                ((NamedLayer)layers[i]).accept((StyleVisitor)this);
                continue;
            }
            if (!(layers[i] instanceof UserLayer)) continue;
            ((UserLayer)layers[i]).accept((StyleVisitor)this);
        }
    }

    public void visit(NamedLayer layer) {
        Style[] styles = layer.getStyles();
        for (int i = 0; i < styles.length; ++i) {
            styles[i].accept((StyleVisitor)this);
        }
    }

    public void visit(UserLayer layer) {
        Style[] styles = layer.getUserStyles();
        for (int i = 0; i < styles.length; ++i) {
            styles[i].accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeConstraint ftc) {
    }

    public void visit(ColorMap map) {
        ColorMapEntry[] entries = map.getColorMapEntries();
        for (int i = 0; i < entries.length; ++i) {
            entries[i].accept((StyleVisitor)this);
        }
    }

    public void visit(ColorMapEntry entry) {
    }
}

