/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.data.DataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.filter.ExpressionBuilder;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.filter.FilterDOMParser;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedLayerImpl;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDInlineFeatureParser;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.ShadedReliefImpl;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.StyledLayerImpl;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UserLayer;
import org.geotools.styling.UserLayerImpl;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SLDParser {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.styling");
    private FilterFactory ff;
    protected InputSource source;
    private Document dom;
    protected StyleFactory factory;
    private String graphicSt = "Graphic";
    private String geomSt = "Geometry";
    private String fillSt = "Fill";
    private URL sourceUrl;

    public SLDParser(StyleFactory factory) {
        this(factory, CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public SLDParser(StyleFactory factory, FilterFactory filterFactory) {
        this.factory = factory;
        this.ff = filterFactory;
    }

    public SLDParser(StyleFactory factory, String filename) throws FileNotFoundException {
        this(factory);
        File f = new File(filename);
        this.setInput(f);
    }

    public SLDParser(StyleFactory factory, File f) throws FileNotFoundException {
        this(factory);
        this.setInput(f);
    }

    public SLDParser(StyleFactory factory, URL url) throws IOException {
        this(factory);
        this.setInput(url);
    }

    public SLDParser(StyleFactory factory, InputStream s) {
        this(factory);
        this.setInput(s);
    }

    public SLDParser(StyleFactory factory, Reader r) {
        this(factory);
        this.setInput(r);
    }

    public void setInput(String filename) throws FileNotFoundException {
        File f = new File(filename);
        this.source = new InputSource(new FileInputStream(f));
        try {
            this.sourceUrl = f.toURL();
        }
        catch (MalformedURLException e) {
            LOGGER.warning("Can't build URL for file " + f.getAbsolutePath());
        }
    }

    public void setInput(File f) throws FileNotFoundException {
        this.source = new InputSource(new FileInputStream(f));
        try {
            this.sourceUrl = f.toURL();
        }
        catch (MalformedURLException e) {
            LOGGER.warning("Can't build URL for file " + f.getAbsolutePath());
        }
    }

    public void setInput(URL url) throws IOException {
        this.source = new InputSource(url.openStream());
        this.sourceUrl = url;
    }

    public void setInput(InputStream in) {
        this.source = new InputSource(in);
    }

    public void setInput(Reader in) {
        this.source = new InputSource(in);
    }

    public Style[] readXML() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(this.source);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
        return this.readDOM(this.dom);
    }

    public Style[] readDOM(Document document) {
        this.dom = document;
        NodeList nodes = this.findElements(document, "UserStyle");
        if (nodes == null) {
            return new Style[0];
        }
        Style[] styles = new Style[nodes.getLength()];
        for (int i = 0; i < nodes.getLength(); ++i) {
            styles[i] = this.parseStyle(nodes.item(i));
        }
        return styles;
    }

    private NodeList findElements(Document document, String name) {
        NodeList nodes = document.getElementsByTagNameNS("*", name);
        if (nodes.getLength() == 0) {
            nodes = document.getElementsByTagName(name);
        }
        return nodes;
    }

    private NodeList findElements(Element element, String name) {
        NodeList nodes = element.getElementsByTagNameNS("*", name);
        if (nodes.getLength() == 0) {
            nodes = element.getElementsByTagName(name);
        }
        return nodes;
    }

    public StyledLayerDescriptor parseSLD() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(this.source);
            StyledLayerDescriptor sld = this.parseDescriptor(this.dom.getDocumentElement());
            return sld;
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
    }

    public StyledLayerDescriptor parseDescriptor(Node root) {
        StyledLayerDescriptor sld = this.factory.createStyledLayerDescriptor();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            NamedLayer layer;
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("Name")) {
                sld.setName(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("Title")) {
                sld.setTitle(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("Abstract")) {
                sld.setAbstract(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("NamedLayer")) {
                layer = this.parseNamedLayer(child);
                sld.addStyledLayer((StyledLayer)layer);
            }
            if (!childName.equalsIgnoreCase("UserLayer")) continue;
            layer = this.parseUserLayer(child);
            sld.addStyledLayer((StyledLayer)layer);
        }
        return sld;
    }

    private StyledLayer parseUserLayer(Node root) {
        UserLayerImpl layer = new UserLayerImpl();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("InlineFeature")) {
                this.parseInlineFeature(child, layer);
            }
            if (childName.equalsIgnoreCase("UserStyle")) {
                Style user = this.parseStyle(child);
                layer.addUserStyle(user);
            }
            if (childName.equalsIgnoreCase("Name")) {
                String layerName = child.getFirstChild().getNodeValue();
                layer.setName(layerName);
                LOGGER.info("layer name: " + layer.getName());
            }
            if (!childName.equalsIgnoreCase("LayerFeatureConstraints")) continue;
        }
        return layer;
    }

    private void parseInlineFeature(Node root, UserLayer layer) {
        try {
            SLDInlineFeatureParser inparser = new SLDInlineFeatureParser(root);
            layer.setInlineFeatureDatastore((DataStore)inparser.dataStore);
            layer.setInlineFeatureType(inparser.featureType);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
        }
    }

    private NamedLayer parseNamedLayer(Node root) {
        NamedLayerImpl layer = new NamedLayerImpl();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("Name")) {
                layer.setName(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("NamedStyle")) {
                NamedStyle style = this.parseNamedStyle(child);
                layer.addStyle((Style)style);
            }
            if (childName.equalsIgnoreCase("UserStyle")) {
                Style user = this.parseStyle(child);
                layer.addStyle(user);
            }
            if (!childName.equalsIgnoreCase("LayerFeatureConstraints")) continue;
            throw new UnsupportedOperationException("LayerFeatureConstraints pending of implementation");
        }
        return layer;
    }

    public NamedStyle parseNamedStyle(Node n) {
        if (this.dom == null) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                this.dom = db.newDocument();
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException(pce);
            }
        }
        NamedStyle style = this.factory.createNamedStyle();
        NodeList children = n.getChildNodes();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("" + children.getLength() + " children to process");
        }
        for (int j = 0; j < children.getLength(); ++j) {
            String childName;
            Node child = children.item(j);
            if (child == null || child.getNodeType() != 1 || child.getFirstChild() == null) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("processing " + child.getLocalName());
            }
            if ((childName = child.getLocalName()) == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase("Name")) continue;
            style.setName(child.getFirstChild().getNodeValue());
        }
        return style;
    }

    private StyledLayerImpl parseLayer(Node root) {
        StyledLayerImpl layer = null;
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("NamedLayer")) {
                layer = new NamedLayerImpl();
            }
            if (!childName.equalsIgnoreCase("UserLayer")) continue;
            layer = new UserLayerImpl();
        }
        return layer;
    }

    public Style parseStyle(Node n) {
        if (this.dom == null) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                this.dom = db.newDocument();
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException(pce);
            }
        }
        Style style = this.factory.createStyle();
        NodeList children = n.getChildNodes();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("" + children.getLength() + " children to process");
        }
        for (int j = 0; j < children.getLength(); ++j) {
            String childName;
            Node child = children.item(j);
            if (child == null || child.getNodeType() != 1 || child.getFirstChild() == null) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("processing " + child.getLocalName());
            }
            if ((childName = child.getLocalName()) == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("Name")) {
                style.setName(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("Title")) {
                style.setTitle(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("Abstract")) {
                style.setAbstract(child.getFirstChild().getNodeValue());
            }
            if (!childName.equalsIgnoreCase("FeatureTypeStyle")) continue;
            style.addFeatureTypeStyle(this.parseFeatureTypeStyle(child));
        }
        return style;
    }

    private FeatureTypeStyle parseFeatureTypeStyle(Node style) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Parsing featuretype style " + style.getLocalName());
        }
        FeatureTypeStyle ft = this.factory.createFeatureTypeStyle();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<String> sti = new ArrayList<String>();
        NodeList children = style.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("processing " + child.getLocalName());
            }
            if ((childName = child.getLocalName()) == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("Name")) {
                ft.setName(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("Title")) {
                ft.setTitle(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("Abstract")) {
                ft.setAbstract(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("FeatureTypeName")) {
                ft.setFeatureTypeName(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("SemanticTypeIdentifier")) {
                sti.add(child.getFirstChild().getNodeValue());
            }
            if (!childName.equalsIgnoreCase("Rule")) continue;
            rules.add(this.parseRule(child));
        }
        if (sti.size() > 0) {
            ft.setSemanticTypeIdentifiers(sti.toArray(new String[0]));
        }
        ft.setRules(rules.toArray(new Rule[0]));
        return ft;
    }

    private Rule parseRule(Node ruleNode) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Parsing rule " + ruleNode.getLocalName());
        }
        Rule rule = this.factory.createRule();
        ArrayList<Object> symbolizers = new ArrayList<Object>();
        NodeList children = ruleNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.indexOf(58) != -1) {
                childName = childName.substring(childName.indexOf(58) + 1);
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("processing " + child.getLocalName());
            }
            if (childName.equalsIgnoreCase("Name")) {
                rule.setName(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("Title")) {
                rule.setTitle(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("Abstract")) {
                rule.setAbstract(child.getFirstChild().getNodeValue());
            }
            if (childName.equalsIgnoreCase("MinScaleDenominator")) {
                rule.setMinScaleDenominator(Double.parseDouble(child.getFirstChild().getNodeValue()));
            }
            if (childName.equalsIgnoreCase("MaxScaleDenominator")) {
                rule.setMaxScaleDenominator(Double.parseDouble(child.getFirstChild().getNodeValue()));
            }
            if (childName.equalsIgnoreCase("Filter")) {
                Node firstChild;
                for (firstChild = child.getFirstChild(); firstChild != null && firstChild.getNodeType() != 1; firstChild = firstChild.getNextSibling()) {
                }
                org.geotools.filter.Filter filter = FilterDOMParser.parseFilter(firstChild);
                rule.setFilter((Filter)filter);
            }
            if (childName.equalsIgnoreCase("ElseFilter")) {
                rule.setIsElseFilter(true);
            }
            if (childName.equalsIgnoreCase("LegendGraphic")) {
                this.findElements((Element)child, this.graphicSt);
                NodeList g = this.findElements((Element)child, this.graphicSt);
                ArrayList<Graphic> legends = new ArrayList<Graphic>();
                for (int k = 0; k < g.getLength(); ++k) {
                    legends.add(this.parseGraphic(g.item(k)));
                }
                rule.setLegendGraphic(legends.toArray(new Graphic[0]));
            }
            if (childName.equalsIgnoreCase("LineSymbolizer")) {
                symbolizers.add(this.parseLineSymbolizer(child));
            }
            if (childName.equalsIgnoreCase("PolygonSymbolizer")) {
                symbolizers.add(this.parsePolygonSymbolizer(child));
            }
            if (childName.equalsIgnoreCase("PointSymbolizer")) {
                symbolizers.add(this.parsePointSymbolizer(child));
            }
            if (childName.equalsIgnoreCase("TextSymbolizer")) {
                symbolizers.add(this.parseTextSymbolizer(child));
            }
            if (!childName.equalsIgnoreCase("RasterSymbolizer")) continue;
            symbolizers.add(this.parseRasterSymbolizer(child));
        }
        rule.setSymbolizers(symbolizers.toArray(new Symbolizer[0]));
        return rule;
    }

    private LineSymbolizer parseLineSymbolizer(Node root) {
        LineSymbolizer symbol = this.factory.createLineSymbolizer();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(this.geomSt)) {
                symbol.setGeometryPropertyName(this.parseGeometryName(child));
            }
            if (!childName.equalsIgnoreCase("Stroke")) continue;
            symbol.setStroke(this.parseStroke(child));
        }
        return symbol;
    }

    private PolygonSymbolizer parsePolygonSymbolizer(Node root) {
        PolygonSymbolizer symbol = this.factory.createPolygonSymbolizer();
        symbol.setFill((Fill)null);
        symbol.setStroke((Stroke)null);
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(this.geomSt)) {
                symbol.setGeometryPropertyName(this.parseGeometryName(child));
            }
            if (childName.equalsIgnoreCase("Stroke")) {
                symbol.setStroke(this.parseStroke(child));
            }
            if (!childName.equalsIgnoreCase(this.fillSt)) continue;
            symbol.setFill(this.parseFill(child));
        }
        return symbol;
    }

    private TextSymbolizer parseTextSymbolizer(Node root) {
        TextSymbolizer symbol = this.factory.createTextSymbolizer();
        symbol.setFill(null);
        ArrayList<Font> fonts = new ArrayList<Font>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(this.geomSt)) {
                symbol.setGeometryPropertyName(this.parseGeometryName(child));
            }
            if (childName.equalsIgnoreCase(this.fillSt)) {
                symbol.setFill(this.parseFill(child));
            }
            if (childName.equalsIgnoreCase("Label")) {
                LOGGER.finest("parsing label " + child.getNodeValue());
                symbol.setLabel(this.parseCssParameter(child));
                if (symbol.getLabel() == null) {
                    LOGGER.warning("parsing TextSymbolizer node - couldnt find anything in the Label element!");
                }
            }
            if (childName.equalsIgnoreCase("Font")) {
                fonts.add(this.parseFont(child));
            }
            if (childName.equalsIgnoreCase("LabelPlacement")) {
                symbol.setPlacement(this.parseLabelPlacement(child));
            }
            if (childName.equalsIgnoreCase("Halo")) {
                symbol.setHalo(this.parseHalo(child));
            }
            if (childName.equalsIgnoreCase("Graphic")) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Parsing non-standard Graphic in TextSymbolizer");
                }
                if (symbol instanceof TextSymbolizer2) {
                    ((TextSymbolizer2)symbol).setGraphic(this.parseGraphic(child));
                }
            }
            if (childName.equalsIgnoreCase("priority")) {
                symbol.setPriority(this.parseCssParameter(child));
            }
            if (!childName.equalsIgnoreCase("vendoroption")) continue;
            this.parseVendorOption(symbol, child);
        }
        symbol.setFonts(fonts.toArray(new Font[0]));
        return symbol;
    }

    private void parseVendorOption(TextSymbolizer symbol, Node child) {
        String key = child.getAttributes().getNamedItem("name").getNodeValue();
        String value = child.getFirstChild().getNodeValue();
        symbol.addToOptions(key, value);
    }

    private Expression parseLiteral(Node root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase("Literal")) continue;
            try {
                return (Expression)ExpressionBuilder.parse(child.getFirstChild().getNodeValue());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private RasterSymbolizer parseRasterSymbolizer(Node root) {
        RasterSymbolizer symbol = this.factory.getDefaultRasterSymbolizer();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(this.geomSt)) {
                symbol.setGeometryPropertyName(this.parseGeometryName(child));
            }
            if (childName.equalsIgnoreCase("Opacity")) {
                try {
                    symbol.setOpacity((Expression)ExpressionBuilder.parse(child.getFirstChild().getNodeValue()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (childName.equalsIgnoreCase("ChannelSelection")) {
                symbol.setChannelSelection(this.parseChannelSelection(child));
            }
            if (childName.equalsIgnoreCase("OverlapBehavior")) {
                try {
                    symbol.setOverlap((Expression)ExpressionBuilder.parse(child.getFirstChild().getNodeValue()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (childName.equalsIgnoreCase("ColorMap")) {
                symbol.setColorMap(this.parseColorMap(child));
            }
            if (childName.equalsIgnoreCase("ContrastEnhancement")) {
                symbol.setContrastEnhancement(this.parseContrastEnhancement(child));
            }
            if (childName.equalsIgnoreCase("ShadedRelief")) {
                symbol.setShadedRelief(this.parseShadedRelief(child));
            }
            if (!childName.equalsIgnoreCase("ImageOutline")) continue;
            symbol.setImageOutline((Symbolizer)this.parseLineSymbolizer(child));
        }
        return symbol;
    }

    private ColorMapEntry parseColorMapEntry(Node root) {
        ColorMapEntry symbol = this.factory.createColorMapEntry();
        NamedNodeMap atts = root.getAttributes();
        if (atts.getNamedItem("label") != null) {
            symbol.setLabel(atts.getNamedItem("label").getNodeValue());
        }
        if (atts.getNamedItem("color") != null) {
            symbol.setColor((Expression)this.ff.literal((Object)atts.getNamedItem("color").getNodeValue()));
        }
        if (atts.getNamedItem("opacity") != null) {
            symbol.setOpacity((Expression)this.ff.literal((Object)atts.getNamedItem("opacity").getNodeValue()));
        }
        if (atts.getNamedItem("quantity") != null) {
            symbol.setQuantity((Expression)this.ff.literal((Object)atts.getNamedItem("quantity").getNodeValue()));
        }
        return symbol;
    }

    private ColorMap parseColorMap(Node root) {
        ColorMap symbol = this.factory.createColorMap();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase("ColorMapEntry")) continue;
            symbol.addColorMapEntry(this.parseColorMapEntry(child));
        }
        return symbol;
    }

    private SelectedChannelType parseSelectedChannel(Node root) {
        SelectedChannelTypeImpl symbol = new SelectedChannelTypeImpl();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("SourceChannelName")) {
                symbol.setChannelName(child.getNodeValue());
            }
            if (!childName.equalsIgnoreCase("ContrastEnhancement")) continue;
            try {
                symbol.setContrastEnhancement((Expression)ExpressionBuilder.parse(child.getNodeValue()));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return symbol;
    }

    private ChannelSelection parseChannelSelection(Node root) {
        LinkedList<SelectedChannelType> channels = new LinkedList<SelectedChannelType>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("GrayChannel")) {
                channels.add(this.parseSelectedChannel(child));
            }
            if (childName.equalsIgnoreCase("RedChannel")) {
                channels.add(this.parseSelectedChannel(child));
            }
            if (childName.equalsIgnoreCase("GreenChannel")) {
                channels.add(this.parseSelectedChannel(child));
            }
            if (!childName.equalsIgnoreCase("BlueChannel")) continue;
            channels.add(this.parseSelectedChannel(child));
        }
        ChannelSelection dap = this.factory.createChannelSelection(channels.toArray(new SelectedChannelType[channels.size()]));
        return dap;
    }

    private ContrastEnhancement parseContrastEnhancement(Node root) {
        ContrastEnhancementImpl symbol = new ContrastEnhancementImpl();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("Normalize")) {
                symbol.setNormalize();
            }
            if (childName.equalsIgnoreCase("Histogram")) {
                symbol.setHistogram();
            }
            if (!childName.equalsIgnoreCase("GammaValue")) continue;
            try {
                symbol.setGammaValue((Expression)ExpressionBuilder.parse(child.getNodeValue()));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return symbol;
    }

    private ShadedRelief parseShadedRelief(Node root) {
        ShadedReliefImpl symbol = new ShadedReliefImpl();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("BrightnessOnly")) {
                symbol.setBrightnessOnly(Boolean.getBoolean(child.getFirstChild().getNodeValue()));
            }
            if (!childName.equalsIgnoreCase("ReliefFactor")) continue;
            try {
                symbol.setReliefFactor((Expression)ExpressionBuilder.parse(child.getNodeValue()));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return symbol;
    }

    private PointSymbolizer parsePointSymbolizer(Node root) {
        PointSymbolizer symbol = this.factory.getDefaultPointSymbolizer();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(this.geomSt)) {
                symbol.setGeometryPropertyName(this.parseGeometryName(child));
            }
            if (!childName.equalsIgnoreCase(this.graphicSt)) continue;
            symbol.setGraphic(this.parseGraphic(child));
        }
        return symbol;
    }

    private Graphic parseGraphic(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("processing graphic " + root);
        }
        Graphic graphic = this.factory.getDefaultGraphic();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(this.geomSt)) {
                graphic.setGeometryPropertyName(this.parseGeometryName(child));
            }
            if (childName.equalsIgnoreCase("ExternalGraphic")) {
                LOGGER.finest("parsing extgraphic " + child);
                graphic.addExternalGraphic(this.parseExternalGraphic(child));
            }
            if (childName.equalsIgnoreCase("Mark")) {
                graphic.addMark(this.parseMark(child));
            }
            if (childName.equalsIgnoreCase("opacity")) {
                graphic.setOpacity(this.parseCssParameter(child));
            }
            if (childName.equalsIgnoreCase("size")) {
                graphic.setSize(this.parseCssParameter(child));
            }
            if (childName.equalsIgnoreCase("displacement")) {
                graphic.setDisplacement(this.parseDisplacement(child));
            }
            if (!childName.equalsIgnoreCase("rotation")) continue;
            graphic.setRotation(this.parseCssParameter(child));
        }
        return graphic;
    }

    private String parseGeometryName(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing GeometryName");
        }
        String ret = null;
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            ret = this.parseCssParameter(child).toString();
        }
        return ret;
    }

    private Mark parseMark(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing mark");
        }
        Mark mark = this.factory.createMark();
        mark.setFill(null);
        mark.setStroke(null);
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("Stroke")) {
                mark.setStroke(this.parseStroke(child));
            }
            if (childName.equalsIgnoreCase(this.fillSt)) {
                mark.setFill(this.parseFill(child));
            }
            if (!childName.equalsIgnoreCase("WellKnownName")) continue;
            LOGGER.finest("setting mark to " + child.getFirstChild().getNodeValue());
            mark.setWellKnownName(this.parseCssParameter(child));
        }
        return mark;
    }

    private ExternalGraphic parseExternalGraphic(Node root) {
        URL url;
        HashMap<String, Expression> paramList;
        String uri;
        String format;
        block11: {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("processing external graphic ");
            }
            format = "";
            uri = "";
            paramList = new HashMap<String, Expression>();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child == null || child.getNodeType() != 1) continue;
                String childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (childName.equalsIgnoreCase("OnLineResource")) {
                    Element param = (Element)child;
                    NamedNodeMap map = param.getAttributes();
                    LOGGER.finest("attributes " + map.toString());
                    for (int k = 0; k < map.getLength(); ++k) {
                        String res = map.item(k).getNodeValue();
                        String name = map.item(k).getNodeName();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("processing attribute " + name + "=" + res);
                        }
                        if (!name.equalsIgnoreCase("xlink:href")) continue;
                        LOGGER.finest("seting ExtGraph uri " + res);
                        uri = res;
                    }
                }
                if (childName.equalsIgnoreCase("format")) {
                    LOGGER.finest("format child is " + child);
                    LOGGER.finest("seting ExtGraph format " + child.getFirstChild().getNodeValue());
                    format = child.getFirstChild().getNodeValue();
                }
                if (!childName.equalsIgnoreCase("customProperty")) continue;
                LOGGER.finest("custom child is " + child);
                String propName = child.getAttributes().getNamedItem("name").getNodeValue();
                LOGGER.finest("seting custom property " + propName + " to " + child.getFirstChild().getNodeValue());
                Expression value = this.parseCssParameter(child);
                paramList.put(propName, value);
            }
            url = null;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException mfe) {
                LOGGER.fine("Looks like " + uri + " is a relative path..");
                if (this.sourceUrl == null) break block11;
                try {
                    url = new URL(this.sourceUrl, uri);
                }
                catch (MalformedURLException e) {
                    LOGGER.warning("can't parse " + uri + " as relative to" + this.sourceUrl.toExternalForm());
                }
            }
        }
        ExternalGraphic extgraph = url == null ? this.factory.createExternalGraphic(uri, format) : this.factory.createExternalGraphic(url, format);
        extgraph.setCustomProperties(paramList);
        return extgraph;
    }

    private Stroke parseStroke(Node root) {
        Graphic g;
        String childName;
        Node child;
        int i;
        NodeList kids;
        Stroke stroke = this.factory.getDefaultStroke();
        NodeList list = this.findElements((Element)root, "GraphicFill");
        if (list.getLength() > 0) {
            LOGGER.finest("stroke: found a graphic fill " + list.item(0));
            kids = list.item(0).getChildNodes();
            for (i = 0; i < kids.getLength(); ++i) {
                child = kids.item(i);
                if (child == null || child.getNodeType() != 1) continue;
                childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (!childName.equalsIgnoreCase(this.graphicSt)) continue;
                g = this.parseGraphic(child);
                LOGGER.finest("setting stroke graphicfill with " + g);
                stroke.setGraphicFill(g);
            }
        }
        if ((list = this.findElements((Element)root, "GraphicStroke")).getLength() > 0) {
            LOGGER.finest("stroke: found a graphic stroke " + list.item(0));
            kids = list.item(0).getChildNodes();
            for (i = 0; i < kids.getLength(); ++i) {
                child = kids.item(i);
                if (child == null || child.getNodeType() != 1) continue;
                childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (!childName.equalsIgnoreCase(this.graphicSt)) continue;
                g = this.parseGraphic(child);
                LOGGER.finest("setting stroke graphicStroke with " + g);
                stroke.setGraphicStroke(g);
            }
        }
        list = this.findElements((Element)root, "CssParameter");
        for (int i2 = 0; i2 < list.getLength(); ++i2) {
            Node child2 = list.item(i2);
            if (child2 == null || child2.getNodeType() != 1) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("now I am processing " + child2);
            }
            Element param = (Element)child2;
            NamedNodeMap map = param.getAttributes();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("attributes " + map.toString());
            }
            for (int k = 0; k < map.getLength(); ++k) {
                String res = map.item(k).getNodeValue();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("processing attribute " + res);
                }
                if (res.equalsIgnoreCase("stroke")) {
                    stroke.setColor(this.parseCssParameter(child2));
                }
                if (res.equalsIgnoreCase("width") || res.equalsIgnoreCase("stroke-width")) {
                    stroke.setWidth(this.parseCssParameter(child2));
                }
                if (res.equalsIgnoreCase("opacity") || res.equalsIgnoreCase("stroke-opacity")) {
                    stroke.setOpacity(this.parseCssParameter(child2));
                }
                if (res.equalsIgnoreCase("linecap") || res.equalsIgnoreCase("stroke-linecap")) {
                    stroke.setLineCap(this.parseCssParameter(child2));
                }
                if (res.equalsIgnoreCase("linejoin") || res.equalsIgnoreCase("stroke-linejoin")) {
                    stroke.setLineJoin(this.parseCssParameter(child2));
                }
                if (res.equalsIgnoreCase("dasharray") || res.equalsIgnoreCase("stroke-dasharray")) {
                    String dashString = child2.getFirstChild().getNodeValue();
                    StringTokenizer stok = new StringTokenizer(dashString, " ");
                    float[] dashes = new float[stok.countTokens()];
                    for (int l = 0; l < dashes.length; ++l) {
                        dashes[l] = Float.parseFloat(stok.nextToken());
                    }
                    stroke.setDashArray(dashes);
                }
                if (!res.equalsIgnoreCase("dashoffset") && !res.equalsIgnoreCase("stroke-dashoffset")) continue;
                stroke.setDashOffset(this.parseCssParameter(child2));
            }
        }
        return stroke;
    }

    private Fill parseFill(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing fill ");
        }
        Fill fill = this.factory.getDefaultFill();
        NodeList list = this.findElements((Element)root, "GraphicFill");
        if (list.getLength() > 0) {
            LOGGER.finest("fill found a graphic fill " + list.item(0));
            NodeList kids = list.item(0).getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node child = kids.item(i);
                if (child == null || child.getNodeType() != 1) continue;
                String childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (!childName.equalsIgnoreCase(this.graphicSt)) continue;
                Graphic g = this.parseGraphic(child);
                LOGGER.finest("setting fill graphic with " + g);
                fill.setGraphicFill(g);
            }
        }
        list = this.findElements((Element)root, "CssParameter");
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            Element param = (Element)child;
            NamedNodeMap map = param.getAttributes();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("now I am processing " + child);
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("attributes " + map.toString());
            }
            for (int k = 0; k < map.getLength(); ++k) {
                String res = map.item(k).getNodeValue();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("processing attribute " + res);
                }
                if (res.equalsIgnoreCase(this.fillSt)) {
                    fill.setColor(this.parseCssParameter(child));
                }
                if (!res.equalsIgnoreCase("opacity") && !res.equalsIgnoreCase("fill-opacity")) continue;
                fill.setOpacity(this.parseCssParameter(child));
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("fill graphic " + fill.getGraphicFill());
        }
        return fill;
    }

    private Expression parseCssParameter(Node root) {
        org.geotools.filter.Expression ret = null;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsingCssParam " + root);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("about to parse " + child.getLocalName());
            }
            ret = ExpressionDOMParser.parseExpression(child);
            break;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("no children in CssParam");
        }
        if (ret == null) {
            String value = root.getFirstChild().getNodeValue();
            value = value != null ? value.trim() : value;
            Element literal = this.dom.createElement("literal");
            Text child = this.dom.createTextNode(value);
            literal.appendChild(child);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Built new literal " + literal);
            }
            ret = ExpressionDOMParser.parseExpression(literal);
        }
        return ret;
    }

    private Font parseFont(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing font");
        }
        Font font = this.factory.getDefaultFont();
        NodeList list = this.findElements((Element)root, "CssParameter");
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            Element param = (Element)child;
            NamedNodeMap map = param.getAttributes();
            for (int k = 0; k < map.getLength(); ++k) {
                String res = map.item(k).getNodeValue();
                if (res.equalsIgnoreCase("font-family")) {
                    font.setFontFamily(this.parseCssParameter(child));
                }
                if (res.equalsIgnoreCase("font-style")) {
                    font.setFontStyle(this.parseCssParameter(child));
                }
                if (res.equalsIgnoreCase("font-size")) {
                    font.setFontSize(this.parseCssParameter(child));
                }
                if (!res.equalsIgnoreCase("font-weight")) continue;
                font.setFontWeight(this.parseCssParameter(child));
            }
        }
        return font;
    }

    private LabelPlacement parseLabelPlacement(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing labelPlacement");
        }
        PointPlacement ret = null;
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("PointPlacement")) {
                ret = this.parsePointPlacement(child);
            }
            if (!childName.equalsIgnoreCase("LinePlacement")) continue;
            ret = this.parseLinePlacement(child);
        }
        return ret;
    }

    private PointPlacement parsePointPlacement(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing pointPlacement");
        }
        Literal rotation = this.ff.literal(0.0);
        AnchorPoint ap = null;
        Displacement dp = null;
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("AnchorPoint")) {
                ap = this.parseAnchorPoint(child);
            }
            if (childName.equalsIgnoreCase("Displacement")) {
                dp = this.parseDisplacement(child);
            }
            if (!childName.equalsIgnoreCase("Rotation")) continue;
            rotation = this.parseCssParameter(child);
        }
        LOGGER.fine("setting anchorPoint " + ap);
        LOGGER.fine("setting displacement " + dp);
        PointPlacement dpp = this.factory.createPointPlacement(ap, dp, (Expression)rotation);
        return dpp;
    }

    private LinePlacement parseLinePlacement(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing linePlacement");
        }
        Literal offset = this.ff.literal(0.0);
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase("PerpendicularOffset")) continue;
            offset = this.parseCssParameter(child);
        }
        LinePlacement dlp = this.factory.createLinePlacement((Expression)offset);
        return dlp;
    }

    private AnchorPoint parseAnchorPoint(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing anchorPoint");
        }
        Expression x = null;
        Expression y = null;
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("AnchorPointX")) {
                x = this.parseCssParameter(child);
            }
            if (!childName.equalsIgnoreCase("AnchorPointY")) continue;
            y = this.parseCssParameter(child);
        }
        AnchorPoint dap = this.factory.createAnchorPoint(x, y);
        return dap;
    }

    private Displacement parseDisplacement(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing displacment");
        }
        Expression x = null;
        Expression y = null;
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("DisplacementX")) {
                x = this.parseCssParameter(child);
            }
            if (!childName.equalsIgnoreCase("DisplacementY")) continue;
            y = this.parseCssParameter(child);
        }
        Displacement dd = this.factory.createDisplacement(x, y);
        return dd;
    }

    private Halo parseHalo(Node root) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("parsing halo");
        }
        Halo halo = this.factory.createHalo(this.factory.createFill((Expression)this.ff.literal((Object)"#FFFFFF")), (Expression)this.ff.literal(1.0));
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase(this.fillSt)) {
                halo.setFill(this.parseFill(child));
            }
            if (!childName.equalsIgnoreCase("Radius")) continue;
            halo.setRadius(this.parseCssParameter(child));
        }
        return halo;
    }
}

