/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.geotools.gml.SubHandler;
import org.geotools.gml.SubHandlerLinearRing;

public class SubHandlerPolygon
extends SubHandler {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.gml");
    protected static CGAlgorithms cga = new RobustCGAlgorithms();
    private GeometryFactory geometryFactory = new GeometryFactory();
    private SubHandlerLinearRing currentHandler = new SubHandlerLinearRing();
    private LinearRing outerBoundary = null;
    private ArrayList innerBoundaries = new ArrayList();
    private int location = 0;
    private int INNER_BOUNDARY = 1;
    private int OUTER_BOUNDARY = 2;

    public void subGeometry(String message, int type) {
        if (message.equals("LinearRing")) {
            if (type == 2) {
                if (this.location == this.INNER_BOUNDARY) {
                    LinearRing ring = (LinearRing)this.currentHandler.create(this.geometryFactory);
                    Coordinate[] points = ring.getCoordinates();
                    if (CGAlgorithms.isCCW((Coordinate[])points)) {
                        LOGGER.finer("good hole found");
                        this.innerBoundaries.add(ring);
                    } else {
                        LOGGER.finer("bad hole found - fixing");
                        Coordinate[] newPoints = new Coordinate[points.length];
                        int i = 0;
                        int j = points.length - 1;
                        while (i < points.length) {
                            newPoints[i] = points[j];
                            ++i;
                            --j;
                        }
                        try {
                            ring = this.geometryFactory.createLinearRing(newPoints);
                            this.innerBoundaries.add(ring);
                        }
                        catch (TopologyException e) {
                            LOGGER.warning("Caught Topology exception in GMLPolygonHandler");
                            ring = null;
                        }
                    }
                } else if (this.location == this.OUTER_BOUNDARY) {
                    this.outerBoundary = (LinearRing)this.currentHandler.create(this.geometryFactory);
                    Coordinate[] points = this.outerBoundary.getCoordinates();
                    if (CGAlgorithms.isCCW((Coordinate[])points)) {
                        LOGGER.finer("bad outer ring - rebuilding");
                        Coordinate[] newPoints = new Coordinate[points.length];
                        int i = 0;
                        int j = points.length - 1;
                        while (i < points.length) {
                            newPoints[i] = points[j];
                            ++i;
                            --j;
                        }
                        try {
                            this.outerBoundary = this.geometryFactory.createLinearRing(newPoints);
                        }
                        catch (TopologyException e) {
                            LOGGER.warning("Caught Topology exception in GMLPolygonHandler");
                            this.outerBoundary = null;
                        }
                    }
                }
            } else if (type == 1) {
                this.currentHandler = new SubHandlerLinearRing();
            }
        } else if (message.equals("outerBoundaryIs")) {
            LOGGER.finer("new outer Boundary");
            this.location = this.OUTER_BOUNDARY;
        } else if (message.equals("innerBoundaryIs")) {
            LOGGER.finer("new InnerBoundary");
            this.location = this.INNER_BOUNDARY;
        }
    }

    public void addCoordinate(Coordinate coordinate) {
        this.currentHandler.addCoordinate(coordinate);
    }

    public boolean isComplete(String message) {
        if (message.equals("Polygon")) {
            return this.outerBoundary != null;
        }
        return false;
    }

    public Geometry create(GeometryFactory geometryFactory) {
        for (int i = 0; i < this.innerBoundaries.size(); ++i) {
            LinearRing hole = (LinearRing)this.innerBoundaries.get(i);
            if (!hole.crosses((Geometry)this.outerBoundary)) continue;
            LOGGER.warning("Topology Error building polygon");
            return null;
        }
        LinearRing[] rings = this.innerBoundaries.toArray(new LinearRing[this.innerBoundaries.size()]);
        Polygon polygon = geometryFactory.createPolygon(this.outerBoundary, rings);
        polygon.setUserData((Object)this.getSRS());
        polygon.setSRID(this.getSRID());
        return polygon;
    }
}

