/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.Collections;
import org.geotools.feature.DefaultAttributeType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.type.CSGeometryFactory;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.feature.type.TypeName;
import org.geotools.referencing.crs.DefaultGeocentricCRS;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometricAttributeType
extends DefaultAttributeType
implements GeometryAttributeType {
    protected GeometryFactory geometryFactory;

    public GeometricAttributeType(String name, Class type, boolean nillable, int min, int max, Object defaultValue, CoordinateReferenceSystem crs, Filter filter) {
        super((AttributeType)GeometricAttributeType.createAttributeType(name, type, crs, filter), name, nillable, min, max, defaultValue);
        this.geometryFactory = this.getCoordinateSystem() == null ? CSGeometryFactory.DEFAULT : new CSGeometryFactory(this.getCoordinateSystem());
    }

    public GeometricAttributeType(String name, Class type, boolean nillable, Object defaultValue, CoordinateReferenceSystem cs, Filter filter) {
        this(name, type, nillable, 1, 1, defaultValue, cs, filter);
    }

    public GeometricAttributeType(GeometricAttributeType copy, CoordinateReferenceSystem override) {
        this(copy.getLocalName(), copy.getBinding(), copy.isNillable(), copy.getMinOccurs(), copy.getMaxOccurs(), null, GeometricAttributeType.crs(override), copy.getRestriction());
        this.geometryFactory = this.getCoordinateSystem() == DefaultGeocentricCRS.CARTESIAN ? CSGeometryFactory.DEFAULT : new CSGeometryFactory(this.getCoordinateSystem());
    }

    protected GeometricAttributeType(GeometryType type, Name name, int min, int max, boolean isNillable, Object defaultValue) {
        super((AttributeType)type, name, min, max, isNillable, defaultValue);
    }

    public CoordinateReferenceSystem getCoordinateSystem() {
        return ((GeometryType)this.getType()).getCRS();
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public Object duplicate(Object o) throws IllegalAttributeException {
        if (o == null) {
            return o;
        }
        if (o instanceof Geometry) {
            return ((Geometry)o).clone();
        }
        throw new IllegalAttributeException("Cannot duplicate " + o.getClass().getName());
    }

    public static CoordinateReferenceSystem crs(CoordinateReferenceSystem override) {
        CoordinateReferenceSystem crs = override;
        if (override != null) {
            crs = override;
        }
        if (crs == null) {
            crs = DefaultGeocentricCRS.CARTESIAN;
        }
        return crs;
    }

    public static GeometryType createAttributeType(String name, Class binding, CoordinateReferenceSystem crs, Filter restriction) {
        return new GeometryTypeImpl((Name)new TypeName(name), binding, crs, false, false, restriction != null ? Collections.singleton(restriction) : Collections.EMPTY_SET, null, null);
    }
}

