/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.List;
import org.geotools.feature.type.DescriptorValidator;
import org.geotools.feature.type.StructuralDescriptorImpl;
import org.geotools.resources.Utilities;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyType;

public class AttributeDescriptorImpl
extends StructuralDescriptorImpl
implements AttributeDescriptor {
    protected final AttributeType type;
    protected boolean isNillable;
    protected final Object defaultValue;

    public AttributeDescriptorImpl(AttributeType type, Name name, int min, int max, boolean isNillable, Object defaultValue) {
        super(name, min, max);
        if (type == null) {
            throw new NullPointerException();
        }
        if (min < 0 || max < 0 || max < min) {
            throw new IllegalArgumentException("min(" + min + ") and max(" + max + ") must be positive integers and max must be greater than or equal to min");
        }
        this.type = type;
        this.isNillable = isNillable;
        this.defaultValue = defaultValue;
    }

    public boolean isNillable() {
        return this.isNillable;
    }

    public AttributeType getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public PropertyType type() {
        return this.getType();
    }

    public void validate(List content) throws NullPointerException, IllegalArgumentException {
        DescriptorValidator.validate(this, content);
    }

    public int hashCode() {
        return super.hashCode() ^ this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AttributeDescriptorImpl)) {
            return false;
        }
        AttributeDescriptorImpl d = (AttributeDescriptorImpl)o;
        if (!Utilities.equals((Object)this.defaultValue, (Object)d.defaultValue)) {
            return false;
        }
        return super.equals(d) && this.type.equals(d.type) && this.isNillable == d.isNillable;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AttributeDescriptor ").append(this.name.getLocalPart()).append(":").append(this.type.getName().getLocalPart());
        return sb.toString();
    }
}

