/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import org.geotools.feature.AttributeImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.resources.Utilities;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryAttributeImpl
extends AttributeImpl
implements GeometryAttribute {
    protected CoordinateReferenceSystem crs;
    private BoundingBox bounds;

    public GeometryAttributeImpl(Object content, AttributeDescriptor descriptor, String id, CoordinateReferenceSystem crs) {
        super(content, descriptor, id);
        this.crs = crs;
        if (!(descriptor.getType() instanceof GeometryType)) {
            throw new IllegalArgumentException("Expected GeometryType, got " + descriptor);
        }
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public void setCRS(CoordinateReferenceSystem coordinateSystem) {
        this.crs = coordinateSystem;
    }

    public Object getValue() {
        return (Geometry)super.getValue();
    }

    public void setValue(Geometry geometry) {
        super.setValue(geometry);
    }

    public synchronized void setBounds(BoundingBox bbox) {
        this.bounds = bbox;
    }

    public synchronized BoundingBox getBounds() {
        if (this.bounds == null) {
            ReferencedEnvelope bbox = new ReferencedEnvelope(this.crs);
            Geometry geom = (Geometry)this.getValue();
            if (geom != null) {
                bbox.expandToInclude(geom.getEnvelopeInternal());
            }
            this.bounds = bbox;
        }
        return this.bounds;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GeometryAttributeImpl)) {
            return false;
        }
        GeometryAttributeImpl att = (GeometryAttributeImpl)o;
        if (!Utilities.equals((Object)this.DESCRIPTOR, (Object)att.DESCRIPTOR)) {
            return false;
        }
        if (!Utilities.equals((Object)this.TYPE, (Object)att.TYPE)) {
            return false;
        }
        if (!Utilities.equals((Object)this.ID, (Object)att.ID)) {
            return false;
        }
        if (this.content != null && att.content != null) {
            if (!((Geometry)this.content).equals((Geometry)att.content)) {
                return false;
            }
        } else {
            return Utilities.equals((Object)this.content, (Object)this.content);
        }
        return Utilities.equals((Object)this.getBounds(), (Object)att.getBounds()) && Utilities.equals((Object)this.crs, (Object)att.crs);
    }

    public int hashCode() {
        int hash = super.hashCode();
        if (this.bounds != null) {
            hash ^= this.bounds.hashCode();
        }
        if (this.crs != null) {
            hash ^= this.crs.hashCode();
        }
        return hash;
    }
}

