/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class ReprojectFeatureReader
implements FeatureReader {
    FeatureReader reader;
    FeatureType schema;
    GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();

    public ReprojectFeatureReader(FeatureReader reader, FeatureType schema, MathTransform transform) {
        this.reader = reader;
        this.schema = schema;
        this.transformer.setMathTransform((MathTransform)((MathTransform2D)transform));
    }

    public ReprojectFeatureReader(FeatureReader reader, CoordinateReferenceSystem cs) throws SchemaException, OperationNotFoundException, NoSuchElementException, FactoryException {
        if (cs == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        FeatureType type = reader.getFeatureType();
        CoordinateReferenceSystem original = type.getPrimaryGeometry().getCoordinateSystem();
        if (cs.equals(original)) {
            throw new IllegalArgumentException("CoordinateSystem " + cs + " already used (check before using wrapper)");
        }
        this.schema = FeatureTypes.transform(type, cs);
        this.reader = reader;
        this.transformer.setMathTransform(CRS.findMathTransform((CoordinateReferenceSystem)original, (CoordinateReferenceSystem)cs, (boolean)true));
    }

    public FeatureType getFeatureType() {
        if (this.schema == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.schema;
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        Feature next = this.reader.next();
        Object[] attributes = next.getAttributes(null);
        try {
            for (int i = 0; i < attributes.length; ++i) {
                if (!(attributes[i] instanceof Geometry)) continue;
                attributes[i] = this.transformer.transform((Geometry)attributes[i]);
            }
        }
        catch (TransformException e) {
            throw new DataSourceException("A transformation exception occurred while reprojecting data on the fly", (Throwable)e);
        }
        return this.schema.create(attributes, next.getID());
    }

    public boolean hasNext() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    public void close() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        this.reader.close();
        this.reader = null;
        this.schema = null;
    }
}

