/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class ReprojectFeatureIterator
implements Iterator {
    FeatureIterator reader;
    FeatureType schema;
    GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();

    public ReprojectFeatureIterator(FeatureIterator reader, FeatureType schema, MathTransform transform) {
        this.reader = reader;
        this.schema = schema;
        this.transformer.setMathTransform((MathTransform)((MathTransform2D)transform));
    }

    public FeatureType getFeatureType() {
        if (this.schema == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.schema;
    }

    public Object next() throws NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        Feature next = this.reader.next();
        Object[] attributes = next.getAttributes(null);
        try {
            for (int i = 0; i < attributes.length; ++i) {
                if (!(attributes[i] instanceof Geometry)) continue;
                attributes[i] = this.transformer.transform((Geometry)attributes[i]);
            }
        }
        catch (TransformException e) {
            throw (IllegalStateException)new IllegalStateException("A transformation exception occurred while reprojecting data on the fly").initCause(e);
        }
        try {
            return this.schema.create(attributes, next.getID());
        }
        catch (IllegalAttributeException e) {
            throw (IllegalStateException)new IllegalStateException("Problem occured during reprojection").initCause(e);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("On the fly reprojection disables remove");
    }

    public boolean hasNext() {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    public void close() {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.schema = null;
    }
}

