/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.filter.Filter;

public abstract class DiffFeatureWriter
implements FeatureWriter {
    protected FeatureReader reader;
    protected Diff diff;
    Feature next;
    Feature live;
    Feature current;

    public DiffFeatureWriter(FeatureReader reader, Diff diff) {
        this(reader, diff, (Filter)Filter.INCLUDE);
    }

    public DiffFeatureWriter(FeatureReader reader, Diff diff, Filter filter) {
        this.reader = new DiffFeatureReader(reader, diff, filter);
        this.diff = diff;
    }

    public FeatureType getFeatureType() {
        return this.reader.getFeatureType();
    }

    public Feature next() throws IOException {
        FeatureType type = this.getFeatureType();
        if (this.hasNext()) {
            try {
                this.live = this.next;
                this.next = null;
                this.current = type.duplicate(this.live);
                return this.current;
            }
            catch (IllegalAttributeException e) {
                throw (IOException)new IOException("Could not modify content").initCause(e);
            }
        }
        try {
            this.live = null;
            this.next = null;
            this.current = type.create(new Object[type.getAttributeCount()], "new" + this.diff.nextFID);
            ++this.diff.nextFID;
            return this.current;
        }
        catch (IllegalAttributeException e) {
            throw new IOException("Could not create new content");
        }
    }

    public void remove() throws IOException {
        if (this.live != null) {
            this.diff.remove(this.live.getID());
            this.fireNotification(-1, (Envelope)this.live.getBounds());
            this.live = null;
            this.current = null;
        } else if (this.current != null) {
            this.current = null;
        }
    }

    public void write() throws IOException {
        if (this.live != null) {
            this.diff.modify(this.live.getID(), this.current);
            Envelope bounds = new Envelope();
            bounds.expandToInclude((Envelope)this.live.getBounds());
            bounds.expandToInclude((Envelope)this.current.getBounds());
            this.fireNotification(0, bounds);
            this.live = null;
            this.current = null;
        } else if (this.live == null && this.current != null) {
            this.diff.add(this.current.getID(), this.current);
            this.fireNotification(1, (Envelope)this.current.getBounds());
            this.current = null;
        } else {
            throw new IOException("No feature available to write");
        }
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        this.live = null;
        this.current = null;
        if (this.reader.hasNext()) {
            try {
                this.next = this.reader.next();
            }
            catch (NoSuchElementException e) {
                throw new DataSourceException("No more content", (Throwable)e);
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("No more content", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        this.current = null;
        this.live = null;
        this.next = null;
        this.diff = null;
    }

    protected abstract void fireNotification(int var1, Envelope var2);
}

