/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SimpleFeature;
import org.opengis.filter.Filter;

public abstract class AbstractFeatureStore
extends AbstractFeatureSource
implements FeatureStore {
    protected Transaction transaction = Transaction.AUTO_COMMIT;

    public AbstractFeatureStore() {
    }

    public AbstractFeatureStore(Set hints) {
        super(hints);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void modifyFeatures(AttributeType type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new AttributeType[]{type}, new Object[]{value}, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyFeatures(AttributeType[] type, Object[] value, Filter filter) throws IOException {
        String typeName = this.getSchema().getTypeName();
        FeatureWriter writer = this.getDataStore().getFeatureWriter(typeName, filter, this.getTransaction());
        try {
            while (writer.hasNext()) {
                Feature feature = writer.next();
                for (int i = 0; i < type.length; ++i) {
                    try {
                        feature.setAttribute(type[i].getLocalName(), value[i]);
                        continue;
                    }
                    catch (IllegalAttributeException e) {
                        throw new DataSourceException("Could not update feature " + feature.getID() + " with " + type[i].getLocalName() + "=" + value[i], (Throwable)e);
                    }
                }
                writer.write();
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set addFeatures(FeatureReader reader) throws IOException {
        HashSet<String> addedFids = new HashSet<String>();
        String typeName = this.getSchema().getTypeName();
        Feature feature = null;
        FeatureWriter writer = this.getDataStore().getFeatureWriterAppend(typeName, this.getTransaction());
        try {
            while (reader.hasNext()) {
                try {
                    feature = reader.next();
                }
                catch (Exception e) {
                    throw new DataSourceException("Could not add Features, problem with provided reader", (Throwable)e);
                }
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                try {
                    newFeature.setAttributes(feature.getAttributes(null));
                }
                catch (IllegalAttributeException writeProblem) {
                    throw new DataSourceException("Could not create " + typeName + " out of provided feature: " + feature.getID(), (Throwable)writeProblem);
                }
                writer.write();
                addedFids.add(newFeature.getID());
            }
        }
        finally {
            reader.close();
            writer.close();
        }
        return addedFids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set addFeatures(FeatureCollection collection) throws IOException {
        HashSet<String> addedFids = new HashSet<String>();
        String typeName = this.getSchema().getTypeName();
        Feature feature = null;
        FeatureWriter writer = this.getDataStore().getFeatureWriterAppend(typeName, this.getTransaction());
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                feature = (Feature)iterator.next();
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                try {
                    newFeature.setAttributes(feature.getAttributes(null));
                }
                catch (IllegalAttributeException writeProblem) {
                    throw new DataSourceException("Could not create " + typeName + " out of provided feature: " + feature.getID(), (Throwable)writeProblem);
                }
                writer.write();
                addedFids.add(newFeature.getID());
            }
        }
        finally {
            collection.close(iterator);
            writer.close();
        }
        return addedFids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeatures(Filter filter) throws IOException {
        String typeName = this.getSchema().getTypeName();
        FeatureWriter writer = this.getDataStore().getFeatureWriter(typeName, filter, this.getTransaction());
        try {
            while (writer.hasNext()) {
                writer.next();
                writer.remove();
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeatures(FeatureReader reader) throws IOException {
        String typeName = this.getSchema().getTypeName();
        FeatureWriter writer = this.getDataStore().getFeatureWriter(typeName, this.getTransaction());
        try {
            Feature feature;
            while (writer.hasNext()) {
                feature = writer.next();
                writer.remove();
            }
            while (reader.hasNext()) {
                try {
                    feature = reader.next();
                }
                catch (Exception readProblem) {
                    throw new DataSourceException("Could not add Features, problem with provided reader", (Throwable)readProblem);
                }
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                try {
                    newFeature.setAttributes(feature.getAttributes(null));
                }
                catch (IllegalAttributeException writeProblem) {
                    throw new DataSourceException("Could not create " + typeName + " out of provided feature: " + feature.getID(), (Throwable)writeProblem);
                }
                writer.write();
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    public void setTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction cannot be null, did you mean Transaction.AUTO_COMMIT?");
        }
        this.transaction = transaction;
    }
}

