/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.postgis;

import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernatespatial.SpatialFunction;
import org.hibernatespatial.postgis.PostgisDialect;

public class PostgisNoSQLMM
extends PostgisDialect {
    protected void registerTypesAndFunctions() {
        this.registerColumnType(2002, "geometry");
        this.registerFunction("dimension", (SQLFunction)new StandardSQLFunction("dimension", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("geometrytype", (SQLFunction)new StandardSQLFunction("geometrytype", (Type)StandardBasicTypes.STRING));
        this.registerFunction("srid", (SQLFunction)new StandardSQLFunction("srid", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("envelope", (SQLFunction)new StandardSQLFunction("envelope", geometryCustomType));
        this.registerFunction("astext", (SQLFunction)new StandardSQLFunction("astext", (Type)StandardBasicTypes.STRING));
        this.registerFunction("asbinary", (SQLFunction)new StandardSQLFunction("asbinary", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("isempty", (SQLFunction)new StandardSQLFunction("isempty", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("issimple", (SQLFunction)new StandardSQLFunction("issimple", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("boundary", (SQLFunction)new StandardSQLFunction("boundary", geometryCustomType));
        this.registerFunction("overlaps", (SQLFunction)new StandardSQLFunction("overlaps", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("intersects", (SQLFunction)new StandardSQLFunction("intersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("equals", (SQLFunction)new StandardSQLFunction("equals", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("contains", (SQLFunction)new StandardSQLFunction("contains", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("crosses", (SQLFunction)new StandardSQLFunction("crosses", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("disjoint", (SQLFunction)new StandardSQLFunction("disjoint", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("touches", (SQLFunction)new StandardSQLFunction("touches", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("within", (SQLFunction)new StandardSQLFunction("within", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("relate", (SQLFunction)new StandardSQLFunction("relate", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("distance", (SQLFunction)new StandardSQLFunction("distance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("buffer", (SQLFunction)new StandardSQLFunction("buffer", geometryCustomType));
        this.registerFunction("convexhull", (SQLFunction)new StandardSQLFunction("convexhull", geometryCustomType));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction("difference", geometryCustomType));
        this.registerFunction("intersection", (SQLFunction)new StandardSQLFunction("intersection", geometryCustomType));
        this.registerFunction("symdifference", (SQLFunction)new StandardSQLFunction("symdifference", geometryCustomType));
        this.registerFunction("geomunion", (SQLFunction)new StandardSQLFunction("geomunion", geometryCustomType));
        this.registerFunction("extent", (SQLFunction)new StandardSQLFunction("extent", geometryCustomType));
        this.registerFunction("transform", (SQLFunction)new StandardSQLFunction("transform", geometryCustomType));
    }

    public String getDWithinSQL(String columnName) {
        return "( dwithin(" + columnName + ",?,?) )";
    }

    public String getHavingSridSQL(String columnName) {
        return "( srid(" + columnName + ") = ?)";
    }

    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = "( isempty(" + columnName + ")) ";
        return isEmpty ? emptyExpr : "not " + emptyExpr;
    }

    public String getSpatialRelateSQL(String columnName, int spatialRelation, boolean hasFilter) {
        switch (spatialRelation) {
            case 4: {
                return hasFilter ? "(" + columnName + " && ?  AND   within(" + columnName + ", ?))" : " within(" + columnName + ",?)";
            }
            case 6: {
                return hasFilter ? "(" + columnName + " && ? AND contains(" + columnName + ", ?))" : " contains(" + columnName + ", ?)";
            }
            case 3: {
                return hasFilter ? "(" + columnName + " && ? AND crosses(" + columnName + ", ?))" : " crosses(" + columnName + ", ?)";
            }
            case 5: {
                return hasFilter ? "(" + columnName + " && ? AND overlaps(" + columnName + ", ?))" : " overlaps(" + columnName + ", ?)";
            }
            case 1: {
                return hasFilter ? "(" + columnName + " && ? AND disjoint(" + columnName + ", ?))" : " disjoint(" + columnName + ", ?)";
            }
            case 7: {
                return hasFilter ? "(" + columnName + " && ? AND intersects(" + columnName + ", ?))" : " intersects(" + columnName + ", ?)";
            }
            case 2: {
                return hasFilter ? "(" + columnName + " && ? AND touches(" + columnName + ", ?))" : " touches(" + columnName + ", ?)";
            }
            case 0: {
                return hasFilter ? "(" + columnName + " && ? AND equals(" + columnName + ", ?))" : " equals(" + columnName + ", ?)";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    public boolean supports(SpatialFunction function) {
        return super.supports(function);
    }
}

