/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.postgis;

import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.type.CustomType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.UserType;
import org.hibernatespatial.SpatialDialect;
import org.hibernatespatial.SpatialFunction;
import org.hibernatespatial.postgis.PGGeometryUserType;

public class PostgisDialect
extends PostgreSQLDialect
implements SpatialDialect {
    protected static final Type geometryCustomType = new CustomType((UserType)new PGGeometryUserType(), new String[]{"postgis_geometry"});

    public PostgisDialect() {
        this.registerTypesAndFunctions();
    }

    protected void registerTypesAndFunctions() {
        this.registerColumnType(2002, "geometry");
        this.registerFunction("dimension", (SQLFunction)new StandardSQLFunction("st_dimension", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("geometrytype", (SQLFunction)new StandardSQLFunction("st_geometrytype", (Type)StandardBasicTypes.STRING));
        this.registerFunction("srid", (SQLFunction)new StandardSQLFunction("st_srid", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("envelope", (SQLFunction)new StandardSQLFunction("st_envelope", geometryCustomType));
        this.registerFunction("astext", (SQLFunction)new StandardSQLFunction("st_astext", (Type)StandardBasicTypes.STRING));
        this.registerFunction("asbinary", (SQLFunction)new StandardSQLFunction("st_asbinary", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("isempty", (SQLFunction)new StandardSQLFunction("st_isempty", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("issimple", (SQLFunction)new StandardSQLFunction("st_issimple", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("boundary", (SQLFunction)new StandardSQLFunction("st_boundary", geometryCustomType));
        this.registerFunction("overlaps", (SQLFunction)new StandardSQLFunction("st_overlaps", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("intersects", (SQLFunction)new StandardSQLFunction("st_intersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("equals", (SQLFunction)new StandardSQLFunction("st_equals", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("contains", (SQLFunction)new StandardSQLFunction("st_contains", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("crosses", (SQLFunction)new StandardSQLFunction("st_crosses", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("disjoint", (SQLFunction)new StandardSQLFunction("st_disjoint", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("touches", (SQLFunction)new StandardSQLFunction("st_touches", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("within", (SQLFunction)new StandardSQLFunction("st_within", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("relate", (SQLFunction)new StandardSQLFunction("st_relate", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("distance", (SQLFunction)new StandardSQLFunction("st_distance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("buffer", (SQLFunction)new StandardSQLFunction("st_buffer", geometryCustomType));
        this.registerFunction("convexhull", (SQLFunction)new StandardSQLFunction("st_convexhull", geometryCustomType));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction("st_difference", geometryCustomType));
        this.registerFunction("intersection", (SQLFunction)new StandardSQLFunction("st_intersection", geometryCustomType));
        this.registerFunction("symdifference", (SQLFunction)new StandardSQLFunction("st_symdifference", geometryCustomType));
        this.registerFunction("geomunion", (SQLFunction)new StandardSQLFunction("st_union", geometryCustomType));
        this.registerFunction("extent", (SQLFunction)new StandardSQLFunction("extent", geometryCustomType));
        this.registerFunction("dwithin", (SQLFunction)new StandardSQLFunction("st_dwithin", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("transform", (SQLFunction)new StandardSQLFunction("st_transform", geometryCustomType));
    }

    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return " ST_within(" + columnName + ",?)";
            }
            case 6: {
                return " ST_contains(" + columnName + ", ?)";
            }
            case 3: {
                return " ST_crosses(" + columnName + ", ?)";
            }
            case 5: {
                return " ST_overlaps(" + columnName + ", ?)";
            }
            case 1: {
                return " ST_disjoint(" + columnName + ", ?)";
            }
            case 7: {
                return " ST_intersects(" + columnName + ", ?)";
            }
            case 2: {
                return " ST_touches(" + columnName + ", ?)";
            }
            case 0: {
                return " ST_equals(" + columnName + ", ?)";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    public String getDWithinSQL(String columnName) {
        return "ST_DWithin(" + columnName + ",?,?)";
    }

    public String getHavingSridSQL(String columnName) {
        return "( ST_srid(" + columnName + ") = ?)";
    }

    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = " ST_IsEmpty(" + columnName + ") ";
        return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
    }

    public String getSpatialFilterExpression(String columnName) {
        return "(" + columnName + " && ? ) ";
    }

    public UserType getGeometryUserType() {
        return new PGGeometryUserType();
    }

    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        switch (aggregation) {
            case 1: {
                StringBuilder stbuf = new StringBuilder();
                stbuf.append("extent(").append(columnName).append(")");
                return stbuf.toString();
            }
        }
        throw new IllegalArgumentException("Aggregation of type " + aggregation + " are not supported by this dialect");
    }

    public String getDbGeometryTypeName() {
        return "GEOMETRY";
    }

    public boolean isTwoPhaseFiltering() {
        return true;
    }

    public boolean supportsFiltering() {
        return true;
    }

    public boolean supports(SpatialFunction function) {
        return this.getFunctions().get(function.toString()) != null;
    }
}

