/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.hibernatespatial.HBSpatialExtension;
import org.hibernatespatial.pojo.AttributeInfo;
import org.hibernatespatial.pojo.ClassInfo;
import org.hibernatespatial.pojo.FeatureClassGenerator;
import org.hibernatespatial.pojo.FeatureMapper;
import org.hibernatespatial.pojo.GeometryNotFoundException;
import org.hibernatespatial.pojo.MappingsGenerator;
import org.hibernatespatial.pojo.MissingIdentifierException;
import org.hibernatespatial.pojo.NamingStrategy;
import org.hibernatespatial.pojo.SimpleNamingStrategy;
import org.hibernatespatial.pojo.TableNotFoundException;
import org.hibernatespatial.pojo.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoMapper {
    protected static final Logger logger = LoggerFactory.getLogger(AutoMapper.class);
    protected static final String PACKAGE_NAME = "org.hibernatespatial.features.generated";
    private static Map<TableName, Class<?>> tableClassMap = new HashMap();
    private static Map<TableName, ClassInfo> tableClassInfoMap = new HashMap<TableName, ClassInfo>();
    private static NamingStrategy naming = new SimpleNamingStrategy();

    public static synchronized Document map(Connection conn, String catalog, String schema, Collection<String> tableNames) throws SQLException {
        TypeMapper typeMapper = new TypeMapper(HBSpatialExtension.getDefaultSpatialDialect().getDbGeometryTypeName());
        DatabaseMetaData dmd = conn.getMetaData();
        FeatureMapper fMapper = new FeatureMapper(naming, typeMapper);
        FeatureClassGenerator fGenerator = new FeatureClassGenerator(PACKAGE_NAME, naming);
        for (String tableName : tableNames) {
            TableName table = new TableName(catalog, schema, tableName);
            if (tableClassInfoMap.get(table) != null) {
                logger.info("Class info for table " + tableName + " in catalog/schema " + catalog + "/" + schema + " has already been mapped.");
                continue;
            }
            logger.info("Generating class info for table " + tableName + " in catalog/schema " + catalog + "/" + schema);
            try {
                ClassInfo cInfo = fMapper.createClassInfo(catalog, schema, tableName, dmd);
                logger.info("Generating class " + cInfo.getClassName() + " for table " + tableName);
                Class<?> clazz = fGenerator.generate(cInfo);
                tableClassMap.put(table, clazz);
                tableClassInfoMap.put(table, cInfo);
            }
            catch (TableNotFoundException e) {
                logger.warn(e.getMessage());
            }
            catch (MissingIdentifierException e) {
                logger.warn(e.getMessage());
            }
        }
        logger.info("Generating Hibernate Mapping file");
        MappingsGenerator mappingGenerator = new MappingsGenerator(PACKAGE_NAME);
        try {
            mappingGenerator.load(tableClassInfoMap.values(), schema);
        }
        catch (MissingIdentifierException e) {
            throw new RuntimeException(e);
        }
        return mappingGenerator.getMappingsDoc();
    }

    public static Class<?> getClass(String catalog, String schema, String tableName) {
        TableName tbn = new TableName(catalog, schema, tableName);
        return tableClassMap.get(tbn);
    }

    public static List<String[]> getMappedTables() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (TableName tbn : tableClassMap.keySet()) {
            String[] sa = new String[]{tbn.catalog, tbn.schema, tbn.tableName};
            list.add(sa);
        }
        return list;
    }

    public static List<String> getAttributes(String catalog, String schema, String tableName) {
        List<AttributeInfo> attributes = AutoMapper.getAttributeInfos(catalog, schema, tableName);
        ArrayList<String> result = new ArrayList<String>();
        for (AttributeInfo attributeInfo : attributes) {
            result.add(attributeInfo.getFieldName());
        }
        return result;
    }

    private static List<AttributeInfo> getAttributeInfos(String catalog, String schema, String tableName) {
        TableName tbn = new TableName(catalog, schema, tableName);
        ClassInfo cInfo = tableClassInfoMap.get(tbn);
        if (cInfo == null) {
            return new ArrayList<AttributeInfo>();
        }
        return cInfo.getAttributes();
    }

    public static String getIdAttribute(String catalog, String schema, String tableName) throws MissingIdentifierException {
        TableName tbn = new TableName(catalog, schema, tableName);
        ClassInfo cInfo = tableClassInfoMap.get(tbn);
        return cInfo.getIdAttribute().getFieldName();
    }

    public static String getGeometryAttribute(String catalog, String schema, String tableName) throws GeometryNotFoundException {
        TableName tbn = new TableName(catalog, schema, tableName);
        ClassInfo cInfo = tableClassInfoMap.get(tbn);
        return cInfo.getGeomAttribute().getFieldName();
    }

    public static String getAttributeSetterName(String catalog, String schema, String tableName, String attribute) {
        AutoMapper.getAttributeInfo(catalog, schema, tableName, attribute);
        return naming.createSetterName(attribute);
    }

    public static String getAttributeGetterName(String catalog, String schema, String tableName, String attribute) {
        AutoMapper.getAttributeInfo(catalog, schema, tableName, attribute);
        return naming.createGetterName(attribute);
    }

    private static AttributeInfo getAttributeInfo(String catalog, String schema, String tableName, String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("Null attribute received.");
        }
        for (AttributeInfo candidate : AutoMapper.getAttributeInfos(catalog, schema, tableName)) {
            if (!candidate.getFieldName().equals(attribute)) continue;
            return candidate;
        }
        throw new IllegalArgumentException(String.format("%s is not an attribute of the class to which table %s is mapped.", attribute, tableName));
    }

    private static class TableName {
        String catalog;
        String schema;
        String tableName;

        private TableName(String catalog, String schema, String tableName) {
            this.catalog = catalog;
            this.schema = schema;
            this.tableName = tableName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
            result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
            result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TableName)) {
                return false;
            }
            TableName other = (TableName)obj;
            if (this.catalog == null ? other.catalog != null : !this.catalog.equals(other.catalog)) {
                return false;
            }
            if (this.schema == null ? other.schema != null : !this.schema.equals(other.schema)) {
                return false;
            }
            return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
        }
    }
}

