/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.TypedValue;
import org.hibernatespatial.SpatialDialect;
import org.hibernatespatial.SpatialFunction;
import org.hibernatespatial.criterion.ExpressionUtil;

public class IsEmptyExpression
implements Criterion {
    private static final TypedValue[] NO_VALUES = new TypedValue[0];
    private final String propertyName;
    private final boolean isEmpty;

    public IsEmptyExpression(String propertyName, boolean isEmpty) {
        this.propertyName = propertyName;
        this.isEmpty = isEmpty;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String column = ExpressionUtil.findColumn(this.propertyName, criteria, criteriaQuery);
        SpatialDialect spatialDialect = ExpressionUtil.getSpatialDialect(criteriaQuery, SpatialFunction.isempty);
        return spatialDialect.getIsEmptySQL(column, this.isEmpty);
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return NO_VALUES;
    }
}

