/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.proxy.dwr;

import java.util.Collection;
import java.util.Map;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.proxy.ScriptProxy;

public class Util
extends ScriptProxy {
    public Util() {
    }

    public Util(ScriptSession scriptSession) {
        super(scriptSession);
    }

    public Util(Collection scriptSessions) {
        super(scriptSessions);
    }

    public void setValue(String elementId, String value) {
        this.setValue(elementId, value, false);
    }

    public void setValue(String elementId, String value, boolean escapeHtml) {
        String options = escapeHtml ? "{escapeHtml:true}" : "{escapeHtml:false}";
        this.addFunctionCall("dwr.util.setValue", elementId, value, options);
    }

    public void setValues(Map values, boolean escapeHtml) {
        String options = escapeHtml ? "{escapeHtml:true}" : "{escapeHtml:false}";
        this.addFunctionCall("dwr.util.setValue", values, options);
    }

    public void addOptions(String elementId, String[] array) {
        this.addFunctionCall("dwr.util.addOptions", elementId, array);
    }

    public void addOptions(String elementId, Collection array, String property) {
        this.addFunctionCall("dwr.util.addOptions", elementId, array, property);
    }

    public void addOptions(String elementId, Collection array, String valueProperty, String textProperty) {
        this.addFunctionCall("dwr.util.addOptions", elementId, array, valueProperty, textProperty);
    }

    public void removeAllOptions(String elementId) {
        this.addFunctionCall("dwr.util.removeAllOptions", elementId);
    }

    public void addRows(String elementId, String[][] data, String options) {
        if (data.length > 0) {
            StringBuffer functions = new StringBuffer();
            for (int i = 0; i < data[0].length; ++i) {
                functions.append("function(data) { return data[" + i + "]},");
            }
            functions.deleteCharAt(functions.length() - 1);
            ScriptBuffer script = new ScriptBuffer();
            script.appendScript("dwr.util.addRows(").appendData(elementId).appendScript(",").appendData(data).appendScript(",").appendScript("[" + functions.toString() + "]").appendScript(options == null ? "" : ", " + options).appendScript(");");
            this.addScript(script);
        }
    }

    public void addRows(String elementId, String[][] data) {
        this.addRows(elementId, data, null);
    }

    public void removeAllRows(String elementId) {
        this.addFunctionCall("dwr.util.removeAllRows", elementId);
    }

    public void cloneNode(String elementId) {
        this.addFunctionCall("dwr.util.cloneNode", elementId);
    }

    public void cloneNode(String elementId, String idPrefix, String idSuffix) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendScript("dwr.util.cloneNode(").appendData(elementId).appendScript(", { idPrefix:").appendData(idPrefix).appendScript(", idSuffix:").appendData(idSuffix).appendScript("});");
        this.addScript(script);
    }

    public void removeNode(String elementId) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendScript("dwr.util._temp = dwr.util.byId(").appendData(elementId).appendScript("); ").appendScript("if (dwr.util._temp) { dwr.util._temp.parentNode.removeChild(dwr.util._temp); dwr.util._temp = null; }");
        this.addScript(script);
    }

    public void setClassName(String elementId, String className) {
        this.addFunctionCall("dwr.util.setClassName", elementId, className);
    }

    public void addClassName(String elementId, String className) {
        this.addFunctionCall("dwr.util.addClassName", elementId, className);
    }

    public void removeClassName(String elementId, String className) {
        this.addFunctionCall("dwr.util.removeClassName", elementId, className);
    }

    public void toggleClassName(String elementId, String className) {
        this.addFunctionCall("dwr.util.toggleClassName", elementId, className);
    }

    public void setStyle(String elementId, String selector, String value) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendScript("dwr.util.byId(").appendData(elementId).appendScript(").style.").appendScript(selector).appendScript("=").appendData(value).appendScript(";");
        this.addScript(script);
    }
}

