/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.addressparser;

import com.gisgraphy.serializer.common.OutputFormat;
import com.vividsolutions.jts.geom.Point;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AddressQuery {
    public static final boolean DEFAULT_INDENTATION = false;
    public static final int DEFAULT_LIMIT = 10;
    private static Pattern callbackValidationPattern = Pattern.compile("\\w+");
    private static Logger logger = Logger.getLogger(AddressQuery.class);
    private String address;
    private String apikey;
    private String country;
    private OutputFormat format = OutputFormat.getDefault();
    private String callback;
    private boolean postal = false;
    private boolean indent = false;
    private boolean standardize = false;
    private boolean geocode = false;
    private int parsedAddressUnlockKey;
    private int limitNbResult = 10;
    public static final double DEFAULT_RADIUS = 100000.0;
    private Point point;
    private double radius = 100000.0;
    private boolean fuzzy = true;

    public AddressQuery around(Point point) {
        this.point = point;
        return this;
    }

    public Point getPoint() {
        return this.point;
    }

    public Double getLatitude() {
        Double latitude = null;
        if (this.point != null) {
            latitude = this.point.getY();
        }
        return latitude;
    }

    public Double getLongitude() {
        Double longitude = null;
        if (this.point != null) {
            longitude = this.point.getX();
        }
        return longitude;
    }

    public AddressQuery withRadius(double radius) {
        this.radius = radius < 0.0 ? 100000.0 : radius;
        return this;
    }

    public double getRadius() {
        return this.radius;
    }

    public int getParsedAddressUnlockKey() {
        return this.parsedAddressUnlockKey;
    }

    public void setParsedAddressUnlockKey(int parsedAddressUnlockKey) {
        this.parsedAddressUnlockKey = parsedAddressUnlockKey;
    }

    public OutputFormat getFormat() {
        return this.format;
    }

    public void setFormat(OutputFormat format) {
        this.format = format;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        if (callback != null && callbackValidationPattern.matcher(callback).matches()) {
            this.callback = callback;
        } else if (callback == null) {
            this.callback = null;
        } else {
            logger.warn((Object)("wrong callback specify : " + callback + ", callback method sould be alphanumeric"));
        }
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public int getLimitNbResult() {
        return this.limitNbResult;
    }

    public void limitNbResult(int limit) {
        if (limit >= 1) {
            this.limitNbResult = limit;
        }
    }

    public String toString() {
        return "AddressQuery [address=" + this.address + ", apikey=" + this.apikey + ", country=" + this.country + ", format=" + this.format + ", standardize=" + this.standardize + ", callback=" + this.callback + ", postal=" + this.postal + ", indent=" + this.indent + "]";
    }

    protected AddressQuery() {
    }

    public AddressQuery(String address, String country) {
        if (address == null || address.trim().equals("")) {
            throw new IllegalArgumentException("address can not be nul or empty");
        }
        if (country != null && !country.trim().equals("")) {
            this.country = country;
        }
        this.address = address;
    }

    public AddressQuery(String address) {
        this(address, null);
    }

    public String getApikey() {
        return this.apikey;
    }

    public void setApikey(String apikey) {
        this.apikey = apikey;
    }

    public boolean isPostal() {
        return this.postal;
    }

    public void setPostal(boolean postal) {
        this.postal = postal;
    }

    public boolean isStandardize() {
        return this.standardize;
    }

    public void setStandardize(boolean standardize) {
        this.standardize = standardize;
    }

    public boolean isGeocode() {
        return this.geocode;
    }

    public void setGeocode(boolean geocode) {
        this.geocode = geocode;
    }

    public boolean isFuzzy() {
        return this.fuzzy;
    }

    public AddressQuery withFuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
        return this;
    }
}

