/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tuckey.web.filters.urlrewrite.ConditionMatch;
import org.tuckey.web.filters.urlrewrite.RunConfig;
import org.tuckey.web.filters.urlrewrite.extend.RewriteMatch;
import org.tuckey.web.filters.urlrewrite.utils.Log;
import org.tuckey.web.filters.urlrewrite.utils.StringMatchingMatcher;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public class Run {
    private static Log log = Log.getLog(Run.class);
    private boolean newEachTime = false;
    private String classStr;
    private static final String DEAULT_METHOD_STR = "run";
    private String methodStr = "run";
    private int id = 0;
    private String error = null;
    private boolean valid = false;
    private boolean initialised = false;
    private Object runClassInstance;
    private Constructor runConstructor;
    private Method initMethod;
    private Method filterInitMethod;
    private Method runMethod;
    private Class[] runMethodParams;
    private String[] runMethodParamNames;
    private boolean runMethodUseDefaultParams = true;
    private Method destroyMethod;
    private RunConfig runServletConfig;
    private Hashtable initParams = new Hashtable();
    private static boolean loadClass = true;
    private static Class[][] runMethodPossibleSignatures = new Class[][]{{ServletRequest.class, ServletResponse.class}, {HttpServletRequest.class, HttpServletResponse.class}};
    private boolean filter = false;
    static /* synthetic */ Class class$javax$servlet$ServletConfig;
    static /* synthetic */ Class class$javax$servlet$FilterConfig;

    public boolean initialise(ServletContext context) {
        return this.initialise(context, null);
    }

    public boolean initialise(ServletContext context, Class extraParam) {
        log.debug("initialising run");
        this.runServletConfig = new RunConfig(context, this.initParams);
        this.initialised = true;
        this.valid = false;
        if (StringUtils.isBlank(this.classStr)) {
            this.setError("cannot initialise run " + this.id + " value is empty");
            return this.valid;
        }
        if (this.methodStr == null) {
            this.methodStr = DEAULT_METHOD_STR;
        }
        log.debug("methodStr: " + this.methodStr);
        String rawMethodStr = this.methodStr;
        int bkStart = rawMethodStr.indexOf(40);
        int bkEnd = rawMethodStr.indexOf(41);
        if (bkStart != -1 && bkEnd != -1 && bkEnd - bkStart > 0) {
            this.runMethodUseDefaultParams = false;
            this.methodStr = rawMethodStr.substring(0, bkStart);
            String paramsList = rawMethodStr.substring(bkStart + 1, bkEnd);
            if ((paramsList = StringUtils.trimToNull(paramsList)) != null) {
                String[] params = paramsList.split(",");
                Class[] paramClasses = new Class[params.length];
                String[] paramNames = new String[params.length];
                for (int i = 0; i < params.length; ++i) {
                    Class clazz;
                    String param = StringUtils.trimToNull(params[i]);
                    if (param == null) continue;
                    if (param.contains(" ")) {
                        String paramName = StringUtils.trimToNull(param.substring(param.indexOf(" ")));
                        if (paramName != null) {
                            log.debug("param name: " + paramName);
                            paramNames[i] = paramName;
                        }
                        param = param.substring(0, param.indexOf(32));
                    }
                    if ((clazz = this.parseClass(param)) == null) {
                        return this.valid;
                    }
                    paramClasses[i] = clazz;
                }
                this.runMethodParams = paramClasses;
                this.runMethodParamNames = paramNames;
            }
        }
        if (loadClass) {
            this.prepareRunObject(extraParam);
        } else {
            this.valid = true;
        }
        return this.valid;
    }

    private Class parseClass(String param) {
        Class paramClass = null;
        if ("boolean".equals(param) || "bool".equals(param) || "z".equalsIgnoreCase(param)) {
            paramClass = Boolean.TYPE;
        }
        if ("byte".equals(param) || "b".equalsIgnoreCase(param)) {
            paramClass = Byte.TYPE;
        }
        if ("char".equals(param) || "c".equalsIgnoreCase(param)) {
            paramClass = Character.TYPE;
        }
        if ("short".equals(param) || "s".equalsIgnoreCase(param)) {
            paramClass = Short.TYPE;
        }
        if ("int".equals(param) || "i".equalsIgnoreCase(param)) {
            paramClass = Integer.TYPE;
        }
        if ("long".equals(param) || "l".equalsIgnoreCase(param)) {
            paramClass = Long.TYPE;
        }
        if ("float".equals(param) || "f".equalsIgnoreCase(param)) {
            paramClass = Float.TYPE;
        }
        if ("double".equals(param) || "d".equalsIgnoreCase(param)) {
            paramClass = Double.TYPE;
        }
        if ("Boolean".equals(param) || "Bool".equals(param)) {
            Class clazz = paramClass = Boolean.class;
        }
        if ("Byte".equals(param)) {
            Class clazz = paramClass = Byte.class;
        }
        if ("Character".equalsIgnoreCase(param) || "C".equals(param)) {
            Class clazz = paramClass = Character.class;
        }
        if ("Short".equals(param)) {
            Class clazz = paramClass = Short.class;
        }
        if ("Integer".equals(param)) {
            Class clazz = paramClass = Integer.class;
        }
        if ("Long".equals(param)) {
            Class clazz = paramClass = Long.class;
        }
        if ("Float".equals(param)) {
            Class clazz = paramClass = Float.class;
        }
        if ("Double".equals(param)) {
            Class clazz = paramClass = Double.class;
        }
        if ("Class".equalsIgnoreCase(param)) {
            Class clazz = paramClass = Class.class;
        }
        if ("Number".equalsIgnoreCase(param)) {
            Class clazz = paramClass = Number.class;
        }
        if ("Object".equalsIgnoreCase(param)) {
            Class clazz = paramClass = Object.class;
        }
        if ("String".equalsIgnoreCase(param) || "str".equalsIgnoreCase(param)) {
            Class clazz = paramClass = String.class;
        }
        if ("HttpServletRequest".equalsIgnoreCase(param) || "req".equalsIgnoreCase(param) || "request".equalsIgnoreCase(param)) {
            Class clazz = paramClass = HttpServletRequest.class;
        }
        if ("HttpServletResponse".equalsIgnoreCase(param) || "res".equalsIgnoreCase(param) || "response".equalsIgnoreCase(param)) {
            Class clazz = paramClass = HttpServletResponse.class;
        }
        if ("ServletRequest".equalsIgnoreCase(param)) {
            Class clazz = paramClass = ServletRequest.class;
        }
        if ("ServletResponse".equalsIgnoreCase(param)) {
            Class clazz = paramClass = ServletResponse.class;
        }
        if ("javax.servlet.FilterChain".equalsIgnoreCase(param) || "FilterChain".equalsIgnoreCase(param) || "chain".equalsIgnoreCase(param)) {
            this.filter = true;
            Class clazz = paramClass = FilterChain.class;
        }
        if (loadClass) {
            if (paramClass == null) {
                try {
                    paramClass = Class.forName(param);
                    if (paramClass == null) {
                        this.setError("had trouble finding " + param + " after Class.forName got a null object");
                        return null;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.setError("could not find " + param + " got a " + e.toString(), e);
                    return null;
                }
                catch (NoClassDefFoundError e) {
                    this.setError("could not find " + param + " got a " + e.toString(), e);
                    return null;
                }
            }
            if (paramClass == null) {
                this.setError("could not find class of type " + param);
                return null;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("parseClass found class " + paramClass + " for " + param);
        }
        return paramClass;
    }

    private void prepareRunObject(Class extraParam) {
        Class<?> runClass;
        if (log.isDebugEnabled()) {
            log.debug("looking for class " + this.classStr);
        }
        try {
            runClass = Class.forName(this.classStr);
            if (runClass == null) {
                this.setError("had trouble finding " + this.classStr + " after Class.forName got a null object");
                return;
            }
        }
        catch (ClassNotFoundException e) {
            this.setError("could not find " + this.classStr + " got a " + e.toString(), e);
            return;
        }
        catch (NoClassDefFoundError e) {
            this.setError("could not find " + this.classStr + " got a " + e.toString(), e);
            return;
        }
        try {
            this.runConstructor = runClass.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            this.setError("could not get constructor for " + this.classStr, e);
            return;
        }
        if (!this.runMethodUseDefaultParams) {
            if (log.isDebugEnabled()) {
                log.debug("looking for " + this.methodStr + " with specific params");
            }
            try {
                this.runMethod = runClass.getMethod(this.methodStr, this.runMethodParams);
            }
            catch (NoSuchMethodException e) {}
        } else {
            if (log.isDebugEnabled()) {
                log.debug("looking for " + this.methodStr + "(ServletRequest, ServletResponse)");
            }
            for (int i = 0; i < runMethodPossibleSignatures.length; ++i) {
                Class[] runMethodPossibleSignature = runMethodPossibleSignatures[i];
                if (extraParam != null) {
                    runMethodPossibleSignature = new Class[]{runMethodPossibleSignature[0], runMethodPossibleSignature[1], extraParam};
                }
                if (log.isDebugEnabled()) {
                    String possible = "";
                    for (int j = 0; j < runMethodPossibleSignature.length; ++j) {
                        possible = possible + (j > 0 ? "," : "") + runMethodPossibleSignature[j].getSimpleName();
                    }
                    log.debug("looking for " + this.methodStr + "(" + possible + ")");
                }
                try {
                    this.runMethod = runClass.getMethod(this.methodStr, runMethodPossibleSignature);
                    this.runMethodParams = runMethodPossibleSignature;
                    break;
                }
                catch (NoSuchMethodException e) {
                    this.runMethodParams = null;
                    continue;
                }
            }
            if (this.runMethod == null) {
                this.setError("could not find method with the name " + this.methodStr + " on " + this.classStr);
                return;
            }
        }
        Method[] methods = runClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if ("destroy".equals(method.getName()) && method.getParameterTypes().length == 0) {
                log.debug("found destroy methodStr");
                this.destroyMethod = method;
            }
            if ("init".equals(method.getName()) && method.getParameterTypes().length == 1 && (class$javax$servlet$ServletConfig == null ? Run.class$("javax.servlet.ServletConfig") : class$javax$servlet$ServletConfig).getName().equals(method.getParameterTypes()[0].getName())) {
                log.debug("found init methodStr");
                this.initMethod = method;
            }
            if ("init".equals(method.getName()) && method.getParameterTypes().length == 1 && (class$javax$servlet$FilterConfig == null ? Run.class$("javax.servlet.FilterConfig") : class$javax$servlet$FilterConfig).getName().equals(method.getParameterTypes()[0].getName())) {
                log.debug("found filter init methodStr");
                this.filterInitMethod = method;
            }
            if (this.initMethod != null && this.destroyMethod != null) break;
        }
        if (!this.newEachTime) {
            this.runClassInstance = this.fetchNewInstance();
        }
        this.valid = true;
    }

    private void invokeDestroy(Object runClassInstanceToDestroy) {
        if (runClassInstanceToDestroy != null && this.destroyMethod != null) {
            if (log.isDebugEnabled()) {
                log.debug("running " + this.classStr + ".destroy()");
            }
            try {
                this.destroyMethod.invoke(runClassInstanceToDestroy, (Object[])null);
            }
            catch (IllegalAccessException e) {
                this.logInvokeException("destroy()", e);
            }
            catch (InvocationTargetException e) {
                this.logInvokeException("destroy()", e);
            }
        }
    }

    private RewriteMatch invokeRunMethod(Object classInstanceToRun, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain chain, Object[] matchObjs) throws ServletException, InvocationTargetException {
        if (log.isDebugEnabled()) {
            log.debug("running " + this.classStr + "." + this.getMethodSignature() + " ");
        }
        if (classInstanceToRun == null || this.runMethod == null) {
            return null;
        }
        RewriteMatch returned = null;
        Object[] params = null;
        if (this.runMethodParams != null && this.runMethodParams.length > 0) {
            params = new Object[this.runMethodParams.length];
            for (int i = 0; i < this.runMethodParams.length; ++i) {
                Object param;
                Object matchObj;
                Class runMethodParam = this.runMethodParams[i];
                String runMethodParamName = null;
                if (this.runMethodParamNames != null && this.runMethodParamNames.length > i) {
                    runMethodParamName = this.runMethodParamNames[i];
                }
                if (runMethodParamName != null) {
                    log.debug("need parameter from request called " + runMethodParamName);
                    matchObj = httpServletRequest.getParameter(runMethodParamName);
                    param = this.getConvertedParam(runMethodParam, matchObj);
                } else if (runMethodParam.isAssignableFrom(class$javax$servlet$http$HttpServletRequest == null ? Run.class$("javax.servlet.http.HttpServletRequest") : class$javax$servlet$http$HttpServletRequest)) {
                    param = httpServletRequest;
                } else if (runMethodParam.isAssignableFrom(class$javax$servlet$http$HttpServletResponse == null ? Run.class$("javax.servlet.http.HttpServletResponse") : class$javax$servlet$http$HttpServletResponse)) {
                    param = httpServletResponse;
                } else if (runMethodParam.isAssignableFrom(class$javax$servlet$FilterChain == null ? Run.class$("javax.servlet.FilterChain") : class$javax$servlet$FilterChain)) {
                    param = chain;
                } else {
                    matchObj = null;
                    if (matchObjs != null && matchObjs.length > i) {
                        matchObj = matchObjs[i];
                    }
                    param = this.getConvertedParam(runMethodParam, matchObj);
                }
                params[i] = param;
                if (!log.isDebugEnabled()) continue;
                log.debug("argument " + i + " (" + runMethodParam.getName() + "): " + param);
            }
        }
        try {
            Object objReturned = this.runMethod.invoke(classInstanceToRun, params);
            if (objReturned != null && objReturned instanceof RewriteMatch) {
                returned = (RewriteMatch)objReturned;
            }
        }
        catch (IllegalAccessException e) {
            if (log.isDebugEnabled()) {
                log.debug(e);
            }
            throw new ServletException((Throwable)e);
        }
        return returned;
    }

    private Object getConvertedParam(Class runMethodParam, Object matchObj) {
        Object param = null;
        if (matchObj == null) {
            if (runMethodParam.isPrimitive()) {
                if (runMethodParam.equals(Boolean.TYPE)) {
                    param = Boolean.FALSE;
                } else if (runMethodParam.equals(Character.TYPE)) {
                    param = new Character('\u0000');
                } else if (runMethodParam.equals(Byte.TYPE)) {
                    param = new Byte(0);
                } else if (runMethodParam.equals(Short.TYPE)) {
                    param = new Short(0);
                } else if (runMethodParam.equals(Integer.TYPE)) {
                    param = new Integer(0);
                } else if (runMethodParam.equals(Long.TYPE)) {
                    param = new Long(0L);
                } else if (runMethodParam.equals(Float.TYPE)) {
                    param = new Float(0.0f);
                } else if (runMethodParam.equals(Double.TYPE)) {
                    param = new Double(0.0);
                }
            }
        } else if (runMethodParam.equals(Boolean.class) || runMethodParam.equals(Boolean.TYPE)) {
            param = Boolean.valueOf((String)matchObj);
        } else if (runMethodParam.equals(Character.class) || runMethodParam.equals(Character.TYPE)) {
            param = new Character(((String)matchObj).charAt(0));
        } else if (runMethodParam.equals(Byte.class) || runMethodParam.equals(Byte.TYPE)) {
            param = Byte.valueOf((String)matchObj);
        } else if (runMethodParam.equals(Short.class) || runMethodParam.equals(Short.TYPE)) {
            param = Short.valueOf((String)matchObj);
        } else if (runMethodParam.equals(Integer.class) || runMethodParam.equals(Integer.TYPE)) {
            param = Integer.valueOf((String)matchObj);
        } else if (runMethodParam.equals(Long.class) || runMethodParam.equals(Long.TYPE)) {
            param = Long.valueOf((String)matchObj);
        } else if (runMethodParam.equals(Float.class) || runMethodParam.equals(Float.TYPE)) {
            param = Float.valueOf((String)matchObj);
        } else if (runMethodParam.equals(Double.class) || runMethodParam.equals(Double.TYPE)) {
            param = Double.valueOf((String)matchObj);
        } else if (matchObj != null && matchObj instanceof Throwable && runMethodParam.isAssignableFrom(matchObj.getClass())) {
            param = matchObj;
        } else {
            try {
                param = runMethodParam.cast(matchObj);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return param;
    }

    public void destroy() {
        this.initialised = false;
        this.valid = false;
        this.invokeDestroy(this.runClassInstance);
        this.destroyMethod = null;
        this.runMethod = null;
        this.initMethod = null;
        this.filterInitMethod = null;
        this.runServletConfig = null;
        this.runConstructor = null;
        this.runClassInstance = null;
        this.methodStr = null;
        this.classStr = null;
        this.error = null;
    }

    public RewriteMatch execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException, InvocationTargetException {
        Object[] params = null;
        return this.execute(httpServletRequest, httpServletResponse, params, null);
    }

    public RewriteMatch execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, StringMatchingMatcher matcher, ConditionMatch conditionMatch, FilterChain chain) throws IOException, ServletException, InvocationTargetException {
        StringMatchingMatcher condMatcher;
        int matches = 0;
        int condMatches = 0;
        if (matcher != null && matcher.isFound()) {
            matches = matcher.groupCount();
        }
        if (conditionMatch != null && (condMatcher = conditionMatch.getMatcher()) != null && condMatcher.isFound()) {
            condMatches = condMatcher.groupCount();
        }
        Object[] allMatches = null;
        if (matches + condMatches > 0) {
            int i;
            allMatches = new String[matches + condMatches];
            if (matcher != null && matches > 0) {
                for (i = 0; i < matches; ++i) {
                    allMatches[i] = matcher.group(i + 1);
                }
            }
            if (conditionMatch != null && condMatches > 0) {
                for (i = 0; i < condMatches; ++i) {
                    allMatches[i] = conditionMatch.getMatcher().group(i);
                }
            }
        }
        return this.execute(httpServletRequest, httpServletResponse, allMatches, chain);
    }

    public RewriteMatch execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Throwable throwable) throws IOException, ServletException, InvocationTargetException {
        Object[] params = new Object[]{throwable};
        return this.execute(httpServletRequest, httpServletResponse, params, null);
    }

    public RewriteMatch execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object[] params) throws IOException, ServletException, InvocationTargetException {
        return this.execute(httpServletRequest, httpServletResponse, params, null);
    }

    public RewriteMatch execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object[] params, FilterChain chain) throws IOException, ServletException, InvocationTargetException {
        RewriteMatch returned;
        if (!this.initialised) {
            log.debug("not initialised skipping");
            return null;
        }
        if (!this.valid) {
            log.debug("not valid skipping");
            return null;
        }
        try {
            if (this.newEachTime) {
                Object newRunClassInstance = this.fetchNewInstance();
                returned = this.invokeRunMethod(newRunClassInstance, httpServletRequest, httpServletResponse, chain, params);
                this.invokeDestroy(newRunClassInstance);
            } else {
                returned = this.invokeRunMethod(this.runClassInstance, httpServletRequest, httpServletResponse, chain, params);
            }
        }
        catch (ServletException e) {
            httpServletRequest.setAttribute("javax.servlet.error.exception", (Object)e);
            throw e;
        }
        return returned;
    }

    private void logInvokeException(String methodStr, Exception e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            this.setError("when invoking " + methodStr + " on " + this.classStr + " got an " + e.toString(), e);
        } else {
            this.setError("when invoking " + methodStr + " on " + this.classStr + " got an " + e.toString() + " caused by " + cause.toString(), cause);
        }
    }

    private Object fetchNewInstance() {
        Object[] args;
        Object obj;
        log.debug("getting new instance of " + this.classStr);
        try {
            obj = this.runConstructor.newInstance(null);
        }
        catch (InstantiationException e) {
            this.logInvokeException("constructor", e);
            return null;
        }
        catch (IllegalAccessException e) {
            this.logInvokeException("constructor", e);
            return null;
        }
        catch (InvocationTargetException e) {
            this.logInvokeException("constructor", e);
            return null;
        }
        if (this.initMethod != null) {
            log.debug("about to run init(ServletConfig) on " + this.classStr);
            args = new Object[]{this.runServletConfig};
            try {
                this.initMethod.invoke(obj, args);
            }
            catch (IllegalAccessException e) {
                this.logInvokeException("init(ServletConfig)", e);
                return null;
            }
            catch (InvocationTargetException e) {
                this.logInvokeException("init(ServletConfig)", e);
                return null;
            }
        }
        if (this.filterInitMethod != null) {
            log.debug("about to run init(FilterConfig) on " + this.classStr);
            args = new Object[]{this.runServletConfig};
            try {
                this.filterInitMethod.invoke(obj, args);
            }
            catch (IllegalAccessException e) {
                this.logInvokeException("init(FilterConfig)", e);
                return null;
            }
            catch (InvocationTargetException e) {
                this.logInvokeException("init(FilterConfig)", e);
                return null;
            }
        }
        return obj;
    }

    public String getError() {
        return this.error;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    public String getClassStr() {
        return this.classStr;
    }

    public String getMethodStr() {
        return this.methodStr;
    }

    public String getMethodSignature() {
        if (this.methodStr == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(this.methodStr);
        if (this.runMethodParams != null) {
            for (int i = 0; i < this.runMethodParams.length; ++i) {
                Class runMethodParam = this.runMethodParams[i];
                if (runMethodParam == null) continue;
                if (i == 0) {
                    sb.append("(");
                }
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(runMethodParam.getName());
                if (i + 1 != this.runMethodParams.length) continue;
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public boolean isNewEachTime() {
        return this.newEachTime;
    }

    public void setNewEachTime(boolean newEachTime) {
        this.newEachTime = newEachTime;
    }

    public Object getRunClassInstance() {
        return this.runClassInstance;
    }

    public void addInitParam(String name, String value) {
        if (name != null) {
            this.initParams.put(name, value);
        }
    }

    public String getInitParam(String paramName) {
        return (String)this.initParams.get(paramName);
    }

    public void setClassStr(String classStr) {
        this.classStr = classStr;
    }

    public void setMethodStr(String methodStr) {
        this.methodStr = methodStr;
    }

    public static void setLoadClass(boolean loadClass) {
        Run.loadClass = loadClass;
    }

    public void setError(String error, Throwable t) {
        this.error = error;
        log.error(error, t);
    }

    public void setError(String error) {
        this.error = error;
        log.error(error);
    }

    public String getDisplayName() {
        return "Run " + this.id;
    }

    public boolean isFilter() {
        return this.filter;
    }
}

