/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.AbstractCoordinateOperation;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;

public class DefaultConcatenatedOperation
extends AbstractCoordinateOperation
implements ConcatenatedOperation {
    private static final long serialVersionUID = 4199619838029045700L;
    private final List operations;

    public DefaultConcatenatedOperation(String name, CoordinateOperation[] operations) {
        this(Collections.singletonMap("name", name), operations);
    }

    public DefaultConcatenatedOperation(Map properties, CoordinateOperation[] operations) {
        this(properties, new ArrayList(operations != null ? operations.length : 4), operations);
    }

    public DefaultConcatenatedOperation(Map properties, CoordinateOperation[] operations, MathTransformFactory factory) throws FactoryException {
        this(properties, new ArrayList(operations != null ? operations.length : 4), operations, factory);
    }

    private DefaultConcatenatedOperation(Map properties, ArrayList list, CoordinateOperation[] operations) {
        this(properties, DefaultConcatenatedOperation.expand(operations, list), list);
    }

    private DefaultConcatenatedOperation(Map properties, ArrayList list, CoordinateOperation[] operations, MathTransformFactory factory) throws FactoryException {
        this(properties, DefaultConcatenatedOperation.expand(operations, list, factory, true), list);
    }

    private DefaultConcatenatedOperation(Map properties, MathTransform transform, ArrayList operations) {
        super(DefaultConcatenatedOperation.mergeAccuracy(properties, operations), ((SingleOperation)operations.get(0)).getSourceCRS(), ((SingleOperation)operations.get(operations.size() - 1)).getTargetCRS(), transform);
        operations.trimToSize();
        this.operations = Collections.unmodifiableList(operations);
    }

    private static MathTransform expand(CoordinateOperation[] operations, List list) {
        try {
            return DefaultConcatenatedOperation.expand(operations, list, null, true);
        }
        catch (FactoryException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private static MathTransform expand(CoordinateOperation[] operations, List list, MathTransformFactory factory, boolean wantTransform) throws FactoryException {
        int size;
        MathTransform transform = null;
        DefaultConcatenatedOperation.ensureNonNull("operations", operations);
        for (int i = 0; i < operations.length; ++i) {
            DefaultConcatenatedOperation.ensureNonNull("operations", operations, i);
            CoordinateOperation op = operations[i];
            if (op instanceof SingleOperation) {
                list.add(op);
            } else if (op instanceof ConcatenatedOperation) {
                ConcatenatedOperation cop = (ConcatenatedOperation)op;
                List cops = cop.getOperations();
                DefaultConcatenatedOperation.expand(cops.toArray(new CoordinateOperation[cops.size()]), list, factory, false);
            } else {
                throw new IllegalArgumentException(Errors.format(45, Utilities.getShortClassName(op), Utilities.getShortName(SingleOperation.class)));
            }
            if (i != 0) {
                int dim2;
                int dim1;
                CoordinateReferenceSystem previous = operations[i - 1].getTargetCRS();
                CoordinateReferenceSystem next = op.getSourceCRS();
                if (previous != null && next != null && (dim1 = previous.getCoordinateSystem().getDimension()) != (dim2 = next.getCoordinateSystem().getDimension())) {
                    throw new IllegalArgumentException(Errors.format(68, new Integer(dim1), new Integer(dim2)));
                }
            }
            if (!wantTransform) continue;
            MathTransform step = op.getMathTransform();
            transform = transform == null ? step : (factory != null ? factory.createConcatenatedTransform(transform, step) : ConcatenatedTransform.create(transform, step));
        }
        if (wantTransform && (size = list.size()) <= 1) {
            throw new IllegalArgumentException(Errors.format(71, "operations[" + size + ']'));
        }
        return transform;
    }

    private static Map mergeAccuracy(Map properties, List operations) {
        if (!properties.containsKey("positionalAccuracy")) {
            LinkedHashSet accuracy = null;
            for (CoordinateOperation op : operations) {
                Collection candidates;
                if (!(op instanceof Transformation) || (candidates = op.getPositionalAccuracy()) == null || candidates.isEmpty()) continue;
                if (accuracy == null) {
                    accuracy = new LinkedHashSet();
                }
                accuracy.addAll(candidates);
            }
            if (accuracy != null) {
                HashMap<String, PositionalAccuracy[]> merged = new HashMap<String, PositionalAccuracy[]>(properties);
                merged.put("positionalAccuracy", accuracy.toArray(new PositionalAccuracy[accuracy.size()]));
                return merged;
            }
        }
        return properties;
    }

    public List getOperations() {
        return this.operations;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultConcatenatedOperation that = (DefaultConcatenatedOperation)object;
            return DefaultConcatenatedOperation.equals(this.operations, that.operations, compareMetadata);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.operations).hashCode() ^ 0xFD679FC4;
    }

    protected String formatWKT(Formatter formatter) {
        String label = super.formatWKT(formatter);
        Iterator it = this.operations.iterator();
        while (it.hasNext()) {
            formatter.append((IdentifiedObject)((CoordinateOperation)it.next()));
        }
        return label;
    }
}

