/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.AuthorityFactoryAdapter;
import org.geotools.referencing.factory.FallbackAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.InternationalString;

public class ManyAuthoritiesFactory
extends AuthorityFactoryAdapter
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private static final Class[] FACTORY_TYPES = new Class[]{CRSAuthorityFactory.class, DatumAuthorityFactory.class, CSAuthorityFactory.class, CoordinateOperationAuthorityFactory.class};
    private static final Class[] OBJECT_TYPES = new Class[]{CoordinateReferenceSystem.class, Datum.class, CoordinateSystem.class, CoordinateOperation.class};
    private final Collection factories;
    private final char separator;
    private final ThreadLocal inProgress = new ThreadLocal();

    public ManyAuthoritiesFactory(Hints userHints) {
        this(userHints, null);
    }

    public ManyAuthoritiesFactory(Hints userHints, Collection factories) {
        this(userHints, factories, '\u0000');
    }

    ManyAuthoritiesFactory(Hints userHints, Collection factories, char separator) {
        super(50);
        this.separator = separator;
        if (factories != null && !factories.isEmpty()) {
            for (Object factory : factories) {
                if (!(factory instanceof Factory)) continue;
                this.hints.putAll(((Factory)factory).getImplementationHints());
            }
            this.factories = ManyAuthoritiesFactory.createFallbacks(factories);
        } else {
            this.factories = null;
        }
    }

    private static Collection createFallbacks(Collection factories) {
        int authorityCount = 0;
        Citation[] authorities = new Citation[factories.size()];
        List[] factoriesByAuthority = new List[authorities.length];
        for (AuthorityFactory factory : factories) {
            ArrayList<AuthorityFactory> list;
            int authorityIndex;
            Citation authority = factory.getAuthority();
            for (authorityIndex = 0; authorityIndex < authorityCount; ++authorityIndex) {
                Citation candidate = authorities[authorityIndex];
                if (!Citations.identifierMatches(candidate, authority)) continue;
                authority = candidate;
                break;
            }
            if (authorityIndex == authorityCount) {
                authorities[authorityCount++] = authority;
                factoriesByAuthority[authorityIndex] = list = new ArrayList<AuthorityFactory>(4);
            } else {
                list = factoriesByAuthority[authorityIndex];
            }
            if (list.contains(factory)) continue;
            list.add(factory);
        }
        ArrayList<AuthorityFactory> result = new ArrayList<AuthorityFactory>();
        ArrayList<AuthorityFactory> buffer = new ArrayList<AuthorityFactory>(4);
        for (int i = 0; i < authorityCount; ++i) {
            List list = factoriesByAuthority[i];
            while (!list.isEmpty()) {
                AuthorityFactory primary = null;
                boolean needOtherChains = false;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    AuthorityFactory fallback = (AuthorityFactory)it.next();
                    if (primary == null) {
                        primary = fallback;
                    } else if (!FallbackAuthorityFactory.chainable(primary, fallback)) {
                        needOtherChains = true;
                        continue;
                    }
                    buffer.add(fallback);
                    if (needOtherChains) continue;
                    it.remove();
                }
                result.add(FallbackAuthorityFactory.create(buffer));
                buffer.clear();
            }
        }
        result.trimToSize();
        return result;
    }

    boolean sameAuthorityCodes(AuthorityFactory factory) {
        return factory == this;
    }

    protected char getSeparator(String code) {
        if (this.separator != '\u0000') {
            return this.separator;
        }
        code = code.trim();
        int length = code.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isLetterOrDigit(code.charAt(i))) continue;
            if (!code.regionMatches(i, "://", 0, 3)) break;
            return '/';
        }
        return ':';
    }

    private static boolean canSeparateAt(String code, int index) {
        char c;
        int i = index;
        do {
            if (--i >= 0) continue;
            return false;
        } while (Character.isWhitespace(c = code.charAt(i)));
        if (!Character.isJavaIdentifierPart(c)) {
            return false;
        }
        int length = code.length();
        i = index;
        do {
            if (++i < length) continue;
            return false;
        } while (Character.isWhitespace(c = code.charAt(i)));
        return Character.isJavaIdentifierPart(c);
    }

    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    public Citation getAuthority() {
        return ALL;
    }

    public Set getAuthorityNames() {
        HashSet names = new HashSet();
        if (this.factories != null) {
            for (AuthorityFactory factory : this.factories) {
                names.addAll(factory.getAuthority().getIdentifiers());
            }
        }
        return names;
    }

    public String getBackingStoreDescription() throws FactoryException {
        return null;
    }

    Collection dependencies() {
        return this.factories;
    }

    private static boolean exclude(AuthorityFactory factory) {
        if (ManyAuthoritiesFactory.class.isInstance(factory)) {
            return true;
        }
        if (factory instanceof AuthorityFactoryAdapter) {
            AuthorityFactoryAdapter adapter = (AuthorityFactoryAdapter)factory;
            return ManyAuthoritiesFactory.exclude((AuthorityFactory)adapter.crsFactory) || ManyAuthoritiesFactory.exclude((AuthorityFactory)adapter.csFactory) || ManyAuthoritiesFactory.exclude((AuthorityFactory)adapter.datumFactory) || ManyAuthoritiesFactory.exclude((AuthorityFactory)adapter.operationFactory);
        }
        return false;
    }

    final void fromFactoryRegistry(String authority, Class type, Set addTo) {
        for (int i = 0; i < OBJECT_TYPES.length; ++i) {
            AuthorityFactory factory;
            if (!OBJECT_TYPES[i].isAssignableFrom(type)) continue;
            try {
                factory = this.fromFactoryRegistry(authority, FACTORY_TYPES[i]);
            }
            catch (FactoryRegistryException e) {
                continue;
            }
            if (ManyAuthoritiesFactory.exclude(factory)) continue;
            addTo.add(factory);
        }
    }

    AuthorityFactory fromFactoryRegistry(String authority, Class type) throws FactoryRegistryException {
        return null;
    }

    final AuthorityFactory getAuthorityFactory(Class type, String code) throws NoSuchAuthorityCodeException {
        ManyAuthoritiesFactory.ensureNonNull("code", code);
        String authority = null;
        FactoryRegistryException cause = null;
        char separator = this.getSeparator(code);
        int split = code.lastIndexOf(separator);
        while (split >= 0) {
            block7: {
                if (ManyAuthoritiesFactory.canSeparateAt(code, split)) {
                    AuthorityFactory factory;
                    authority = code.substring(0, split).trim();
                    if (this.factories != null) {
                        for (AuthorityFactory factory2 : this.factories) {
                            if (!type.isAssignableFrom(factory2.getClass()) || !Citations.identifierMatches(factory2.getAuthority(), authority)) continue;
                            return factory2;
                        }
                    }
                    try {
                        factory = this.fromFactoryRegistry(authority, type);
                    }
                    catch (FactoryRegistryException exception) {
                        cause = exception;
                        break block7;
                    }
                    if (factory != null) {
                        return factory;
                    }
                }
            }
            split = code.lastIndexOf(separator, split - 1);
        }
        throw this.noSuchAuthority(code, authority, cause);
    }

    private NoSuchAuthorityCodeException noSuchAuthority(String code, String authority, FactoryRegistryException cause) {
        String message;
        if (authority == null) {
            authority = Vocabulary.format(176);
            message = Errors.format(182, code);
        } else {
            message = Errors.format(183, authority);
        }
        NoSuchAuthorityCodeException exception = new NoSuchAuthorityCodeException(message, authority, code);
        exception.initCause((Throwable)cause);
        return exception;
    }

    protected AuthorityFactory getAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(AuthorityFactory.class, code);
    }

    protected DatumAuthorityFactory getDatumAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        return (DatumAuthorityFactory)this.getAuthorityFactory(DatumAuthorityFactory.class, code);
    }

    protected CSAuthorityFactory getCSAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        return (CSAuthorityFactory)this.getAuthorityFactory(CSAuthorityFactory.class, code);
    }

    protected CRSAuthorityFactory getCRSAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        return (CRSAuthorityFactory)this.getAuthorityFactory(CRSAuthorityFactory.class, code);
    }

    protected CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        return (CoordinateOperationAuthorityFactory)this.getAuthorityFactory(CoordinateOperationAuthorityFactory.class, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAuthorityCodes(Class type) throws FactoryException {
        if (Boolean.TRUE.equals(this.inProgress.get())) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet<String> codes = new LinkedHashSet<String>();
        HashSet<AuthorityFactory> done = new HashSet<AuthorityFactory>();
        done.add(this);
        this.inProgress.set(Boolean.TRUE);
        try {
            Iterator it = this.getAuthorityNames().iterator();
            while (it.hasNext()) {
                String authority = ((String)it.next()).trim();
                char separator = this.getSeparator(authority);
                StringBuffer code = new StringBuffer(authority);
                int codeBase = code.length();
                if (codeBase != 0 && code.charAt(codeBase - 1) != separator) {
                    code.append(separator);
                    codeBase = code.length();
                }
                code.append("all");
                String dummyCode = code.toString();
                block8: for (int i = 0; i < FACTORY_TYPES.length; ++i) {
                    AuthorityFactory factory;
                    if (!OBJECT_TYPES[i].isAssignableFrom(type)) continue;
                    Class factoryType = FACTORY_TYPES[i];
                    try {
                        factory = this.getAuthorityFactory(factoryType, dummyCode);
                    }
                    catch (NoSuchAuthorityCodeException e) {
                        continue;
                    }
                    if (!done.add(factory)) continue;
                    AuthorityFactory wrapped = factory;
                    while (wrapped instanceof AuthorityFactoryAdapter) {
                        AuthorityFactoryAdapter adapter = (AuthorityFactoryAdapter)wrapped;
                        try {
                            wrapped = adapter.getAuthorityFactory(factoryType, dummyCode);
                        }
                        catch (NoSuchAuthorityCodeException exception) {
                            continue block8;
                        }
                        if (done.add(wrapped)) continue;
                        continue block8;
                    }
                    Iterator it2 = factory.getAuthorityCodes(type).iterator();
                    while (it2.hasNext()) {
                        String candidate = ((String)it2.next()).trim();
                        if (candidate.length() < codeBase || Character.isLetterOrDigit(candidate.charAt(codeBase - 1)) || !authority.equalsIgnoreCase(candidate.substring(0, codeBase - 1))) {
                            code.setLength(codeBase);
                            code.append(candidate);
                            candidate = code.toString();
                        }
                        codes.add(candidate);
                    }
                }
            }
        }
        finally {
            this.inProgress.set(Boolean.FALSE);
        }
        return codes;
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        HashSet<AuthorityFactory> done = new HashSet<AuthorityFactory>();
        done.add(this);
        Throwable failure = null;
        for (int type = 0; type < FACTORY_TYPES.length; ++type) {
            AuthorityFactory factory;
            try {
                factory = this.getAuthorityFactory(FACTORY_TYPES[type], code);
            }
            catch (NoSuchAuthorityCodeException exception) {
                if (failure != null) continue;
                failure = exception;
                continue;
            }
            if (!done.add(factory)) continue;
            try {
                return factory.getDescriptionText(code);
            }
            catch (FactoryException exception) {
                if (failure != null && !(failure.getCause() instanceof FactoryRegistryException)) continue;
                failure = exception;
            }
        }
        if (failure == null) {
            failure = this.noSuchAuthorityCode(IdentifiedObject.class, code);
        }
        throw failure;
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        HashSet<AuthorityFactory> done = new HashSet<AuthorityFactory>();
        done.add(this);
        Throwable failure = null;
        for (int type = 0; type < FACTORY_TYPES.length; ++type) {
            AuthorityFactory factory;
            try {
                factory = this.getAuthorityFactory(FACTORY_TYPES[type], code);
            }
            catch (NoSuchAuthorityCodeException exception) {
                if (failure != null) continue;
                failure = exception;
                continue;
            }
            if (!done.add(factory)) continue;
            try {
                return factory.createObject(code);
            }
            catch (FactoryException exception) {
                if (failure != null && !(failure.getCause() instanceof FactoryRegistryException)) continue;
                failure = exception;
            }
        }
        if (failure == null) {
            failure = this.noSuchAuthorityCode(IdentifiedObject.class, code);
        }
        throw failure;
    }

    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class type) throws FactoryException {
        return new Finder(this, type);
    }

    static class Finder
    extends IdentifiedObjectFinder {
        protected Finder(ManyAuthoritiesFactory factory, Class type) {
            super(factory, type);
        }

        final Collection getFactories() {
            return ((ManyAuthoritiesFactory)this.getProxy().getAuthorityFactory()).factories;
        }

        final IdentifiedObjectFinder next(Iterator it) throws FactoryException {
            while (it.hasNext()) {
                IdentifiedObjectFinder finder;
                AuthorityFactory factory = (AuthorityFactory)it.next();
                if (ManyAuthoritiesFactory.exclude(factory) || !(factory instanceof AbstractAuthorityFactory) || (finder = ((AbstractAuthorityFactory)factory).getIdentifiedObjectFinder(this.getProxy().getType())) == null) continue;
                finder.setFullScanAllowed(this.isFullScanAllowed());
                return finder;
            }
            return null;
        }

        public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate;
            block2: {
                IdentifiedObjectFinder finder;
                candidate = this.createFromIdentifiers(object);
                if (candidate != null) {
                    return candidate;
                }
                Collection factories = this.getFactories();
                if (factories == null) break block2;
                Iterator it = factories.iterator();
                while ((finder = this.next(it)) != null && (candidate = finder.find(object)) == null) {
                }
            }
            return candidate;
        }

        public String findIdentifier(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate = this.createFromIdentifiers(object);
            if (candidate != null) {
                return candidate.getName().toString();
            }
            Collection factories = this.getFactories();
            if (factories != null) {
                IdentifiedObjectFinder finder;
                Iterator it = factories.iterator();
                while ((finder = this.next(it)) != null) {
                    String id = finder.findIdentifier(object);
                    if (id == null) continue;
                    return id;
                }
            }
            return null;
        }
    }
}

