/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AllAuthoritiesFactory;
import org.geotools.referencing.factory.AuthorityFactoryAdapter;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class HTTP_AuthorityFactory
extends AuthorityFactoryAdapter
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    public static final String BASE_URL = "http://www.opengis.net/gml/srs/";

    public HTTP_AuthorityFactory() {
        this(new Hints(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE));
    }

    public HTTP_AuthorityFactory(Hints userHints) {
        this(new AllAuthoritiesFactory(userHints));
    }

    public HTTP_AuthorityFactory(AllAuthoritiesFactory factory) {
        super(factory);
    }

    public Citation getAuthority() {
        return Citations.HTTP_OGC;
    }

    protected String toBackingFactoryCode(String code) throws FactoryException {
        int split;
        int length;
        if ((code = code.trim()).regionMatches(true, 0, BASE_URL, 0, length = BASE_URL.length()) && (code = code.substring(length)).indexOf(47) < 0 && (split = code.indexOf(35)) >= 0 && code.indexOf(35, split + 1) < 0) {
            String authority = code.substring(0, split).trim();
            int ext = authority.lastIndexOf(46);
            if (ext > 0) {
                authority = authority.substring(0, ext);
            }
            code = code.substring(split + 1).trim();
            code = authority + ':' + code;
            return code;
        }
        throw new NoSuchAuthorityCodeException(Errors.format(42, "code", code), BASE_URL, code);
    }
}

