/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.geotools.factory.BufferedFactory;
import org.geotools.factory.OptionalFactory;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.resources.OptionalDependencies;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.Factory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;

public class FactoryDependencies {
    private static final Class[] TYPES = new Class[]{CRSFactory.class, CRSAuthorityFactory.class, CSFactory.class, CSAuthorityFactory.class, DatumFactory.class, DatumAuthorityFactory.class, CoordinateOperationFactory.class, CoordinateOperationAuthorityFactory.class, BufferedFactory.class, OptionalFactory.class, Factory.class};
    private static final String[] TYPE_LABELS = new String[]{"crs", "crs", "cs", "cs", "datum", "datum", "operation", "operation", "buffered", "optional", "registered"};
    private static final int FACTORY_COUNT = TYPES.length - 3;
    private final Factory factory;
    private boolean colorEnabled;
    private boolean attributes;

    public FactoryDependencies(Factory factory) {
        this.factory = factory;
    }

    public boolean isColorEnabled() {
        return this.colorEnabled;
    }

    public void setColorEnabled(boolean enabled) {
        this.colorEnabled = enabled;
    }

    public boolean isAttributeEnabled() {
        return this.attributes;
    }

    public void setAttributeEnabled(boolean enabled) {
        this.attributes = enabled;
    }

    public void print(PrintWriter out) {
        out.print(OptionalDependencies.toString(this.asTree()));
    }

    public void print(Writer out) throws IOException {
        out.write(OptionalDependencies.toString(this.asTree()));
    }

    public TreeNode asTree() {
        return this.createTree(this.factory, new HashSet());
    }

    private MutableTreeNode createTree(Factory factory, Set done) {
        Collection dep;
        DefaultMutableTreeNode root = this.createNode(factory);
        if (factory instanceof ReferencingFactory && (dep = ((ReferencingFactory)factory).dependencies()) != null) {
            for (Object element : dep) {
                MutableTreeNode child;
                if (element instanceof Factory) {
                    Factory candidate = (Factory)element;
                    if (!done.add(candidate)) continue;
                    child = this.createTree(candidate, done);
                    if (!done.remove(candidate)) {
                        throw new AssertionError();
                    }
                } else {
                    child = OptionalDependencies.createTreeNode(String.valueOf(element), element, false);
                }
                root.add(child);
            }
        }
        return root;
    }

    private DefaultMutableTreeNode createNode(Factory factory) {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(factory)).append('[');
        if (factory instanceof AuthorityFactory) {
            Citation authority = ((AuthorityFactory)factory).getAuthority();
            if (authority != null) {
                Collection identifiers = authority.getIdentifiers();
                if (identifiers != null && !identifiers.isEmpty()) {
                    boolean next = false;
                    Iterator it = identifiers.iterator();
                    while (it.hasNext()) {
                        if (next) {
                            buffer.append(", ");
                        }
                        this.appendIdentifier(buffer, (String)it.next());
                        next = true;
                    }
                } else {
                    this.appendIdentifier(buffer, (CharSequence)authority.getTitle());
                }
            }
        } else {
            if (this.colorEnabled) {
                buffer.append("\u001b[31m");
            }
            buffer.append("direct");
            if (this.colorEnabled) {
                buffer.append("\u001b[39m");
            }
        }
        buffer.append(']');
        if (this.attributes) {
            boolean hasFound = false;
            for (int i = 0; i < TYPES.length; ++i) {
                Class type = TYPES[i];
                if (!type.isInstance(factory) || type.equals(Factory.class) && !ReferencingFactoryFinder.isRegistered(factory)) continue;
                buffer.append(hasFound ? ", " : " (");
                if (this.colorEnabled) {
                    buffer.append(i < FACTORY_COUNT ? "\u001b[32m" : "\u001b[36m");
                }
                buffer.append(TYPE_LABELS[i]);
                if (this.colorEnabled) {
                    buffer.append("\u001b[39m");
                }
                hasFound = true;
            }
            if (hasFound) {
                buffer.append(')');
            }
        }
        return OptionalDependencies.createTreeNode(buffer.toString(), factory, true);
    }

    private void appendIdentifier(StringBuffer buffer, CharSequence identifier) {
        if (this.colorEnabled) {
            buffer.append("\u001b[35m");
        }
        buffer.append('\"').append(identifier).append('\"');
        if (this.colorEnabled) {
            buffer.append("\u001b[39m");
        }
    }
}

