/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.datum.AbstractDatum;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.util.InternationalString;

public class DefaultTemporalDatum
extends AbstractDatum
implements TemporalDatum {
    private static final long serialVersionUID = 3357241732140076884L;
    public static final DefaultTemporalDatum UNIX = new DefaultTemporalDatum("UNIX", new Date(0L));
    private final long origin;

    public DefaultTemporalDatum(TemporalDatum datum) {
        super((Datum)datum);
        this.origin = datum.getOrigin().getTime();
    }

    public DefaultTemporalDatum(String name, Date origin) {
        this(Collections.singletonMap("name", name), origin);
    }

    public DefaultTemporalDatum(Map properties, Date origin) {
        super(properties);
        DefaultTemporalDatum.ensureNonNull("origin", origin);
        this.origin = origin.getTime();
    }

    public Date getOrigin() {
        return new Date(this.origin);
    }

    public InternationalString getAnchorPoint() {
        return super.getAnchorPoint();
    }

    public Date getRealizationEpoch() {
        return super.getRealizationEpoch();
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultTemporalDatum that = (DefaultTemporalDatum)object;
            return this.origin == that.origin;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ (int)this.origin ^ (int)(this.origin >>> 32);
    }
}

