/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.charset.CharsetUTF32;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetUTF32BE
extends CharsetUTF32 {
    public CharsetUTF32BE(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoderUTF32BE((CharsetICU)this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoderUTF32BE((CharsetICU)this);
    }

    class CharsetEncoderUTF32BE
    extends CharsetUTF32.CharsetEncoderUTF32 {
        public CharsetEncoderUTF32BE(CharsetICU cs) {
            super(cs);
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
            this.fromUnicodeStatus = 0;
            this.writeBOM = false;
        }
    }

    class CharsetDecoderUTF32BE
    extends CharsetUTF32.CharsetDecoderUTF32 {
        public CharsetDecoderUTF32BE(CharsetICU cs) {
            super(cs);
            this.mode = 1;
            CharsetUTF32BE.this.bom = 1;
        }

        protected CoderResult decodeLoopImpl(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            return this.decodeLoopUTF32BE(source, target, offsets, flush);
        }

        protected int getChar(byte[] bytes, int length) {
            int ch = 0;
            for (int i = 0; i < length; ++i) {
                ch |= (bytes[i] & 0xFF) << (3 - i) * 8;
            }
            return ch;
        }
    }
}

