/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetProviderICU;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;

public abstract class CharsetICU
extends Charset {
    String icuCanonicalName;
    String javaCanonicalName;
    int options;
    float maxCharsPerByte;
    String name;
    int codepage;
    byte platform;
    byte conversionType;
    int minBytesPerChar;
    int maxBytesPerChar;
    byte[] subChar;
    byte subCharLen;
    byte hasToUnicodeFallback;
    byte hasFromUnicodeFallback;
    short unicodeMask;
    byte subChar1;
    private static final HashMap algorithmicCharsets = new HashMap();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    protected CharsetICU(String icuCanonicalName, String canonicalName, String[] aliases) {
        super(canonicalName, aliases);
        if (canonicalName.length() == 0) {
            throw new IllegalCharsetNameException(canonicalName);
        }
        this.javaCanonicalName = canonicalName;
        this.icuCanonicalName = icuCanonicalName;
    }

    public boolean contains(Charset cs) {
        if (null == cs) {
            return false;
        }
        return this.equals(cs);
    }

    static final Charset getCharset(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        String className = (String)algorithmicCharsets.get(icuCanonicalName);
        if (className == null) {
            className = "com.ibm.icu.charset.CharsetMBCS";
        }
        try {
            CharsetICU conv = null;
            Class<?> cs = Class.forName(className);
            Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CharsetICU.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CharsetICU.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = CharsetICU.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
            Constructor<?> c = cs.getConstructor(paramTypes);
            Object[] params = new Object[]{icuCanonicalName, javaCanonicalName, aliases};
            try {
                Object obj = c.newInstance(params);
                if (obj != null && obj instanceof CharsetICU) {
                    conv = (CharsetICU)obj;
                    return conv;
                }
            }
            catch (InvocationTargetException e) {
                throw new UnsupportedCharsetException(icuCanonicalName + ": " + "Could not load " + className + ". Exception:" + e.getTargetException());
            }
        }
        catch (ClassNotFoundException ex) {
        }
        catch (NoSuchMethodException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
            // empty catch block
        }
        throw new UnsupportedCharsetException(icuCanonicalName + ": " + "Could not load " + className);
    }

    static final boolean isSurrogate(int c) {
        return (c & 0xFFFFF800) == 55296;
    }

    public static Charset forNameICU(String charsetName) throws IllegalCharsetNameException, UnsupportedCharsetException {
        CharsetProviderICU icuProvider = new CharsetProviderICU();
        CharsetICU cs = (CharsetICU)icuProvider.charsetForName(charsetName);
        if (cs != null) {
            return cs;
        }
        return Charset.forName(charsetName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        algorithmicCharsets.put("US-ASCII", "com.ibm.icu.charset.CharsetASCII");
        algorithmicCharsets.put("ISO-8859-1", "com.ibm.icu.charset.Charset88591");
        algorithmicCharsets.put("UTF-16", "com.ibm.icu.charset.CharsetUTF16");
        algorithmicCharsets.put("UTF-16BE", "com.ibm.icu.charset.CharsetUTF16BE");
        algorithmicCharsets.put("UTF-16LE", "com.ibm.icu.charset.CharsetUTF16LE");
        algorithmicCharsets.put("UTF16_OppositeEndian", "com.ibm.icu.charset.CharsetUTF16LE");
        algorithmicCharsets.put("UTF16_PlatformEndian", "com.ibm.icu.charset.CharsetUTF16");
        algorithmicCharsets.put("UTF-32", "com.ibm.icu.charset.CharsetUTF32");
        algorithmicCharsets.put("UTF-32BE", "com.ibm.icu.charset.CharsetUTF32BE");
        algorithmicCharsets.put("UTF-32LE", "com.ibm.icu.charset.CharsetUTF32LE");
        algorithmicCharsets.put("UTF32_OppositeEndian", "com.ibm.icu.charset.CharsetUTF32LE");
        algorithmicCharsets.put("UTF32_PlatformEndian", "com.ibm.icu.charset.CharsetUTF32");
        algorithmicCharsets.put("UTF-8", "com.ibm.icu.charset.CharsetUTF8");
        algorithmicCharsets.put("CESU-8", "com.ibm.icu.charset.CharsetCESU8");
        algorithmicCharsets.put("UTF-7", "com.ibm.icu.charset.CharsetUTF7");
        algorithmicCharsets.put("ISCII,version=0", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=1", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=2", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=3", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=4", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=5", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=6", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=7", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("ISCII,version=8", "com.ibm.icu.charset.CharsetISCII");
        algorithmicCharsets.put("IMAP-mailbox-name", "com.ibm.icu.charset.CharsetUTF7");
    }
}

