/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.LocalizationGridTransform2D;
import org.geotools.referencing.operation.transform.WarpTransform2D;
import org.opengis.referencing.operation.MathTransform2D;

public class LocalizationGrid {
    private static final int X_OFFSET = 0;
    private static final int Y_OFFSET = 1;
    private static final int CP_LENGTH = 2;
    private final int width;
    private final int height;
    private double[] grid;
    private transient AffineTransform global;
    private transient MathTransform2D[] transforms;
    private static final int INCREASING = 1;
    private static final int DECREASING = 2;
    private static final int EQUALS = 4;

    public LocalizationGrid(int width, int height) {
        if (width < 2) {
            throw new IllegalArgumentException(String.valueOf(width));
        }
        if (height < 2) {
            throw new IllegalArgumentException(String.valueOf(height));
        }
        this.width = width;
        this.height = height;
        this.grid = new double[width * height * 2];
        Arrays.fill(this.grid, Double.NaN);
    }

    private int computeOffset(int col, int row) {
        if (col < 0 || col >= this.width) {
            throw new IndexOutOfBoundsException(String.valueOf(col));
        }
        if (row < 0 || row >= this.height) {
            throw new IndexOutOfBoundsException(String.valueOf(row));
        }
        return (col + row * this.width) * 2;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public synchronized Point2D getLocalizationPoint(Point source) {
        int offset = this.computeOffset(source.x, source.y);
        return new Point2D.Double(this.grid[offset + 0], this.grid[offset + 1]);
    }

    public void setLocalizationPoint(Point source, Point2D target) {
        this.setLocalizationPoint(source.x, source.y, target.getX(), target.getY());
    }

    public synchronized void setLocalizationPoint(int sourceX, int sourceY, double targetX, double targetY) {
        int offset = this.computeOffset(sourceX, sourceY);
        this.notifyChange();
        this.global = null;
        this.grid[offset + 0] = targetX;
        this.grid[offset + 1] = targetY;
    }

    public synchronized void transform(AffineTransform transform, Rectangle region) {
        if (region == null) {
            transform.transform(this.grid, 0, this.grid, 0, this.width * this.height);
            return;
        }
        this.computeOffset(region.x, region.y);
        int j = region.x + region.width;
        if (j > this.width) {
            throw new IndexOutOfBoundsException(String.valueOf(j));
        }
        j = region.y + region.height;
        while (--j >= region.y) {
            int offset = this.computeOffset(region.x, j);
            this.notifyChange();
            transform.transform(this.grid, offset, this.grid, offset, region.width);
        }
        this.global = null;
    }

    public synchronized boolean isNaN() {
        int i = this.grid.length;
        while (--i >= 0) {
            if (!Double.isNaN(this.grid[i])) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isMonotonic(boolean strict) {
        int s;
        int offset;
        int orderX = 3;
        int orderY = 3;
        if (!strict) {
            orderX |= 4;
            orderY |= 4;
        }
        for (int i = 0; i < this.width; ++i) {
            offset = this.computeOffset(i, 0);
            orderX = LocalizationGrid.testOrder(this.grid, offset + 0, this.height, s = 2 * this.width, orderX);
            if (orderX == 0) {
                return false;
            }
            if ((orderY = LocalizationGrid.testOrder(this.grid, offset + 1, this.height, s, orderY)) != 0) continue;
            return false;
        }
        orderX = 3;
        orderY = 3;
        if (!strict) {
            orderX |= 4;
            orderY |= 4;
        }
        for (int j = 0; j < this.height; ++j) {
            offset = this.computeOffset(0, j);
            s = 2;
            if ((orderX = LocalizationGrid.testOrder(this.grid, offset + 0, this.width, 2, orderX)) == 0) {
                return false;
            }
            if ((orderY = LocalizationGrid.testOrder(this.grid, offset + 1, this.width, 2, orderY)) != 0) continue;
            return false;
        }
        return true;
    }

    private static int testOrder(double[] grid, int offset, int num, int step, int flags) {
        --num;
        while (--num >= 0) {
            double v1 = grid[offset];
            if (!Double.isNaN(v1)) {
                int clear;
                int required;
                while (true) {
                    double v2;
                    if (v1 == (v2 = grid[offset + step])) {
                        required = 4;
                        clear = -1;
                        break;
                    }
                    if (v2 > v1) {
                        required = 1;
                        clear = -3;
                        break;
                    }
                    if (v2 < v1) {
                        required = 2;
                        clear = -2;
                        break;
                    }
                    if (--num < 0) {
                        return flags;
                    }
                    offset += step;
                }
                if ((flags & required) == 0) {
                    return 0;
                }
                flags &= clear;
            }
            offset += step;
        }
        return flags;
    }

    public void removeSingularities() {
        this.removeSingularities(0, false);
        this.removeSingularities(0, true);
        this.removeSingularities(1, false);
        this.removeSingularities(1, true);
    }

    private void removeSingularities(int index, boolean vertical) {
        int val2;
        int val1;
        int step;
        if (vertical) {
            step = 2 * this.width;
            val1 = this.width;
            val2 = this.height;
        } else {
            step = 2;
            val1 = this.height;
            val2 = this.width;
        }
        for (int i = 0; i < val1; ++i) {
            int offset = vertical ? this.computeOffset(i, 0) + index : this.computeOffset(0, i) + index;
            int singularityOffset = -1;
            for (int j = 1; j < val2; ++j) {
                int previousOffset = offset + step * (j - 1);
                int currentOffset = previousOffset + step;
                if (this.grid[previousOffset] == this.grid[currentOffset]) {
                    if (singularityOffset != -1) continue;
                    singularityOffset = previousOffset == offset ? previousOffset : previousOffset - step;
                    continue;
                }
                if (singularityOffset == -1) continue;
                int num = (currentOffset - singularityOffset) / step + 1;
                LocalizationGrid.replaceSingularity(this.grid, singularityOffset, num, step);
                singularityOffset = -1;
            }
            if (singularityOffset == -1) continue;
            int currentOffset = offset + step * (val2 - 1);
            int num = (currentOffset - singularityOffset) / step + 1;
            LocalizationGrid.replaceSingularity(this.grid, singularityOffset, num, step);
        }
    }

    private static void replaceSingularity(double[] grid, int offset, int num, int step) {
        double increment = (grid[offset + (num - 1) * step] - grid[offset]) / (double)(num - 1);
        double value = grid[offset];
        offset += step;
        int i = 0;
        while (i < num - 2) {
            grid[offset] = value + increment * (double)(i + 1);
            ++i;
            offset += step;
        }
    }

    public synchronized AffineTransform getAffineTransform() {
        if (this.global == null) {
            double[] matrix = new double[6];
            this.fitPlane(0, matrix);
            this.fitPlane(1, matrix);
            this.global = new AffineTransform(matrix);
        }
        return (AffineTransform)this.global.clone();
    }

    private void fitPlane(int offset, double[] coeff) {
        double zy = 0.0;
        double zx = 0.0;
        double z = 0.0;
        int n = offset;
        for (int yi = 0; yi < this.height; ++yi) {
            for (int xi = 0; xi < this.width; ++xi) {
                assert (this.computeOffset(xi, yi) + offset == n) : n;
                double zi = this.grid[n];
                z += zi;
                zx += zi * (double)xi;
                zy += zi * (double)yi;
                n += 2;
            }
        }
        n = (n - offset) / 2;
        assert (n == this.width * this.height) : n;
        double x = (double)n * (double)(this.width - 1) / 2.0;
        double y = (double)n * (double)(this.height - 1) / 2.0;
        double xx = (double)n * ((double)this.width - 0.5) * (double)(this.width - 1) / 3.0;
        double yy = (double)n * ((double)this.height - 0.5) * (double)(this.height - 1) / 3.0;
        double xy = (double)n * (double)((this.height - 1) * (this.width - 1)) / 4.0;
        double den = (xy -= x * y / (double)n) * xy - (xx -= x * x / (double)n) * (yy -= y * y / (double)n);
        double cy = ((zx -= z * x / (double)n) * xy - (zy -= z * y / (double)n) * xx) / den;
        double cx = (zy * xy - zx * yy) / den;
        double c = (z - (cx * x + cy * y)) / (double)n;
        coeff[0 + offset] = cx;
        coeff[2 + offset] = cy;
        coeff[4 + offset] = c;
    }

    private MathTransform2D fitWarps(int degree) {
        float[] srcCoords = new float[this.width * this.height * 2];
        float[] dstCoords = new float[srcCoords.length];
        int gridOffset = 0;
        int warpOffset = 0;
        for (int yi = 0; yi < this.height; ++yi) {
            for (int xi = 0; xi < this.width; ++xi) {
                assert (gridOffset == this.computeOffset(xi, yi));
                float x = (float)this.grid[gridOffset + 0];
                float y = (float)this.grid[gridOffset + 1];
                if (!Float.isNaN(x) && !Float.isNaN(y)) {
                    srcCoords[warpOffset] = xi;
                    srcCoords[warpOffset + 1] = yi;
                    dstCoords[warpOffset] = x;
                    dstCoords[warpOffset + 1] = y;
                    warpOffset += 2;
                }
                gridOffset += 2;
            }
        }
        return new WarpTransform2D(null, srcCoords, 0, null, dstCoords, 0, warpOffset / 2, degree);
    }

    public synchronized MathTransform2D getPolynomialTransform(int degree) {
        if (degree < 0 || degree >= 8) {
            throw new IllegalArgumentException();
        }
        if (this.transforms == null) {
            this.transforms = new MathTransform2D[8];
        }
        if (this.transforms[degree] == null) {
            MathTransform2D tr;
            switch (degree) {
                case 0: {
                    tr = new LocalizationGridTransform2D(this.width, this.height, this.grid, this.getAffineTransform());
                    break;
                }
                case 1: {
                    tr = new AffineTransform2D(this.getAffineTransform());
                    break;
                }
                default: {
                    tr = this.fitWarps(degree);
                }
            }
            this.transforms[degree] = tr;
        }
        return this.transforms[degree];
    }

    public final MathTransform2D getMathTransform() {
        return this.getPolynomialTransform(0);
    }

    private void notifyChange() {
        if (this.transforms != null) {
            if (this.transforms[0] != null) {
                this.grid = (double[])this.grid.clone();
            }
            this.transforms = null;
        }
    }
}

