/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder.algorithm;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import org.geotools.referencing.operation.builder.algorithm.Polygon;
import org.geotools.referencing.operation.builder.algorithm.TINTriangle;
import org.geotools.referencing.operation.builder.algorithm.TriangulationException;
import org.opengis.geometry.DirectPosition;

public class Quadrilateral
extends Polygon {
    public DirectPosition p0;
    public DirectPosition p1;
    public DirectPosition p2;
    public DirectPosition p3;

    public Quadrilateral(DirectPosition p0, DirectPosition p1, DirectPosition p2, DirectPosition p3) {
        super(new DirectPosition[]{p0, p1, p2, p3, p0});
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
    }

    public boolean isConvex() {
        return Line2D.linesIntersect(this.p0.getCoordinates()[0], this.p0.getCoordinates()[1], this.p2.getCoordinates()[0], this.p2.getCoordinates()[1], this.p1.getCoordinates()[0], this.p1.getCoordinates()[1], this.p3.getCoordinates()[0], this.p3.getCoordinates()[1]);
    }

    public List getTriangles() {
        ArrayList<TINTriangle> triangles = new ArrayList<TINTriangle>();
        TINTriangle trigA = new TINTriangle(this.p0, this.p1, this.p2);
        TINTriangle trigB = new TINTriangle(this.p0, this.p3, this.p2);
        try {
            trigA.addAdjacentTriangle(trigB);
            trigB.addAdjacentTriangle(trigA);
        }
        catch (TriangulationException e) {
            e.printStackTrace();
        }
        triangles.add(trigA);
        triangles.add(trigB);
        return triangles;
    }
}

