/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder.algorithm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.builder.algorithm.ExtendedPosition;
import org.geotools.referencing.operation.builder.algorithm.Quadrilateral;
import org.geotools.referencing.operation.builder.algorithm.TINTriangle;
import org.geotools.referencing.operation.builder.algorithm.TriangulationException;
import org.geotools.referencing.operation.builder.algorithm.TriangulationFactory;
import org.opengis.geometry.DirectPosition;

public class MapTriangulationFactory {
    private final Quadrilateral quad;
    private final List vectors;

    public MapTriangulationFactory(Quadrilateral quad, List vectors) throws TriangulationException {
        this.quad = quad;
        this.vectors = vectors;
    }

    public Map getTriangleMap() throws TriangulationException {
        Quadrilateral mQuad = this.mappedQuad(this.quad, this.vectors);
        DirectPosition[] vertices = new ExtendedPosition[this.vectors.size()];
        for (int i = 0; i < this.vectors.size(); ++i) {
            vertices[i] = new ExtendedPosition(((MappedPosition)this.vectors.get(i)).getSource(), ((MappedPosition)this.vectors.get(i)).getTarget());
        }
        TriangulationFactory triangulator = new TriangulationFactory(mQuad, vertices);
        List taggedSourceTriangles = triangulator.getTriangulation();
        HashMap<TINTriangle, TINTriangle> triangleMap = new HashMap<TINTriangle, TINTriangle>();
        for (TINTriangle sourceTriangle : taggedSourceTriangles) {
            triangleMap.put(sourceTriangle, new TINTriangle(((ExtendedPosition)sourceTriangle.p0).getMappedposition(), ((ExtendedPosition)sourceTriangle.p1).getMappedposition(), ((ExtendedPosition)sourceTriangle.p2).getMappedposition()));
        }
        return triangleMap;
    }

    private Quadrilateral mappedQuad(Quadrilateral sourceQuad, List vectors) {
        if (vectors.isEmpty()) {
            return (Quadrilateral)sourceQuad.clone();
        }
        MappedPosition[] mappedVertices = new MappedPosition[4];
        for (int i = 0; i < mappedVertices.length; ++i) {
            mappedVertices[i] = this.generateCoordFromNearestOne(sourceQuad.getPoints()[i], vectors);
        }
        return new Quadrilateral(new ExtendedPosition(mappedVertices[0].getSource(), mappedVertices[0].getTarget()), new ExtendedPosition(mappedVertices[1].getSource(), mappedVertices[1].getTarget()), new ExtendedPosition(mappedVertices[2].getSource(), mappedVertices[2].getTarget()), new ExtendedPosition(mappedVertices[3].getSource(), mappedVertices[3].getTarget()));
    }

    protected MappedPosition generateCoordFromNearestOne(DirectPosition x, List vertices) {
        MappedPosition nearestOne = this.nearestMappedCoordinate(x, vertices);
        double dstX = x.getCoordinates()[0] + (nearestOne.getTarget().getCoordinates()[0] - nearestOne.getSource().getCoordinates()[0]);
        double dstY = x.getCoordinates()[1] + (nearestOne.getTarget().getCoordinates()[1] - nearestOne.getSource().getCoordinates()[1]);
        DirectPosition2D dst = new DirectPosition2D(nearestOne.getTarget().getCoordinateReferenceSystem(), dstX, dstY);
        return new MappedPosition(x, dst);
    }

    protected MappedPosition nearestMappedCoordinate(DirectPosition dp, List vertices) {
        DirectPosition2D x = new DirectPosition2D(dp);
        MappedPosition nearestOne = (MappedPosition)vertices.get(0);
        for (MappedPosition candidate : vertices) {
            if (!(((DirectPosition2D)candidate.getSource()).distance(x.toPoint2D()) < ((DirectPosition2D)nearestOne.getSource()).distance(x.toPoint2D()))) continue;
            nearestOne = candidate;
        }
        return nearestOne;
    }
}

