/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.geotools.factory.Hints;
import org.geotools.io.IndentedLineWriter;
import org.geotools.io.TableWriter;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.PropertyAuthorityFactory;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotools.resources.Arguments;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FactoryUsingWKT
extends DeferredAuthorityFactory
implements CRSAuthorityFactory {
    public static final String CRS_DIRECTORY_KEY = "org.geotools.referencing.crs-directory";
    private Citation authority;
    public static final String FILENAME = "epsg.properties";
    private final ReferencingFactoryContainer factories;
    protected static final int DEFAULT_PRIORITY = 80;
    private final File directory;

    public FactoryUsingWKT() {
        this((Hints)null);
    }

    public FactoryUsingWKT(Hints userHints) {
        this(userHints, 80);
    }

    protected FactoryUsingWKT(Hints userHints, int priority) {
        super(userHints, priority);
        this.factories = ReferencingFactoryContainer.instance(userHints);
        Object hint = null;
        if (userHints != null) {
            hint = userHints.get(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY);
        }
        this.directory = hint instanceof File ? (File)hint : (hint instanceof String ? new File((String)hint) : null);
        this.hints.put(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY, this.directory);
        this.setTimeout(900000L);
    }

    public Citation getAuthority() {
        if (this.authority == null) {
            Citation[] authorities = this.getAuthorities();
            switch (authorities.length) {
                case 0: {
                    this.authority = Citations.EPSG;
                    break;
                }
                case 1: {
                    this.authority = authorities[0];
                    break;
                }
                default: {
                    CitationImpl c = new CitationImpl(authorities[0]);
                    Collection types = c.getIdentifierTypes();
                    Collection identifiers = c.getIdentifiers();
                    for (int i = 1; i < authorities.length; ++i) {
                        types.add("Authority name");
                        identifiers.add(Citations.getIdentifier(authorities[i]));
                    }
                    c.freeze();
                    this.authority = c;
                    break;
                }
            }
        }
        return this.authority;
    }

    protected Citation[] getAuthorities() {
        return new Citation[]{Citations.EPSG};
    }

    protected URL getDefinitionsURL() {
        try {
            File file;
            if (this.directory != null && (file = new File(this.directory, FILENAME)).isFile()) {
                return file.toURI().toURL();
            }
        }
        catch (SecurityException exception) {
            org.geotools.util.Logging.unexpectedException(LOGGER, exception);
        }
        catch (MalformedURLException exception) {
            org.geotools.util.Logging.unexpectedException(LOGGER, exception);
        }
        return FactoryUsingWKT.class.getResource(FILENAME);
    }

    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        try {
            URL url = this.getDefinitionsURL();
            if (url == null) {
                throw new FactoryNotFoundException(Errors.format(36, FILENAME));
            }
            Iterator ids = this.getAuthority().getIdentifiers().iterator();
            String authority = ids.hasNext() ? (String)ids.next() : "EPSG";
            LOGGER.log(Logging.format(Level.CONFIG, 27, url.getPath(), authority));
            return new PropertyAuthorityFactory(this.factories, this.getAuthorities(), url);
        }
        catch (IOException exception) {
            throw new FactoryException(Errors.format(163, FILENAME), (Throwable)exception);
        }
    }

    private static final AbstractAuthorityFactory getFactory(Class type) {
        return (AbstractAuthorityFactory)ReferencingFactoryFinder.getCRSAuthorityFactory("EPSG", new Hints(Hints.CRS_AUTHORITY_FACTORY, type));
    }

    protected Set reportDuplicatedCodes(PrintWriter out) throws FactoryException {
        AbstractAuthorityFactory sqlFactory = FactoryUsingWKT.getFactory(ThreadedEpsgFactory.class);
        Vocabulary resources = Vocabulary.getResources(null);
        out.println(resources.getLabel(236));
        try {
            IndentedLineWriter w = new IndentedLineWriter(out);
            w.setIndentation(4);
            w.write(sqlFactory.getBackingStoreDescription());
            w.flush();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        out.println();
        Set wktCodes = this.getAuthorityCodes(IdentifiedObject.class);
        Set sqlCodes = sqlFactory.getAuthorityCodes(IdentifiedObject.class);
        TreeSet<String> duplicated = new TreeSet<String>();
        Iterator it = wktCodes.iterator();
        while (it.hasNext()) {
            String code = ((String)it.next()).trim();
            if (!sqlCodes.contains(code)) continue;
            duplicated.add(code);
        }
        if (duplicated.isEmpty()) {
            out.println(resources.getString(238));
        } else {
            for (String code : duplicated) {
                out.print(resources.getLabel(237));
                out.println(code);
            }
        }
        return duplicated;
    }

    protected Set reportInstantiationFailures(PrintWriter out) throws FactoryException {
        Set codes = this.getAuthorityCodes(CoordinateReferenceSystem.class);
        TreeMap<String, String> failures = new TreeMap<String, String>();
        for (String code : codes) {
            try {
                this.createCoordinateReferenceSystem(code);
            }
            catch (FactoryException exception) {
                failures.put(code, exception.getLocalizedMessage());
            }
        }
        if (!failures.isEmpty()) {
            TableWriter writer = new TableWriter((Writer)out, " ");
            for (Map.Entry entry : failures.entrySet()) {
                writer.write((String)entry.getKey());
                writer.write(58);
                writer.nextColumn();
                writer.write((String)entry.getValue());
                writer.nextLine();
            }
            try {
                writer.flush();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return failures.keySet();
    }

    public static void main(String[] args) throws FactoryException {
        FactoryUsingWKT.main(args, FactoryUsingWKT.class);
    }

    static void main(String[] args, Class type) throws FactoryException {
        Arguments arguments = new Arguments(args);
        Locale.setDefault(arguments.locale);
        boolean duplicated = arguments.getFlag("-duplicated");
        boolean instantiate = arguments.getFlag("-test");
        args = arguments.getRemainingArguments(0);
        FactoryUsingWKT factory = (FactoryUsingWKT)FactoryUsingWKT.getFactory(type);
        if (duplicated) {
            factory.reportDuplicatedCodes(arguments.out);
        }
        if (instantiate) {
            factory.reportInstantiationFailures(arguments.out);
        }
        factory.dispose();
    }
}

