/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.ManyAuthoritiesFactory;
import org.geotools.referencing.factory.ThreadedAuthorityFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class DefaultAuthorityFactory
extends ThreadedAuthorityFactory
implements CRSAuthorityFactory {
    DefaultAuthorityFactory(Hints hints) {
        super(new ManyAuthoritiesFactory(hints, ReferencingFactoryFinder.getCRSAuthorityFactories(hints)));
    }

    static Set getSupportedCodes(String authority) {
        LinkedHashSet result = Collections.EMPTY_SET;
        boolean isSetCopied = false;
        for (CRSAuthorityFactory factory : ReferencingFactoryFinder.getCRSAuthorityFactories(null)) {
            Set codes;
            if (!Citations.identifierMatches(factory.getAuthority(), authority)) continue;
            try {
                codes = factory.getAuthorityCodes(CoordinateReferenceSystem.class);
            }
            catch (Exception exception) {
                CRS.unexpectedException("getSupportedCodes", exception);
                continue;
            }
            if (codes == null || codes.isEmpty()) continue;
            if (result.isEmpty()) {
                result = codes;
                continue;
            }
            if (!isSetCopied) {
                result = new LinkedHashSet(result);
                isSetCopied = true;
            }
            result.addAll(codes);
        }
        return result;
    }

    static Set getSupportedAuthorities(boolean returnAliases) {
        Set authorityFactories = ReferencingFactoryFinder.getCRSAuthorityFactories(null);
        LinkedHashSet result = new LinkedHashSet();
        block0: for (CRSAuthorityFactory factory : authorityFactories) {
            Collection identifiers = factory.getAuthority().getIdentifiers();
            Iterator j = identifiers.iterator();
            while (j.hasNext()) {
                result.add(j.next());
                if (returnAliases) continue;
                continue block0;
            }
        }
        return result;
    }
}

