/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import javax.media.jai.util.Range;
import javax.units.ConversionException;
import javax.units.Converter;
import javax.units.Unit;
import org.geotools.resources.ClassChanger;
import org.geotools.resources.Utilities;
import org.geotools.util.NumberRange;

public class MeasurementRange
extends NumberRange {
    private static final long serialVersionUID = 3980319420337513745L;
    private final Unit units;

    public MeasurementRange(float minimum, float maximum, Unit units) {
        super(minimum, maximum);
        this.units = units;
    }

    public MeasurementRange(float minimum, boolean isMinIncluded, float maximum, boolean isMaxIncluded, Unit units) {
        super(minimum, isMinIncluded, maximum, isMaxIncluded);
        this.units = units;
    }

    public MeasurementRange(double minimum, double maximum, Unit units) {
        super(minimum, maximum);
        this.units = units;
    }

    public MeasurementRange(double minimum, boolean isMinIncluded, double maximum, boolean isMaxIncluded, Unit units) {
        super(minimum, isMinIncluded, maximum, isMaxIncluded);
        this.units = units;
    }

    public MeasurementRange(Class type, Number minimum, boolean isMinIncluded, Number maximum, boolean isMaxIncluded, Unit units) {
        super(type, minimum, isMinIncluded, maximum, isMaxIncluded);
        this.units = units;
    }

    public MeasurementRange(Range range, Unit units) throws ClassCastException {
        super(range);
        this.units = units;
    }

    private MeasurementRange(Class type, Range range, Unit units) throws ClassCastException {
        super(type, range);
        this.units = units;
    }

    public final Unit getUnits() {
        return this.units;
    }

    public MeasurementRange convertTo(Unit targetUnits) throws ConversionException {
        return this.convertAndCast(this.getElementClass(), targetUnits);
    }

    NumberRange convertAndCast(Range range, Class type) {
        if (range instanceof MeasurementRange) {
            return ((MeasurementRange)range).convertAndCast(type, this.units);
        }
        return super.convertAndCast(range, type);
    }

    private MeasurementRange convertAndCast(Class type, Unit targetUnits) throws ConversionException {
        Double maximum;
        if (targetUnits == null || targetUnits.equals(this.units)) {
            if (type.equals(this.getElementClass())) {
                return this;
            }
            return new MeasurementRange(type, this, this.units);
        }
        if (this.units == null) {
            return new MeasurementRange(type, this, targetUnits);
        }
        Converter converter = this.units.getConverterTo(targetUnits);
        if (converter.equals(Converter.IDENTITY)) {
            return new MeasurementRange(type, this, targetUnits);
        }
        boolean isMinIncluded = this.isMinIncluded();
        boolean isMaxIncluded = this.isMaxIncluded();
        Double minimum = new Double(converter.convert(this.getMinimum()));
        if (minimum.compareTo(maximum = new Double(converter.convert(this.getMaximum()))) > 0) {
            Double td = minimum;
            minimum = maximum;
            maximum = td;
            boolean tb = isMinIncluded;
            isMinIncluded = isMaxIncluded;
            isMaxIncluded = tb;
        }
        return new MeasurementRange(type, ClassChanger.cast(minimum, type), isMinIncluded, ClassChanger.cast(maximum, type), isMaxIncluded, targetUnits);
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            if (other instanceof MeasurementRange) {
                MeasurementRange that = (MeasurementRange)((Object)other);
                return Utilities.equals(this.units, that.units);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String range = super.toString();
        if (this.units != null) {
            range = range + ' ' + this.units;
        }
        return range;
    }
}

