/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.street;

import com.gisgraphy.domain.valueobject.StreetSearchResultsDto;
import com.gisgraphy.rest.IRestClient;
import com.gisgraphy.rest.RestClient;
import com.gisgraphy.serializer.common.OutputFormat;
import com.gisgraphy.service.ServiceException;
import com.gisgraphy.street.IStreetSearchEngine;
import com.gisgraphy.street.StreetSearchQuery;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class StreetSearchClient
implements IStreetSearchEngine {
    private String baseUrl;
    IRestClient restClient = new RestClient();

    public StreetSearchClient(String baseUrl) {
        if (baseUrl == null || "".equals(baseUrl.trim())) {
            throw new IllegalArgumentException("street base URL is empty or null");
        }
        try {
            new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("street should be correct");
        }
        this.baseUrl = baseUrl;
    }

    public void executeAndSerialize(StreetSearchQuery query, OutputStream outputStream) throws ServiceException {
        if (query == null) {
            throw new IllegalArgumentException("can not execute a null query");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("can not serialize to a null outputStream");
        }
        String queryString = this.streetsearchQuerytoQueryString(query);
        this.restClient.get(this.baseUrl + queryString, outputStream, query.getOutputFormat());
    }

    public String executeQueryToString(StreetSearchQuery query) throws ServiceException {
        if (query == null) {
            throw new IllegalArgumentException("can not geocode a null query");
        }
        String queryString = this.streetsearchQuerytoQueryString(query);
        return this.restClient.get(this.baseUrl + queryString, String.class, query.getOutputFormat());
    }

    public StreetSearchResultsDto executeQuery(StreetSearchQuery query) throws ServiceException {
        if (query == null) {
            throw new IllegalArgumentException("can not geocode a null query");
        }
        query.withCallback(null);
        String queryString = this.streetsearchQuerytoQueryString(query);
        return this.restClient.get(this.baseUrl + queryString, StreetSearchResultsDto.class, OutputFormat.JSON);
    }

    protected String streetsearchQuerytoQueryString(StreetSearchQuery query) {
        StringBuffer sb = new StringBuffer("?");
        this.addParameter(sb, "lat", query.getLatitude());
        this.addParameter(sb, "lng", query.getLongitude());
        this.addParameter(sb, "radius", query.getRadius());
        this.addParameter(sb, "from", query.getFirstPaginationIndex());
        this.addParameter(sb, "to", query.getLastPaginationIndex());
        this.addParameter(sb, "callback", query.getCallback());
        this.addParameter(sb, "format", query.getOutputFormat());
        if (query.getPlaceType() != null) {
            this.addParameter(sb, "placetype", query.getPlaceType().getSimpleName());
        }
        this.addParameter(sb, "distance", query.hasDistanceField());
        this.addParameter(sb, "indent", query.isOutputIndented());
        this.addParameter(sb, "apikey", query.getApikey());
        this.addParameter(sb, "streettype", query.getStreetType());
        this.addParameter(sb, "name", query.getName());
        this.addParameter(sb, "oneway", query.getOneWay());
        return sb.toString();
    }

    private void addParameter(StringBuffer sb, String httpParameterName, Object parameterValue) {
        if (parameterValue != null) {
            sb.append(httpParameterName).append("=").append(parameterValue.toString()).append("&");
        }
    }

    public void setRestClient(IRestClient restClient) {
        this.restClient = restClient;
    }
}

