/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.servlet;

import com.gisgraphy.domain.valueobject.GisgraphyServiceType;
import com.gisgraphy.helper.EncodingHelper;
import com.gisgraphy.helper.OutputFormatHelper;
import com.gisgraphy.serializer.common.IoutputFormatVisitor;
import com.gisgraphy.serializer.common.OutputFormat;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GisgraphyServlet
extends HttpServlet {
    public static final String DEBUG_MODE_PARAMETER_NAME = "debugMode";
    protected boolean debugMode = false;
    public static final String INDENT_PARAMETER = "indent";
    public static final String TO_PARAMETER = "to";
    public static final String FROM_PARAMETER = "from";
    public static final String FORMAT_PARAMETER = "format";
    public static final String APIKEY_PARAMETER = "apikey";
    private static final long serialVersionUID = -90545482454895743L;
    protected static final Logger logger = LoggerFactory.getLogger(GisgraphyServlet.class);

    public void init() throws ServletException {
        super.init();
        this.debugMode = Boolean.valueOf(this.getInitParameter(DEBUG_MODE_PARAMETER_NAME));
        logger.info(((Object)((Object)this)).getClass().getSimpleName() + " debugmode = " + this.debugMode);
        EncodingHelper.setJVMEncodingToUTF8();
    }

    public abstract GisgraphyServiceType getGisgraphyServiceType();

    public abstract IoutputFormatVisitor getErrorVisitor(String var1);

    protected OutputFormat setResponseContentType(HttpServletRequest req, HttpServletResponse resp) {
        String formatParam = req.getParameter(FORMAT_PARAMETER);
        OutputFormat format = OutputFormat.getFromString((String)formatParam);
        format = OutputFormatHelper.getDefaultForServiceIfNotSupported(format, this.getGisgraphyServiceType());
        resp.setHeader("content-type", format.getContentType());
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCustomError(String errorMessage, OutputFormat format, HttpServletResponse resp, HttpServletRequest req) {
        IoutputFormatVisitor visitor = this.getErrorVisitor(errorMessage);
        String response = format.accept(visitor);
        Writer writer = null;
        try {
            if (!resp.isCommitted()) {
                resp.reset();
                resp.setStatus(500);
                this.setResponseContentType(req, resp);
                writer = resp.getWriter();
                if (writer != null) {
                    writer.append(response);
                    writer.flush();
                }
            }
        }
        catch (IOException e) {
            logger.warn("error when sending error : " + e.getMessage());
        }
        catch (IllegalStateException e) {
            logger.warn("Can not send error because the response has already been send : " + e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.warn("Error when closing writer after sending error : " + e.getMessage());
                }
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }
}

