/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.helper;

import com.gisgraphy.domain.valueobject.GisgraphyServiceType;
import com.gisgraphy.serializer.common.OutputFormat;
import com.gisgraphy.serializer.exception.UnsupportedFormatException;

public class OutputFormatHelper {
    private static final OutputFormat[] FULLTEXTSEARCH_SUPPORTED_FORMAT = new OutputFormat[]{OutputFormat.XML, OutputFormat.JSON, OutputFormat.ATOM, OutputFormat.GEORSS, OutputFormat.PHP, OutputFormat.PYTHON, OutputFormat.RUBY};
    private static final OutputFormat[] GEOLOCSEARCH_SUPPORTED_FORMAT = new OutputFormat[]{OutputFormat.XML, OutputFormat.JSON, OutputFormat.ATOM, OutputFormat.GEORSS, OutputFormat.PHP, OutputFormat.RUBY, OutputFormat.PYTHON, OutputFormat.YAML};
    private static final OutputFormat[] STREETSEARCH_SUPPORTED_FORMAT = new OutputFormat[]{OutputFormat.XML, OutputFormat.JSON, OutputFormat.ATOM, OutputFormat.GEORSS, OutputFormat.PHP, OutputFormat.RUBY, OutputFormat.PYTHON, OutputFormat.YAML};
    private static final OutputFormat[] ADDRESS_PARSER_SUPPORTED_FORMAT = new OutputFormat[]{OutputFormat.XML, OutputFormat.JSON, OutputFormat.PHP, OutputFormat.RUBY, OutputFormat.PYTHON, OutputFormat.YAML};
    private static final OutputFormat[] REVERSEGEOCODING_SUPPORTED_FORMAT = ADDRESS_PARSER_SUPPORTED_FORMAT;
    private static final OutputFormat[] GEOCODING_SUPPORTED_FORMAT = new OutputFormat[]{OutputFormat.XML, OutputFormat.JSON, OutputFormat.PHP, OutputFormat.RUBY, OutputFormat.PYTHON, OutputFormat.YAML};

    public static OutputFormat[] listFormatByService(GisgraphyServiceType serviceType) {
        switch (serviceType) {
            case FULLTEXT: {
                return FULLTEXTSEARCH_SUPPORTED_FORMAT;
            }
            case GEOLOC: {
                return GEOLOCSEARCH_SUPPORTED_FORMAT;
            }
            case STREET: {
                return STREETSEARCH_SUPPORTED_FORMAT;
            }
            case ADDRESS_PARSER: {
                return ADDRESS_PARSER_SUPPORTED_FORMAT;
            }
            case GEOCODING: {
                return GEOCODING_SUPPORTED_FORMAT;
            }
            case REVERSEGEOCODING: {
                return REVERSEGEOCODING_SUPPORTED_FORMAT;
            }
        }
        throw new RuntimeException("The service type " + serviceType + " is not implemented");
    }

    public static OutputFormat getDefaultForServiceIfNotSupported(OutputFormat format, GisgraphyServiceType serviceType) {
        switch (serviceType) {
            case FULLTEXT: {
                return OutputFormatHelper.isFormatSupported(format, serviceType) ? format : OutputFormat.getDefault();
            }
            case GEOLOC: {
                return OutputFormatHelper.isFormatSupported(format, serviceType) ? format : OutputFormat.getDefault();
            }
            case STREET: {
                return OutputFormatHelper.isFormatSupported(format, serviceType) ? format : OutputFormat.getDefault();
            }
            case ADDRESS_PARSER: {
                return OutputFormatHelper.isFormatSupported(format, serviceType) ? format : OutputFormat.getDefault();
            }
            case GEOCODING: {
                return OutputFormatHelper.isFormatSupported(format, serviceType) ? format : OutputFormat.getDefault();
            }
            case REVERSEGEOCODING: {
                return OutputFormatHelper.isFormatSupported(format, serviceType) ? format : OutputFormat.getDefault();
            }
        }
        throw new UnsupportedFormatException("The service type " + serviceType + " is not implemented");
    }

    public static boolean isFormatSupported(OutputFormat outputFormat, GisgraphyServiceType serviceType) {
        for (OutputFormat format : OutputFormatHelper.listFormatByService(serviceType)) {
            if (format != outputFormat) continue;
            return true;
        }
        return false;
    }
}

