/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.helper;

import com.gisgraphy.helper.IntrospectionIgnoredField;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectionHelper {
    protected static final Logger logger = LoggerFactory.getLogger(IntrospectionHelper.class);
    private static Map<Class<?>, String[]> cacheArray = new HashMap();
    private static Map<Class<?>, List<String>> cacheList = new HashMap();

    public static void clearCache() {
        cacheArray.clear();
        cacheList.clear();
    }

    public static List<String> getFieldsAsList(Class<?> clazz) {
        List<String> cached = cacheList.get(clazz);
        if (cached == null) {
            IntrospectionHelper.updateCache(clazz);
            return cacheList.get(clazz);
        }
        return cached;
    }

    public static String[] getFieldsAsArray(Class<?> clazz) {
        String[] cached = cacheArray.get(clazz);
        if (cached == null) {
            IntrospectionHelper.updateCache(clazz);
            return cacheArray.get(clazz);
        }
        return cached;
    }

    private static void updateCache(Class<?> clazz) {
        Class<?> clazzParent = clazz;
        ArrayList<String> introspectedFields = new ArrayList<String>();
        try {
            do {
                Field[] flds;
                int searchMods = 0;
                searchMods |= IntrospectionHelper.modifierFromString("private");
                for (Field f : flds = clazzParent.getDeclaredFields()) {
                    int foundMods = f.getModifiers();
                    if ((foundMods & searchMods) != searchMods || f.isSynthetic() || f.getType() == List.class || f.getType() == Set.class || f.getType() == SortedSet.class || IntrospectionHelper.isIgnoreField(f) || Modifier.isFinal(foundMods)) continue;
                    introspectedFields.add(f.getName());
                }
            } while ((clazzParent = clazzParent.getSuperclass()) != Object.class);
        }
        catch (RuntimeException x) {
            logger.error("can not update introspection cache :" + x.getMessage(), (Throwable)x);
        }
        cacheList.put(clazz, introspectedFields);
        cacheArray.put(clazz, introspectedFields.toArray(new String[0]));
    }

    private static boolean isIgnoreField(Field field) {
        for (int i = 0; i < field.getDeclaredAnnotations().length; ++i) {
            if (!(field.getDeclaredAnnotations()[i] instanceof IntrospectionIgnoredField)) continue;
            return true;
        }
        return false;
    }

    private static int modifierFromString(String s) {
        int m = 0;
        if ("public".equals(s)) {
            m |= 1;
        } else if ("protected".equals(s)) {
            m |= 4;
        } else if ("private".equals(s)) {
            m |= 2;
        } else if ("static".equals(s)) {
            m |= 8;
        } else if ("final".equals(s)) {
            m |= 0x10;
        } else if ("transient".equals(s)) {
            m |= 0x80;
        } else if ("volatile".equals(s)) {
            m |= 0x40;
        }
        return m;
    }
}

