/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.dwrp.Batch;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.Marshaller;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.util.DebuggingPrintWriter;
import org.directwebremoting.util.Logger;
import org.directwebremoting.util.Messages;

public abstract class BaseCallMarshaller
implements Marshaller {
    protected String sessionCookieName = "JSESSIONID";
    private boolean allowGetForSafariButMakeForgeryEasier = false;
    protected boolean crossDomainSessionSecurity = true;
    protected PageNormalizer pageNormalizer = null;
    protected ConverterManager converterManager = null;
    protected CreatorManager creatorManager = null;
    protected AccessControl accessControl = null;
    protected static final String ATTRIBUTE_REQUEST = "org.directwebremoting.dwrp.request";
    protected static final String ATTRIBUTE_CONDUIT = "org.directwebremoting.dwrp.conduit";
    protected static final String ATTRIBUTE_BATCH = "org.directwebremoting.dwrp.batch";
    protected static final Logger log = Logger.getLogger(class$org$directwebremoting$dwrp$BaseCallMarshaller == null ? (class$org$directwebremoting$dwrp$BaseCallMarshaller = BaseCallMarshaller.class$("org.directwebremoting.dwrp.BaseCallMarshaller")) : class$org$directwebremoting$dwrp$BaseCallMarshaller);
    static /* synthetic */ Class class$org$directwebremoting$dwrp$BaseCallMarshaller;

    public Calls marshallInbound(HttpServletRequest request, HttpServletResponse response) throws IOException, ServerException {
        WebContext webContext = WebContextFactory.get();
        Batch batch = (Batch)request.getAttribute(ATTRIBUTE_BATCH);
        if (batch == null) {
            batch = new Batch(request, this.crossDomainSessionSecurity, this.allowGetForSafariButMakeForgeryEasier, this.sessionCookieName);
            request.setAttribute(ATTRIBUTE_BATCH, (Object)batch);
        }
        this.storeParsedRequest(request, webContext, batch);
        Calls calls = batch.getCalls();
        if (log.isDebugEnabled() && calls.getCallCount() > 0) {
            InboundContext inctx = (InboundContext)batch.getInboundContexts().get(0);
            StringBuffer buffer = new StringBuffer();
            Iterator it = inctx.getInboundVariableNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                InboundVariable value = inctx.getInboundVariable(key);
                if (!key.startsWith("c") || key.indexOf("-e") == -1) continue;
                buffer.append(key);
                buffer.append('=');
                buffer.append(value.toString());
                buffer.append(", ");
            }
            if (buffer.length() > 0) {
                log.debug("Environment:  " + buffer.toString());
            }
        }
        block3: for (int callNum = 0; callNum < calls.getCallCount(); ++callNum) {
            Call call = calls.getCall(callNum);
            InboundContext inctx = (InboundContext)batch.getInboundContexts().get(callNum);
            Creator creator = this.creatorManager.getCreator(call.getScriptName());
            Method method = this.findMethod(call, inctx);
            if (method == null) {
                String name = call.getScriptName() + '.' + call.getMethodName();
                String error = Messages.getString("BaseCallMarshaller.UnknownMethod", name);
                log.warn("Marshalling exception: " + error);
                call.setMethod(null);
                call.setParameters(null);
                call.setException(new IllegalArgumentException(error));
                continue;
            }
            call.setMethod(method);
            this.accessControl.assertExecutionIsPossible(creator, call.getScriptName(), method);
            Object[] params = new Object[method.getParameterTypes().length];
            for (int j = 0; j < method.getParameterTypes().length; ++j) {
                try {
                    Class<?> paramType = method.getParameterTypes()[j];
                    InboundVariable param = inctx.getParameter(callNum, j);
                    TypeHintContext incc = new TypeHintContext(this.converterManager, method, j);
                    params[j] = this.converterManager.convertInbound(paramType, param, inctx, incc);
                    continue;
                }
                catch (MarshallException ex) {
                    log.warn("Marshalling exception", ex);
                    call.setMethod(null);
                    call.setParameters(null);
                    call.setException(ex);
                    continue block3;
                }
            }
            call.setParameters(params);
        }
        return calls;
    }

    private void storeParsedRequest(HttpServletRequest request, WebContext webContext, Batch batch) {
        String normalizedPage = this.pageNormalizer.normalizePage(batch.getPage());
        webContext.setCurrentPageInformation(normalizedPage, batch.getScriptSessionId());
        Map paramMap = batch.getSpareParameters();
        if (paramMap.size() != 0) {
            Iterator it = paramMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                request.setAttribute(key, (Object)value);
                log.debug("Moved param to request: " + key + "=" + value);
            }
        }
    }

    private Method findMethod(Call call, InboundContext inctx) {
        if (call.getScriptName() == null) {
            throw new IllegalArgumentException(Messages.getString("BaseCallMarshaller.MissingClassParam"));
        }
        if (call.getMethodName() == null) {
            throw new IllegalArgumentException(Messages.getString("BaseCallMarshaller.MissingMethodParam"));
        }
        Creator creator = this.creatorManager.getCreator(call.getScriptName());
        Method[] methods = creator.getType().getMethods();
        ArrayList<Method> available = new ArrayList<Method>();
        block0: for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(call.getMethodName()) || methods[i].getParameterTypes().length != inctx.getParameterCount()) continue;
            inctx.clearConverted();
            for (int j = 0; j < methods[i].getParameterTypes().length; ++j) {
                Class<?> paramType = methods[i].getParameterTypes()[j];
                if (!this.converterManager.isConvertable(paramType)) continue block0;
            }
            available.add(methods[i]);
        }
        if (available.size() > 1) {
            log.warn("Warning multiple matching methods. Using first match.");
        }
        if (available.isEmpty()) {
            return null;
        }
        return (Method)available.get(0);
    }

    public void marshallOutbound(Replies replies, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(this.getOutboundMimeType());
        PrintWriter out = log.isDebugEnabled() ? new DebuggingPrintWriter("", response.getWriter()) : response.getWriter();
        CallScriptConduit conduit = new CallScriptConduit(out);
        if (out instanceof DebuggingPrintWriter) {
            DebuggingPrintWriter dpw = (DebuggingPrintWriter)out;
            dpw.setPrefix("out(" + conduit.hashCode() + "): ");
        }
        this.sendOutboundScriptPrefix(out, replies.getBatchId());
        RealScriptSession scriptSession = (RealScriptSession)WebContextFactory.get().getScriptSession();
        out.println("//#DWR-INSERT");
        scriptSession.writeScripts(conduit);
        out.println("//#DWR-REPLY");
        String batchId = replies.getBatchId();
        for (int i = 0; i < replies.getReplyCount(); ++i) {
            Reply reply = replies.getReply(i);
            String callId = reply.getCallId();
            try {
                if (reply.getThrowable() != null) {
                    Throwable ex = reply.getThrowable();
                    EnginePrivate.remoteHandleException(conduit, batchId, callId, ex);
                    log.warn("--Erroring: batchId[" + batchId + "] message[" + ex.toString() + ']');
                    continue;
                }
                Object data = reply.getReply();
                EnginePrivate.remoteHandleCallback(conduit, batchId, callId, data);
                continue;
            }
            catch (IOException ex) {
                log.error("--Output Error: batchId[" + batchId + "] message[" + ex.toString() + ']', ex);
                continue;
            }
            catch (MarshallException ex) {
                EnginePrivate.remoteHandleMarshallException(conduit, batchId, callId, ex);
                log.warn("--MarshallException: batchId=" + batchId + " class=" + ex.getConversionType().getName(), ex);
                continue;
            }
            catch (Exception ex) {
                EnginePrivate.remoteHandleException(conduit, batchId, callId, ex);
                log.error("--MarshallException: batchId=" + batchId + " message=" + ex.toString());
            }
        }
        this.sendOutboundScriptSuffix(out, replies.getBatchId());
    }

    public void marshallException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        response.setContentType(this.getOutboundMimeType());
        PrintWriter out = response.getWriter();
        Batch batch = (Batch)request.getAttribute(ATTRIBUTE_BATCH);
        String batchId = batch != null && batch.getCalls() != null ? batch.getCalls().getBatchId() : null;
        this.sendOutboundScriptPrefix(out, batchId);
        String script = EnginePrivate.getRemoteHandleBatchExceptionScript(batchId, ex);
        out.print(script);
        this.sendOutboundScriptSuffix(out, batchId);
    }

    protected abstract void sendScript(PrintWriter var1, String var2) throws IOException;

    protected abstract String getOutboundMimeType();

    protected abstract void sendOutboundScriptPrefix(PrintWriter var1, String var2) throws IOException;

    protected abstract void sendOutboundScriptSuffix(PrintWriter var1, String var2) throws IOException;

    public boolean isConvertable(Class paramType) {
        return this.converterManager.isConvertable(paramType);
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setCrossDomainSessionSecurity(boolean crossDomainSessionSecurity) {
        this.crossDomainSessionSecurity = crossDomainSessionSecurity;
    }

    public void setAllowGetForSafariButMakeForgeryEasier(boolean allowGetForSafariButMakeForgeryEasier) {
        this.allowGetForSafariButMakeForgeryEasier = allowGetForSafariButMakeForgeryEasier;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class CallScriptConduit
    extends ScriptConduit {
        private final PrintWriter out;

        protected CallScriptConduit(PrintWriter out) {
            super(1);
            if (out == null) {
                throw new NullPointerException("out=null");
            }
            this.out = out;
        }

        public boolean addScript(ScriptBuffer script) throws IOException, MarshallException {
            BaseCallMarshaller.this.sendScript(this.out, ScriptBufferUtil.createOutput(script, BaseCallMarshaller.this.converterManager));
            return true;
        }
    }
}

