/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.WriterOutputStream;
import org.mortbay.io.nio.NIOBuffer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpContent;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.InclusiveByteRange;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.ResourceCache;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.nio.NIOConnector;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.resource.ResourceFactory;
import org.mortbay.util.IO;
import org.mortbay.util.MultiPartOutputStream;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URIUtil;

public class DefaultServlet
extends HttpServlet
implements ResourceFactory {
    private static ByteArrayBuffer BYTE_RANGES = new ByteArrayBuffer("bytes");
    private ContextHandler.SContext _context;
    private boolean _acceptRanges = true;
    private boolean _dirAllowed = true;
    private boolean _redirectWelcome = false;
    private boolean _gzip = true;
    private Resource _resourceBase;
    private ResourceCache _cache;
    private MimeTypes _mimeTypes;
    private String[] _welcomes;
    private boolean _aliases = false;
    private boolean _useFileMappedBuffer = false;
    ByteArrayBuffer _cacheControl;

    public void init() throws UnavailableException {
        String t;
        ServletContext config = this.getServletContext();
        this._context = (ContextHandler.SContext)config;
        this._mimeTypes = this._context.getContextHandler().getMimeTypes();
        this._welcomes = this._context.getContextHandler().getWelcomeFiles();
        if (this._welcomes == null) {
            this._welcomes = new String[]{"index.jsp", "index.html"};
        }
        this._acceptRanges = this.getInitBoolean("acceptRanges", this._acceptRanges);
        this._dirAllowed = this.getInitBoolean("dirAllowed", this._dirAllowed);
        this._redirectWelcome = this.getInitBoolean("redirectWelcome", this._redirectWelcome);
        this._gzip = this.getInitBoolean("gzip", this._gzip);
        this._aliases = this.getInitBoolean("aliases", this._aliases);
        this._useFileMappedBuffer = this.getInitBoolean("useFileMappedBuffer", this._useFileMappedBuffer);
        String rrb = this.getInitParameter("relativeResourceBase");
        if (rrb != null) {
            try {
                this._resourceBase = Resource.newResource(this._context.getResource("/")).addPath(rrb);
            }
            catch (Exception e) {
                Log.warn((String)"EXCEPTION ", (Throwable)e);
                throw new UnavailableException(e.toString());
            }
        }
        String rb = this.getInitParameter("resourceBase");
        if (rrb != null && rb != null) {
            throw new UnavailableException("resourceBase & relativeResourceBase");
        }
        if (rb != null) {
            try {
                this._resourceBase = Resource.newResource(rb);
            }
            catch (Exception e) {
                Log.warn((String)"EXCEPTION ", (Throwable)e);
                throw new UnavailableException(e.toString());
            }
        }
        if ((t = this.getInitParameter("cacheControl")) != null) {
            this._cacheControl = new ByteArrayBuffer(t);
        }
        try {
            int max_cache_size;
            if (this._resourceBase == null) {
                this._resourceBase = Resource.newResource(this._context.getResource("/"));
            }
            if ((max_cache_size = this.getInitInt("maxCacheSize", -2)) == -2 || max_cache_size > 0) {
                if (this._cache == null) {
                    this._cache = new NIOResourceCache(this._mimeTypes);
                }
                if (max_cache_size > 0) {
                    this._cache.setMaxCacheSize(max_cache_size);
                }
            } else {
                this._cache = null;
            }
            if (this._cache != null) {
                int max_cached_files;
                int max_cached_file_size = this.getInitInt("maxCachedFileSize", -2);
                if (max_cached_file_size >= -1) {
                    this._cache.setMaxCachedFileSize(max_cached_file_size);
                }
                if ((max_cached_files = this.getInitInt("maxCachedFiles", -2)) >= -1) {
                    this._cache.setMaxCachedFiles(max_cached_files);
                }
                this._cache.start();
            }
        }
        catch (Exception e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
            throw new UnavailableException(e.toString());
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("resource base = " + this._resourceBase));
        }
    }

    private boolean getInitBoolean(String name, boolean dft) {
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return dft;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    private int getInitInt(String name, int dft) {
        String value = this.getInitParameter(name);
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return dft;
    }

    public Resource getResource(String pathInContext) {
        if (this._resourceBase == null) {
            return null;
        }
        Resource r = null;
        try {
            r = this._resourceBase.addPath(pathInContext);
            if (!this._aliases && r.getAlias() != null) {
                if (r.exists()) {
                    Log.warn((String)("Aliased resource: " + r + "==" + r.getAlias()));
                }
                return null;
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("RESOURCE=" + r));
            }
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String accept;
        String servletPath = null;
        String pathInfo = null;
        Enumeration reqRanges = null;
        Boolean included = (Boolean)request.getAttribute("org.mortbay.jetty.included");
        if (included != null && included.booleanValue()) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            included = Boolean.FALSE;
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
            reqRanges = request.getHeaders("Range");
            if (reqRanges != null && !reqRanges.hasMoreElements()) {
                reqRanges = null;
            }
        }
        String pathInContext = URIUtil.addPaths((String)servletPath, (String)pathInfo);
        boolean endsWithSlash = pathInContext.endsWith("/");
        String pathInContextGz = null;
        boolean gzip = false;
        if (this._gzip && reqRanges == null && !endsWithSlash && (accept = request.getHeader("Accept-Encoding")) != null && accept.indexOf("gzip") >= 0) {
            gzip = true;
        }
        Resource resource = null;
        HttpContent content = null;
        try {
            if (gzip) {
                pathInContextGz = pathInContext + ".gz";
                resource = this._cache == null ? this.getResource(pathInContextGz) : ((content = this._cache.lookup(pathInContextGz, this)) != null ? content.getResource() : this.getResource(pathInContextGz));
                if (resource == null || !resource.exists() || resource.isDirectory()) {
                    gzip = false;
                    pathInContextGz = null;
                }
            }
            if (!gzip) {
                resource = this._cache == null ? this.getResource(pathInContext) : ((content = this._cache.lookup(pathInContext, this)) != null ? content.getResource() : this.getResource(pathInContext));
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("resource=" + resource + (content != null ? " content" : "")));
            }
            if (resource == null || !resource.exists()) {
                response.sendError(404);
            } else if (!resource.isDirectory()) {
                if (content == null) {
                    content = new UnCachedContent(resource);
                }
                if (included.booleanValue() || this.passConditionalHeaders(request, response, resource, content)) {
                    if (gzip) {
                        response.setHeader("Content-Encoding", "gzip");
                        String mt = this._context.getMimeType(pathInContext);
                        if (mt != null) {
                            response.setContentType(mt);
                        }
                    }
                    this.sendData(request, response, included, resource, content, reqRanges);
                }
            } else {
                String welcome = null;
                if (!endsWithSlash || pathInContext.length() == 1 && request.getAttribute("org.mortbay.jetty.nullPathInfo") != null) {
                    StringBuffer buf = request.getRequestURL();
                    int param = buf.lastIndexOf(";");
                    if (param < 0) {
                        buf.append('/');
                    } else {
                        buf.insert(param, '/');
                    }
                    String q = request.getQueryString();
                    if (q != null && q.length() != 0) {
                        buf.append('?');
                        buf.append(q);
                    }
                    response.setContentLength(0);
                    response.sendRedirect(response.encodeRedirectURL(buf.toString()));
                } else {
                    welcome = this.getWelcomeFile(resource);
                    if (null != welcome) {
                        String ipath = URIUtil.addPaths((String)pathInContext, (String)welcome);
                        if (this._redirectWelcome) {
                            response.setContentLength(0);
                            String q = request.getQueryString();
                            if (q != null && q.length() != 0) {
                                response.sendRedirect(URIUtil.addPaths((String)this._context.getContextPath(), (String)ipath) + "?" + q);
                            } else {
                                response.sendRedirect(URIUtil.addPaths((String)this._context.getContextPath(), (String)ipath));
                            }
                        } else {
                            RequestDispatcher dispatcher = request.getRequestDispatcher(ipath);
                            if (dispatcher != null) {
                                if (included.booleanValue()) {
                                    dispatcher.include((ServletRequest)request, (ServletResponse)response);
                                } else {
                                    request.setAttribute("org.mortbay.jetty.welcome", (Object)ipath);
                                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                                }
                            }
                        }
                    } else {
                        content = new UnCachedContent(resource);
                        if (included.booleanValue() || this.passConditionalHeaders(request, response, resource, content)) {
                            this.sendDirectory(request, response, resource, pathInContext.length() > 1);
                        }
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
        }
        finally {
            if (content != null) {
                content.release();
            } else if (resource != null) {
                resource.release();
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private String getWelcomeFile(Resource resource) throws MalformedURLException, IOException {
        if (!resource.isDirectory() || this._welcomes == null) {
            return null;
        }
        for (int i = 0; i < this._welcomes.length; ++i) {
            Resource welcome = resource.addPath(this._welcomes[i]);
            if (!welcome.exists()) continue;
            return this._welcomes[i];
        }
        return null;
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource, HttpContent content) throws IOException {
        if (!request.getMethod().equals("HEAD")) {
            long date;
            String ifms = request.getHeader("If-Modified-Since");
            if (ifms != null) {
                Buffer mdlm;
                if (content != null && (mdlm = content.getLastModified()) != null && ifms.equals(mdlm.toString())) {
                    response.reset();
                    response.setStatus(304);
                    response.flushBuffer();
                    return false;
                }
                long ifmsl = request.getDateHeader("If-Modified-Since");
                if (ifmsl != -1L && resource.lastModified() / 1000L <= ifmsl / 1000L) {
                    response.reset();
                    response.setStatus(304);
                    response.flushBuffer();
                    return false;
                }
            }
            if ((date = request.getDateHeader("If-Unmodified-Since")) != -1L && resource.lastModified() / 1000L > date / 1000L) {
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, boolean parent) throws IOException {
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        byte[] data = null;
        String base = URIUtil.addPaths((String)request.getRequestURI(), (String)"/");
        String dir = resource.getListHTML(base, parent);
        if (dir == null) {
            response.sendError(403, "No directory");
            return;
        }
        data = dir.getBytes("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }

    protected void sendData(HttpServletRequest request, HttpServletResponse response, boolean include, Resource resource, HttpContent content, Enumeration reqRanges) throws IOException {
        long content_length = resource.length();
        Object out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        if (reqRanges == null || !reqRanges.hasMoreElements()) {
            if (include) {
                resource.writeTo((OutputStream)out, 0L, content_length);
            } else if (out instanceof HttpConnection.Output) {
                if (this._cacheControl != null) {
                    if (response instanceof Response) {
                        ((Response)response).getHttpFields().put(HttpHeaders.CACHE_CONTROL_BUFFER, this._cacheControl);
                    } else {
                        response.setHeader("Cache-Control", this._cacheControl.toString());
                    }
                }
                ((HttpConnection.Output)((Object)out)).sendContent(content);
            } else {
                this.writeHeaders(response, content, content_length);
                resource.writeTo((OutputStream)out, 0L, content_length);
            }
        } else {
            List ranges = InclusiveByteRange.satisfiableRanges(reqRanges, content_length);
            if (ranges == null || ranges.size() == 0) {
                this.writeHeaders(response, content, content_length);
                response.setStatus(416);
                response.setHeader("Content-Range", InclusiveByteRange.to416HeaderRangeString(content_length));
                resource.writeTo((OutputStream)out, 0L, content_length);
                return;
            }
            if (ranges.size() == 1) {
                InclusiveByteRange singleSatisfiableRange = (InclusiveByteRange)ranges.get(0);
                long singleLength = singleSatisfiableRange.getSize(content_length);
                this.writeHeaders(response, content, singleLength);
                response.setStatus(206);
                response.setHeader("Content-Range", singleSatisfiableRange.toHeaderRangeString(content_length));
                resource.writeTo((OutputStream)out, singleSatisfiableRange.getFirst(content_length), singleLength);
                return;
            }
            this.writeHeaders(response, content, -1L);
            String mimetype = content.getContentType().toString();
            MultiPartOutputStream multi = new MultiPartOutputStream((OutputStream)out);
            response.setStatus(206);
            String ctp = request.getHeader("Request-Range") != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
            response.setContentType(ctp + multi.getBoundary());
            InputStream in = resource.getInputStream();
            long pos = 0L;
            for (int i = 0; i < ranges.size(); ++i) {
                InclusiveByteRange ibr = (InclusiveByteRange)ranges.get(i);
                String header = "Content-Range: " + ibr.toHeaderRangeString(content_length);
                multi.startPart(mimetype, new String[]{header});
                long start = ibr.getFirst(content_length);
                long size = ibr.getSize(content_length);
                if (in != null) {
                    if (start < pos) {
                        in.close();
                        in = resource.getInputStream();
                        pos = 0L;
                    }
                    if (pos < start) {
                        in.skip(start - pos);
                        pos = start;
                    }
                    IO.copy((InputStream)in, (OutputStream)multi, (long)size);
                    pos += size;
                    continue;
                }
                resource.writeTo((OutputStream)multi, start, size);
            }
            if (in != null) {
                in.close();
            }
            multi.close();
        }
    }

    protected void writeHeaders(HttpServletResponse response, HttpContent content, long count) throws IOException {
        if (content.getContentType() != null) {
            response.setContentType(content.getContentType().toString());
        }
        if (response instanceof Response) {
            long lml;
            Response r = (Response)response;
            HttpFields fields = r.getHttpFields();
            if (content.getLastModified() != null) {
                fields.put(HttpHeaders.LAST_MODIFIED_BUFFER, content.getLastModified());
            } else if (content.getResource() != null && (lml = content.getResource().lastModified()) != -1L) {
                fields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, lml);
            }
            if (count != -1L) {
                r.setLongContentLength(count);
            }
            if (this._acceptRanges) {
                fields.put(HttpHeaders.ACCEPT_RANGES_BUFFER, BYTE_RANGES);
            }
            if (this._cacheControl != null) {
                fields.put(HttpHeaders.CACHE_CONTROL_BUFFER, this._cacheControl);
            }
        } else {
            if (content.getLastModified() != null) {
                response.setHeader("Last-Modified", content.getLastModified().toString());
            } else {
                response.setDateHeader("Last-Modified", content.getResource().lastModified());
            }
            if (count != -1L) {
                if (count < Integer.MAX_VALUE) {
                    response.setContentLength((int)count);
                } else {
                    response.setHeader("Content-Length", TypeUtil.toString((long)count));
                }
            }
            if (this._acceptRanges) {
                response.setHeader("Accept-Ranges", "bytes");
            }
            if (this._cacheControl != null) {
                response.setHeader("Cache-Control", this._cacheControl.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            if (this._cache != null) {
                this._cache.stop();
            }
        }
        catch (Exception e) {
            Log.warn((String)"EXCEPTION ", (Throwable)e);
        }
        finally {
            super.destroy();
        }
    }

    class NIOResourceCache
    extends ResourceCache {
        public NIOResourceCache(MimeTypes mimeTypes) {
            super(mimeTypes);
        }

        protected void fill(ResourceCache.Content content) throws IOException {
            Connector connector = HttpConnection.getCurrentConnection().getConnector();
            if (connector instanceof NIOConnector) {
                NIOBuffer buffer = null;
                Resource resource = content.getResource();
                long length = resource.length();
                if (DefaultServlet.this._useFileMappedBuffer && resource.getFile() != null) {
                    File file = resource.getFile();
                    if (file != null) {
                        buffer = new NIOBuffer(file);
                    }
                } else {
                    InputStream is = resource.getInputStream();
                    try {
                        buffer = new NIOBuffer((int)length, ((NIOConnector)((Object)connector)).getUseDirectBuffers());
                    }
                    catch (OutOfMemoryError e) {
                        Log.warn((String)e.toString());
                        Log.debug((Throwable)e);
                        buffer = new NIOBuffer((int)length, false);
                    }
                    buffer.readFrom(is, (int)length);
                    is.close();
                }
                content.setBuffer(buffer);
            } else {
                super.fill(content);
            }
        }
    }

    private class UnCachedContent
    implements HttpContent {
        Resource _resource;

        UnCachedContent(Resource resource) {
            this._resource = resource;
        }

        public Buffer getContentType() {
            return DefaultServlet.this._mimeTypes.getMimeByExtension(this._resource.toString());
        }

        public Buffer getLastModified() {
            return null;
        }

        public Buffer getBuffer() {
            return null;
        }

        public long getContentLength() {
            return this._resource.length();
        }

        public InputStream getInputStream() throws IOException {
            return this._resource.getInputStream();
        }

        public Resource getResource() {
            return this._resource;
        }

        public void release() {
            this._resource.release();
            this._resource = null;
        }
    }
}

