/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.reversegeocoding;

import com.gisgraphy.domain.valueobject.Output;
import com.gisgraphy.serializer.common.OutputFormat;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ReverseGeocodingQuery {
    protected Point point;
    private String callback;
    private String apikey;
    protected Output output = Output.DEFAULT_OUTPUT;
    private static Pattern callbackValidationPattern = Pattern.compile("\\w+");
    private static Logger logger = Logger.getLogger(ReverseGeocodingQuery.class);
    public static final String LAT_PARAMETER = "lat";
    public static final String LONG_PARAMETER = "lng";
    public static final String CALLBACK_PARAMETER = "callback";

    public ReverseGeocodingQuery(Point point, Output output) {
        if (point == null) {
            throw new IllegalArgumentException("point(lat and long) must not be null");
        }
        this.withOutput(output);
        this.point = point;
    }

    public ReverseGeocodingQuery(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("point(lat and long) must not be null");
        }
        this.point = point;
    }

    protected ReverseGeocodingQuery() {
    }

    public Output getOutput() {
        return this.output;
    }

    public ReverseGeocodingQuery withOutput(Output output) {
        this.output = output == null ? Output.DEFAULT_OUTPUT : output;
        return this;
    }

    public ReverseGeocodingQuery withCallback(String callback) {
        if (callback != null && callbackValidationPattern.matcher(callback).matches()) {
            this.callback = callback;
        } else if (callback == null) {
            this.callback = null;
        } else {
            logger.warn((Object)("wrong callback specify : " + callback + ", callback method sould be alphanumeric"));
        }
        return this;
    }

    public Point getPoint() {
        return this.point;
    }

    public Double getLatitude() {
        Double latitude = null;
        if (this.point != null) {
            latitude = this.point.getY();
        }
        return latitude;
    }

    public Double getLongitude() {
        Double longitude = null;
        if (this.point != null) {
            longitude = this.point.getX();
        }
        return longitude;
    }

    public Output.OutputStyle getOutputStyle() {
        return this.output.getStyle();
    }

    public OutputFormat getOutputFormat() {
        return this.output.getFormat();
    }

    public String getOutputLanguage() {
        return this.output.getLanguageCode();
    }

    public boolean isOutputIndented() {
        return this.output.isIndented();
    }

    public String toString() {
        String asString = this.getClass().getSimpleName() + "around " + this.point + " with " + this.getOutput() + " and " + " and callback=" + this.callback;
        return asString;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getApikey() {
        return this.apikey;
    }

    public void setApikey(String apikey) {
        this.apikey = apikey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.callback == null ? 0 : this.callback.hashCode());
        result = 31 * result + (this.output == null ? 0 : this.output.hashCode());
        result = 31 * result + (this.point == null ? 0 : this.point.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReverseGeocodingQuery other = (ReverseGeocodingQuery)obj;
        if (this.callback == null ? other.callback != null : !this.callback.equals(other.callback)) {
            return false;
        }
        if (this.output == null ? other.output != null : !this.output.equals(other.output)) {
            return false;
        }
        return !(this.point == null ? other.point != null : !this.point.equals((Geometry)other.point));
    }
}

