/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.helper;

import com.gisgraphy.domain.valueobject.SRID;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTReader;
import java.text.NumberFormat;
import java.util.Locale;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeolocHelper {
    private static final double COS0 = Math.cos(0.0);
    private static final double SIN90 = Math.sin(90.0);
    private static final String INTERSECTION = "&&";
    private static final String BBOX = "BOX3D";
    protected static final Logger logger = LoggerFactory.getLogger(GeolocHelper.class);

    public static Point createPoint(Float longitude, Float latitude) {
        if (longitude.floatValue() < -180.0f || longitude.floatValue() > 180.0f) {
            throw new IllegalArgumentException("Longitude should be between -180 and 180");
        }
        if (latitude.floatValue() < -90.0f || latitude.floatValue() > 90.0f) {
            throw new IllegalArgumentException("latitude should be between -90 and 90");
        }
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), SRID.WGS84_SRID.getSRID());
        Point point = factory.createPoint(new Coordinate((double)longitude.floatValue(), (double)latitude.floatValue()));
        return point;
    }

    public static Point createPoint(Double longitude, Double latitude) {
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("Longitude should be between -180 and 180");
        }
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("latitude should be between -90 and 90");
        }
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), SRID.WGS84_SRID.getSRID());
        Point point = factory.createPoint(new Coordinate(longitude.doubleValue(), latitude.doubleValue()));
        return point;
    }

    public static MultiLineString createMultiLineString(String[] wktLineStrings) {
        LineString[] lineStrings = new LineString[wktLineStrings.length];
        for (int i = 0; i < wktLineStrings.length; ++i) {
            LineString ls;
            try {
                ls = (LineString)new WKTReader().read(wktLineStrings[i]);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(wktLineStrings[i] + " is not valid " + (Object)((Object)pe));
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException(wktLineStrings[i] + " is not a LINESTRING");
            }
            lineStrings[i] = ls;
        }
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), SRID.WGS84_SRID.getSRID());
        MultiLineString multiLineString = factory.createMultiLineString(lineStrings);
        return multiLineString;
    }

    public static LineString createLineString(String wktLineString) {
        try {
            LineString lineString = (LineString)new WKTReader().read(wktLineString);
            lineString.setSRID(SRID.WGS84_SRID.getSRID());
            return lineString;
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(wktLineString + " is not valid " + (Object)((Object)pe));
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(wktLineString + " is not a LINESTRING");
        }
    }

    public static double distance(Point point1, Point point2) {
        if (point1 == null || point2 == null) {
            throw new RuntimeException("Can not calculate distance for null point");
        }
        try {
            double distance = JTS.orthodromicDistance((Coordinate)point1.getCoordinate(), (Coordinate)point2.getCoordinate(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            return distance;
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
    }

    public static Float parseInternationalDouble(String number) throws java.text.ParseException {
        if (number != null) {
            number = number.trim();
        }
        NumberFormat nffrench = NumberFormat.getInstance(Locale.FRENCH);
        NumberFormat nfus = NumberFormat.getInstance(Locale.US);
        Number numberToReturn = number.indexOf(44) != -1 ? (Number)nffrench.parse(number) : (Number)nfus.parse(number);
        return Float.valueOf(numberToReturn.floatValue());
    }

    public static Polygon createPolygonBox(double lng, double lat, double distance) {
        if (distance <= 0.0) {
            throw new IllegalArgumentException("distance is incorect : " + distance);
        }
        double latrad = Math.toRadians(lat);
        double angulardistance = distance / 6378100.0;
        double latRadSinus = Math.sin(latrad);
        double latRadCosinus = Math.cos(latrad);
        double angularDistanceCosinus = Math.cos(angulardistance);
        double deltaYLatInRadian = Math.abs(Math.asin(latRadSinus * angularDistanceCosinus + latRadCosinus * Math.sin(angulardistance) * COS0) - latrad);
        double deltaXlngInRadian = Math.abs(Math.atan2(SIN90 * Math.sin(angulardistance) * latRadCosinus, angularDistanceCosinus - latRadSinus * latRadSinus));
        double deltaYLatInDegree = Math.toDegrees(deltaYLatInRadian);
        double deltaXlngInDegree = Math.toDegrees(deltaXlngInRadian);
        double minX = lng - deltaXlngInDegree;
        double maxX = lng + deltaXlngInDegree;
        double minY = lat - deltaYLatInDegree;
        double maxY = lat + deltaYLatInDegree;
        WKTReader reader = new WKTReader();
        StringBuffer sb = new StringBuffer("POLYGON((");
        String polygonString = sb.append(minX).append(" ").append(minY).append(",").append(maxX).append(" ").append(minY).append(",").append(maxX).append(" ").append(maxY).append(",").append(minX).append(" ").append(maxY).append(",").append(minX).append(" ").append(minY).append("))").toString();
        try {
            Polygon polygon = (Polygon)reader.read(polygonString);
            polygon.setSRID(SRID.WGS84_SRID.getSRID());
            return polygon;
        }
        catch (ParseException e) {
            throw new RuntimeException("can not create Polygon for lat=" + lat + " long=" + lng + " and distance=" + distance + " : " + (Object)((Object)e));
        }
    }

    public static Geometry convertFromHEXEWKBToGeometry(String hewewkbt) {
        try {
            WKBReader wkReader = new WKBReader();
            Geometry geometry = wkReader.read(GeolocHelper.hexToBytes(hewewkbt.trim()));
            geometry.setSRID(SRID.WGS84_SRID.getSRID());
            return geometry;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("error when convert HEXEWKB to Geometry " + hewewkbt, e);
        }
    }

    private static byte[] hexToBytes(String wkb) {
        byte[] wkbBytes = new byte[wkb.length() / 2];
        for (int i = 0; i < wkbBytes.length; ++i) {
            byte b1 = GeolocHelper.getFromChar(wkb.charAt(i * 2));
            byte b2 = GeolocHelper.getFromChar(wkb.charAt(i * 2 + 1));
            wkbBytes[i] = (byte)(b1 << 4 | b2);
        }
        return wkbBytes;
    }

    public static byte getFromChar(char c) {
        if (c <= '9') {
            return (byte)(c - 48);
        }
        if (c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        return (byte)(c - 97 + 10);
    }
}

