/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.domain.valueobject;

import com.gisgraphy.helper.URLUtils;
import com.gisgraphy.street.StreetType;
import com.vividsolutions.jts.geom.Point;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="result")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StreetDistance {
    @XmlTransient
    protected static final Logger logger = LoggerFactory.getLogger(StreetDistance.class);
    private String name;
    @XmlTransient
    private Point location;
    private Double distance;
    private Long gid;
    private Long openstreetmapId;
    private StreetType streetType;
    private Boolean oneWay;
    private String countryCode;
    private Double length;
    private Double lat;
    private Double lng;
    private String isIn;
    private String isInPlace;
    private String isInAdm;
    private String isInZip;
    private String fullyQualifiedAddress;

    public void updateFields() {
        if (this.location != null) {
            this.lat = this.location.getY();
            this.lng = this.location.getX();
        }
    }

    public String getName() {
        return this.name;
    }

    public Double getDistance() {
        return this.distance;
    }

    public Long getGid() {
        return this.gid;
    }

    public Long getOpenstreetmapId() {
        return this.openstreetmapId;
    }

    public StreetType getStreetType() {
        return this.streetType;
    }

    public Boolean getOneWay() {
        return this.oneWay;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public Double getLength() {
        return this.length;
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getLng() {
        return this.lng;
    }

    @XmlTransient
    public Point getLocation() {
        return this.location;
    }

    public String getIsIn() {
        return this.isIn;
    }

    public String getIsInPlace() {
        return this.isInPlace;
    }

    public String getIsInAdm() {
        return this.isInAdm;
    }

    public String getIsInZip() {
        return this.isInZip;
    }

    public String getFullyQualifiedAddress() {
        return this.fullyQualifiedAddress;
    }

    public String getOpenstreetmapUrl() {
        return URLUtils.createOpenstreetmapMapUrlForStreet(this.location);
    }

    public static class StreetDistanceBuilder {
        private final StreetDistance streetDistance = new StreetDistance();

        public static StreetDistanceBuilder streetDistance() {
            return new StreetDistanceBuilder();
        }

        private StreetDistanceBuilder() {
        }

        public StreetDistance build() {
            this.streetDistance.updateFields();
            return this.streetDistance;
        }

        public StreetDistanceBuilder withName(String name) {
            this.streetDistance.name = name;
            return this;
        }

        public StreetDistanceBuilder withOpenstreetMapId(Long openstreetmapId) {
            this.streetDistance.openstreetmapId = openstreetmapId;
            return this;
        }

        public StreetDistanceBuilder withLocation(Point location) {
            this.streetDistance.location = location;
            return this;
        }

        public StreetDistanceBuilder withDistance(Double distance) {
            this.streetDistance.distance = distance;
            return this;
        }

        public StreetDistanceBuilder withGid(Long gid) {
            this.streetDistance.gid = gid;
            return this;
        }

        public StreetDistanceBuilder withStreetType(StreetType streetType) {
            this.streetDistance.streetType = streetType;
            return this;
        }

        public StreetDistanceBuilder withOneWay(Boolean oneWay) {
            this.streetDistance.oneWay = oneWay;
            return this;
        }

        public StreetDistanceBuilder withLength(Double length) {
            this.streetDistance.length = length;
            return this;
        }

        public StreetDistanceBuilder withCountryCode(String countryCode) {
            if (countryCode != null) {
                this.streetDistance.countryCode = countryCode.toUpperCase();
            }
            return this;
        }

        public StreetDistanceBuilder withIsIn(String isIn) {
            this.streetDistance.isIn = isIn;
            return this;
        }

        public StreetDistanceBuilder withIsInPlace(String isInPlace) {
            this.streetDistance.isInPlace = isInPlace;
            return this;
        }

        public StreetDistanceBuilder withIsInAdm(String isInAdm) {
            this.streetDistance.isInAdm = isInAdm;
            return this;
        }

        public StreetDistanceBuilder withIsInZip(String isInZip) {
            this.streetDistance.isInZip = isInZip;
            return this;
        }

        public StreetDistanceBuilder withFullyQualifiedAddress(String fullyQualifiedAddress) {
            this.streetDistance.fullyQualifiedAddress = fullyQualifiedAddress;
            return this;
        }
    }
}

