/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.event.AbstractGTComponent;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.resources.Utilities;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbol;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.util.Cloneable;

public class GraphicImpl
extends AbstractGTComponent
implements Graphic,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    private FilterFactory filterFactory;
    private String geometryPropertyName = "";
    private List externalGraphics = new ArrayList();
    private List marks = new ArrayList();
    private List symbols = new ArrayList();
    private Expression rotation = null;
    private Expression size = null;
    private Displacement displacement = null;
    private Expression opacity = null;

    protected GraphicImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public GraphicImpl(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    private static void severe(String method, String message, Exception exception) {
        LogRecord record = new LogRecord(Level.SEVERE, message);
        record.setSourceMethodName(method);
        record.setThrown(exception);
        LOGGER.log(record);
    }

    public ExternalGraphic[] getExternalGraphics() {
        ExternalGraphic[] ret = null;
        if (this.externalGraphics.size() > 0) {
            ret = this.externalGraphics.toArray(new ExternalGraphic[0]);
        }
        return ret;
    }

    public void setExternalGraphics(ExternalGraphic[] externalGraphics) {
        this.externalGraphics.clear();
        int i = 0;
        while (i < this.symbols.size()) {
            Object symbol = this.symbols.get(i);
            if (symbol instanceof ExternalGraphic) {
                this.symbols.remove(i);
                continue;
            }
            ++i;
        }
        if (externalGraphics != null) {
            for (i = 0; i < externalGraphics.length; ++i) {
                this.addExternalGraphic(externalGraphics[i]);
            }
        }
        this.fireChanged();
    }

    public void addExternalGraphic(ExternalGraphic externalGraphic) {
        this.externalGraphics.add(externalGraphic);
        this.symbols.add(externalGraphic);
    }

    public Mark[] getMarks() {
        Mark[] ret = new Mark[]{};
        if (this.marks.size() > 0) {
            ret = this.marks.toArray(new Mark[0]);
        }
        return ret;
    }

    public void setMarks(Mark[] marks) {
        this.marks.clear();
        int i = 0;
        while (i < this.symbols.size()) {
            Object symbol = this.symbols.get(i);
            if (symbol instanceof Mark) {
                this.symbols.remove(i);
                continue;
            }
            ++i;
        }
        for (i = 0; i < marks.length; ++i) {
            this.addMark(marks[i]);
        }
        this.fireChanged();
    }

    public void addMark(Mark mark) {
        if (mark == null) {
            return;
        }
        this.marks.add(mark);
        this.symbols.add(mark);
        mark.setSize(this.size);
        mark.setRotation(this.rotation);
    }

    public Symbol[] getSymbols() {
        Symbol[] ret = null;
        ret = this.symbols.size() > 0 ? this.symbols.toArray(new Symbol[this.symbols.size()]) : new Symbol[]{new MarkImpl()};
        return ret;
    }

    public void setSymbols(Symbol[] symbols) {
        this.symbols.clear();
        if (symbols != null) {
            for (int i = 0; i < symbols.length; ++i) {
                this.addSymbol(symbols[i]);
            }
        }
        this.fireChanged();
    }

    public void addSymbol(Symbol symbol) {
        this.symbols.add(symbol);
        if (symbol instanceof ExternalGraphic) {
            this.addExternalGraphic((ExternalGraphic)symbol);
        }
        if (symbol instanceof Mark) {
            this.addMark((Mark)symbol);
        }
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    public Expression getRotation() {
        return this.rotation;
    }

    public Expression getSize() {
        return this.size;
    }

    public Displacement getDisplacement() {
        return this.displacement;
    }

    public void setDisplacement(Displacement offset) {
        Displacement old = this.displacement;
        this.displacement = offset;
        this.fireChildChanged("offset", offset, old);
    }

    public void setOpacity(Expression opacity) {
        Expression old = opacity;
        this.opacity = opacity;
        this.fireChildChanged("opacity", opacity, old);
    }

    public void setOpacity(double opacity) {
        this.setOpacity((Expression)this.filterFactory.literal(opacity));
    }

    public void setRotation(Expression rotation) {
        Expression old = this.rotation;
        this.rotation = rotation;
        Iterator iter = this.marks.iterator();
        while (iter.hasNext()) {
            ((MarkImpl)iter.next()).setRotation(rotation);
        }
        this.fireChildChanged("rotation", rotation, old);
    }

    public void setRotation(double rotation) {
        this.setRotation((Expression)this.filterFactory.literal(rotation));
    }

    public void setSize(Expression size) {
        Expression old = this.size;
        this.size = size;
        Iterator iter = this.marks.iterator();
        while (iter.hasNext()) {
            ((MarkImpl)iter.next()).setSize(size);
        }
        this.fireChildChanged("size", size, old);
    }

    public void setSize(int size) {
        this.setSize((Expression)this.filterFactory.literal(size));
    }

    public void setGeometryPropertyName(String name) {
        this.geometryPropertyName = name;
        this.fireChanged();
    }

    public String getGeometryPropertyName() {
        return this.geometryPropertyName;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Graphic)this);
    }

    public Object clone() {
        GraphicImpl clone;
        try {
            clone = (GraphicImpl)super.clone();
            clone.marks = new ArrayList();
            clone.externalGraphics = new ArrayList();
            clone.symbols = new ArrayList();
            for (ExternalGraphic exGraphic : this.externalGraphics) {
                clone.addExternalGraphic((ExternalGraphic)((Cloneable)exGraphic).clone());
            }
            for (Mark mark : this.marks) {
                clone.addMark((Mark)((Cloneable)mark).clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.geometryPropertyName != null) {
            result = 1000003 * result + this.geometryPropertyName.hashCode();
        }
        if (this.symbols != null) {
            result = 1000003 * result + ((Object)this.symbols).hashCode();
        }
        if (this.rotation != null) {
            result = 1000003 * result + this.rotation.hashCode();
        }
        if (this.size != null) {
            result = 1000003 * result + this.size.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof GraphicImpl) {
            GraphicImpl other = (GraphicImpl)oth;
            return Utilities.equals((Object)this.geometryPropertyName, (Object)other.geometryPropertyName) && Utilities.equals((Object)this.size, (Object)other.size) && Utilities.equals((Object)this.rotation, (Object)other.rotation) && Utilities.equals((Object)this.opacity, (Object)other.opacity) && Utilities.equals((Object)this.symbols, (Object)other.symbols);
        }
        return false;
    }
}

