/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.BaseFeatureCollectionType;
import org.geotools.feature.simple.SimpleFeatureCollectionImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureCollectionType;

public abstract class BaseFeatureCollection
extends SimpleFeatureCollectionImpl
implements FeatureCollection {
    protected static Logger LOGGER = Logger.getLogger("org.geotools.feature");
    protected List listeners = new ArrayList();

    protected BaseFeatureCollection(String id) {
        this(id, (FeatureType)null);
    }

    protected BaseFeatureCollection(String id, FeatureType memberType) {
        super(new BaseFeatureCollectionType(memberType), id);
    }

    protected BaseFeatureCollection(String id, SimpleFeatureCollectionType type) {
        super(type, id);
    }

    public final void addListener(CollectionListener listener) throws NullPointerException {
        this.listeners.add(listener);
    }

    public final void removeListener(CollectionListener listener) throws NullPointerException {
        this.listeners.remove(listener);
    }

    public FeatureType getSchema() {
        return (FeatureType)this.getMemberType();
    }

    public Object getAttribute(int index) {
        return this.getValue(index);
    }

    public Object getAttribute(String xPath) {
        return this.getValue(xPath);
    }

    public Object[] getAttributes(Object[] attributes) {
        List values = this.getValues();
        if (attributes == null) {
            Object[] retArray = new Object[values.size()];
        } else {
            Object[] retArray = attributes;
        }
        return values.toArray(attributes);
    }

    public SimpleFeatureCollectionType getType() {
        return (SimpleFeatureCollectionType)super.getType();
    }

    public BaseFeatureCollectionType getFeatureType() {
        return (BaseFeatureCollectionType)this.getType();
    }

    public Geometry getPrimaryGeometry() {
        return (Geometry)this.getDefaultGeometryValue();
    }

    public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
        this.setValue(position, val);
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        this.setValue(xPath, attribute);
    }

    public void setPrimaryGeometry(Geometry geometry) throws IllegalAttributeException {
        this.setDefaultGeometryValue(geometry);
    }

    public ReferencedEnvelope getBounds() {
        throw new UnsupportedOperationException("subclasses should override");
    }
}

