/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeatureBuilder;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.feature.type.TypeName;
import org.geotools.resources.Utilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFeatureType
extends SimpleFeatureTypeImpl
implements FeatureType {
    private final int hashCode;
    public static final FeatureType EMPTY = new DefaultFeatureType();

    private static final URI toURI(String namespace) throws SchemaException {
        try {
            return new URI(namespace);
        }
        catch (URISyntaxException badNamespace) {
            throw new SchemaException((Throwable)badNamespace);
        }
    }

    public DefaultFeatureType(String typeName, String namespace, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws SchemaException, NullPointerException {
        this(typeName, DefaultFeatureType.toURI(namespace), types, superTypes, defaultGeom);
    }

    public DefaultFeatureType(String typeName, URI namespace, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws NullPointerException {
        this((Name)(namespace != null ? new TypeName(namespace.toString(), typeName) : new TypeName(FeatureTypes.DEFAULT_NAMESPACE.toString(), typeName)), types, superTypes, defaultGeom);
    }

    private static final <T> List<T> toList(Collection<T> collection) {
        if (collection == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(collection);
    }

    private static final FeatureType toFeatureType(Collection types) {
        if (types == null || types.isEmpty()) {
            return null;
        }
        if (types.size() > 1) {
            throw new IllegalArgumentException("May only specify a single parent");
        }
        return (FeatureType)types.iterator().next();
    }

    public DefaultFeatureType(Name name, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws NullPointerException {
        super(name, (List)types, (AttributeDescriptor)defaultGeom, null, false, null, (SimpleFeatureType)DefaultFeatureType.toFeatureType(superTypes), null);
        if (name == null) {
            throw new NullPointerException("Name required");
        }
        this.hashCode = this.computeHash();
    }

    public DefaultFeatureType(Name name, List schema, AttributeDescriptor defaultGeometry, CoordinateReferenceSystem crs, boolean isAbstract, Set restrictions, SimpleFeatureType superType, InternationalString description) {
        super(name, schema, defaultGeometry, crs, isAbstract, restrictions, superType, description);
        this.hashCode = this.computeHash();
    }

    private DefaultFeatureType() {
        this("emptyFeatreType", FeatureTypes.DEFAULT_NAMESPACE, (Collection)Collections.EMPTY_LIST, (Collection)Collections.EMPTY_LIST, null);
    }

    private void init() {
    }

    public Feature create(Object[] attributes) throws IllegalAttributeException {
        return this.create(attributes, null);
    }

    public Feature create(Object[] attributes, String featureID) throws IllegalAttributeException {
        if (attributes == null && this.getAttributeCount() != 0) {
            throw new IllegalAttributeException("attributes null");
        }
        try {
            DefaultFeatureBuilder builder = new DefaultFeatureBuilder();
            builder.setType(this);
            builder.add(attributes);
            return (Feature)builder.build(featureID);
        }
        catch (Exception e) {
            throw (IllegalAttributeException)new IllegalAttributeException("illegal attribute").initCause((Throwable)e);
        }
    }

    public Feature duplicate(Feature original) throws IllegalAttributeException {
        if (original == null) {
            return null;
        }
        FeatureType featureType = original.getFeatureType();
        if (!featureType.equals(this)) {
            throw new IllegalAttributeException("Feature type " + featureType + " does not match " + this);
        }
        try {
            DefaultFeatureBuilder builder = new DefaultFeatureBuilder();
            builder.init((SimpleFeature)original);
            return (Feature)builder.build(original.getID());
        }
        catch (Exception e) {
            throw (IllegalAttributeException)new IllegalAttributeException("illegal attribute").initCause((Throwable)e);
        }
    }

    public GeometryAttributeType getPrimaryGeometry() {
        return (GeometryAttributeType)this.getDefaultGeometry();
    }

    public AttributeType getAttributeType(String xPath) {
        return (AttributeType)this.getAttribute(xPath);
    }

    public int find(AttributeType type) {
        if (type == null) {
            return -1;
        }
        int idx = this.find(type.getLocalName());
        if (idx < 0 || !this.getAttributes().get(idx).equals(type)) {
            idx = -1;
        }
        return idx;
    }

    public int find(String attName) {
        return this.indexOf(attName);
    }

    public AttributeType getAttributeType(int position) {
        return (AttributeType)this.getAttributes().get(position);
    }

    public AttributeType[] getAttributeTypes() {
        return this.getAttributes().toArray(new AttributeType[this.getAttributes().size()]);
    }

    public URI getNamespace() {
        try {
            return this.getName().getNamespaceURI() != null ? new URI(this.getName().getNamespaceURI()) : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String getTypeName() {
        return this.getName().getLocalPart();
    }

    public boolean hasAttributeType(String xPath) {
        return this.getAttributeType(xPath) != null;
    }

    @Override
    public int getAttributeCount() {
        return this.getAttributes().size();
    }

    private int computeHash() {
        return super.hashCode();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof FeatureType) {
            return super.equals((FeatureType)other);
        }
        return false;
    }

    public FeatureType[] getAncestors() {
        return null;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    public boolean isDescendedFrom(FeatureType type) {
        return this.isDescendedFrom(type.getNamespace(), type.getTypeName());
    }

    public boolean isDescendedFrom(URI nsURI, String typeName1) {
        for (FeatureType superType = (FeatureType)this.getSuper(); superType != null; superType = (FeatureType)superType.getSuper()) {
            if (!(nsURI == null ? Utilities.equals((Object)superType.getTypeName(), (Object)typeName1) : Utilities.equals((Object)superType.getNamespace(), (Object)nsURI) && Utilities.equals((Object)superType.getTypeName(), (Object)typeName1))) continue;
            return true;
        }
        return false;
    }

    static final class Abstract
    extends DefaultFeatureType {
        public Abstract(String typeName, URI namespace, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws SchemaException {
            super(typeName, namespace, types, superTypes, defaultGeom);
            for (FeatureType ft : superTypes) {
            }
        }

        public final boolean isAbstract() {
            return true;
        }

        public Feature create(Object[] atts) throws IllegalAttributeException {
            throw new UnsupportedOperationException("Abstract Type");
        }

        public Feature create(Object[] atts, String id) throws IllegalAttributeException {
            throw new UnsupportedOperationException("Abstract Type");
        }
    }
}

