/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.geotools.feature.type.Descriptors;
import org.geotools.resources.Utilities;
import org.opengis.feature.Association;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexAttributeImpl
implements ComplexAttribute {
    private transient int HASHCODE = -1;
    protected AttributeDescriptor DESCRIPTOR;
    protected final ComplexType TYPE;
    protected final String ID;
    protected List properties;
    private List attributes;
    private List associations;
    private List types = null;
    private List values = null;

    public ComplexAttributeImpl(Collection properties, ComplexType type, String id) {
        this.TYPE = type;
        this.ID = id;
        this.properties = this.toPropertList(properties);
    }

    final List<Property> toPropertList(Collection properties) {
        if (properties == null) {
            return new ArrayList<Property>(this.TYPE.getProperties().size());
        }
        return new ArrayList<Property>(properties);
    }

    public ComplexAttributeImpl(Collection properties, AttributeDescriptor desc, String id) {
        this(properties, (ComplexType)desc.getType(), id);
        this.DESCRIPTOR = desc;
    }

    public AttributeType getType() {
        return this.TYPE;
    }

    public AttributeDescriptor getDescriptor() {
        return this.DESCRIPTOR;
    }

    public PropertyDescriptor descriptor() {
        return this.getDescriptor();
    }

    public String getID() {
        return this.ID;
    }

    public Name name() {
        return this.DESCRIPTOR != null ? this.DESCRIPTOR.getName() : null;
    }

    public boolean nillable() {
        if (this.getDescriptor() != null) {
            return this.getDescriptor().isNillable();
        }
        return true;
    }

    public Object getValue() {
        return Collections.unmodifiableList(this.properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection associations() {
        if (this.associations == null) {
            ComplexAttributeImpl complexAttributeImpl = this;
            synchronized (complexAttributeImpl) {
                if (this.associations == null) {
                    this.associations = new ArrayList();
                    for (Property property : this.properties) {
                        if (!(property instanceof Association)) continue;
                        this.associations.add(property);
                    }
                }
            }
        }
        return Collections.unmodifiableList(this.associations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List attributes() {
        if (this.attributes == null) {
            ComplexAttributeImpl complexAttributeImpl = this;
            synchronized (complexAttributeImpl) {
                if (this.attributes == null) {
                    this.attributes = new ArrayList();
                    for (Property property : this.properties) {
                        if (!(property instanceof Attribute)) continue;
                        this.attributes.add(property);
                    }
                }
            }
        }
        return Collections.unmodifiableList(this.attributes);
    }

    public List get(Name name) {
        LinkedList<Property> childs = new LinkedList<Property>();
        for (Property prop : this.properties) {
            PropertyDescriptor node = prop.descriptor();
            Name propName = node.getName();
            if (name.getNamespaceURI() != null) {
                if (!propName.equals(name)) continue;
                childs.add(prop);
                continue;
            }
            String localName = propName.getLocalPart();
            if (!localName.equals(name.getLocalPart())) continue;
            childs.add(prop);
        }
        return childs;
    }

    protected synchronized List types() {
        if (this.types == null) {
            this.types = this.createTypesView((List)this.getValue());
        }
        return this.types;
    }

    protected List createTypesView(final List source) {
        if (source == null) {
            return Collections.EMPTY_LIST;
        }
        return new AbstractList(){

            public Object get(int index) {
                return ((Attribute)source.get(index)).getType();
            }

            public int size() {
                return source.size();
            }

            public Object remove(int index) {
                Attribute removed = (Attribute)source.remove(index);
                if (removed != null) {
                    return removed.getType();
                }
                return null;
            }

            public void add(int index, Object o) {
                throw new UnsupportedOperationException("Cannot add directly to types");
            }
        };
    }

    public synchronized List values() {
        if (this.values == null) {
            this.values = this.createValuesView((List)this.getValue());
        }
        return this.values;
    }

    protected List createValuesView(final List source) {
        return new AbstractList(){

            public Object get(int index) {
                return ((Attribute)source.get(index)).getValue();
            }

            public Object set(int index, Object value) {
                Object replaced = ((Attribute)source.get(index)).getValue();
                ((Attribute)source.get(index)).setValue(value);
                return replaced;
            }

            public int size() {
                return source.size();
            }

            public Object remove(int index) {
                Attribute removed = (Attribute)source.remove(index);
                if (removed != null) {
                    return removed.getValue();
                }
                return null;
            }

            public void add(int index, Object value) {
                throw new UnsupportedOperationException("Cannot add directly to values");
            }
        };
    }

    public void setValue(Object newValue) {
        if (newValue == null) {
            this.properties.clear();
        } else {
            this.properties = new ArrayList((Collection)newValue);
        }
        this.attributes = null;
        this.associations = null;
        this.types = null;
        this.values = null;
    }

    protected Object get(AttributeType type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        ComplexType ctype = this.TYPE;
        if (Descriptors.multiple(ctype, type)) {
            ArrayList<Object> got = new ArrayList<Object>();
            for (Attribute attribute : this.properties) {
                if (!attribute.getType().equals(type)) continue;
                got.add(attribute.getValue());
            }
            return got;
        }
        for (Attribute attribute : this.properties) {
            if (!attribute.getType().equals(type)) continue;
            return attribute.getValue();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ComplexAttributeImpl)) {
            return false;
        }
        ComplexAttributeImpl c = (ComplexAttributeImpl)o;
        if (!Utilities.equals((Object)this.ID, (Object)c.ID)) {
            return false;
        }
        if (!Utilities.equals((Object)this.TYPE, (Object)c.TYPE)) {
            return false;
        }
        if (!Utilities.equals((Object)this.DESCRIPTOR, (Object)c.DESCRIPTOR)) {
            return false;
        }
        return ((Object)this.properties).equals(c.properties);
    }

    public int hashCode() {
        if (this.HASHCODE == -1) {
            this.HASHCODE = 23 + (this.TYPE == null ? 1 : this.TYPE.hashCode()) * (this.DESCRIPTOR == null ? 1 : this.DESCRIPTOR.hashCode()) * ((Object)this.properties).hashCode() * (this.ID == null ? 1 : this.ID.hashCode());
        }
        return this.HASHCODE;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        List atts = this.properties;
        sb.append("[id=").append(this.ID).append(", name=").append(this.DESCRIPTOR != null ? this.DESCRIPTOR.getName().toString() : "null").append(", type=").append(this.getType().getName()).append('\n');
        for (Attribute att : atts) {
            sb.append(att);
            sb.append('\n');
        }
        sb.append("]");
        return sb.toString();
    }

    public Object operation(Name arg0, List arg1) {
        throw new UnsupportedOperationException("operation not supported yet");
    }
}

