/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.Iterator;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class ReTypingIterator
implements Iterator {
    Iterator delegate;
    FeatureType target;
    AttributeType[] types;

    public ReTypingIterator(Iterator delegate, FeatureType source, FeatureType target) {
        this.delegate = delegate;
        this.target = target;
        this.types = this.typeAttributes(source, target);
    }

    public Iterator getDelegate() {
        return this.delegate;
    }

    public void remove() {
        this.delegate.remove();
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public Object next() {
        Feature next = (Feature)this.delegate.next();
        String id = next.getID();
        Object[] attributes = new Object[this.types.length];
        try {
            for (int i = 0; i < this.types.length; ++i) {
                String xpath = this.types[i].getLocalName();
                attributes[i] = next.getAttribute(xpath);
            }
            return this.target.create(attributes, id);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException(e);
        }
    }

    protected AttributeType[] typeAttributes(FeatureType original, FeatureType target) {
        if (target.equals(original)) {
            throw new IllegalArgumentException("FeatureReader allready produces contents with the correct schema");
        }
        if (target.getAttributeCount() > original.getAttributeCount()) {
            throw new IllegalArgumentException("Unable to retype FeatureReader (origional does not cover requested type)");
        }
        AttributeType[] types = new AttributeType[target.getAttributeCount()];
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            AttributeType attrib = target.getAttributeType(i);
            String xpath = attrib.getLocalName();
            types[i] = attrib;
            if (attrib.equals(original.getAttributeType(xpath))) continue;
            throw new IllegalArgumentException("Unable to retype FeatureReader (origional does not cover " + xpath + ")");
        }
        return types;
    }
}

