/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.store.FeatureReaderIterator;
import org.geotools.data.store.FeatureWriterIterator;
import org.geotools.data.store.NoContentIterator;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.BaseFeatureCollection;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.feature.collection.FeatureState;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.filter.SortBy2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public abstract class DataFeatureCollection
extends BaseFeatureCollection
implements FeatureCollection {
    static Logger LOGGER = Logger.getLogger("org.geotools.data");
    private static int unique = 0;
    private final Set open = new HashSet();
    private FeatureCollection parent;

    protected DataFeatureCollection() {
        this("features" + unique++);
    }

    protected DataFeatureCollection(String id) {
        this(id, (FeatureType)null);
    }

    protected DataFeatureCollection(String id, FeatureType memberType) {
        super(id, memberType);
    }

    protected void fireChange(org.geotools.feature.Feature[] features, int type) {
        CollectionEvent cEvent = new CollectionEvent((FeatureCollection)this, features, type);
        int ii = this.listeners.size();
        for (int i = 0; i < ii; ++i) {
            ((CollectionListener)this.listeners.get(i)).collectionChanged(cEvent);
        }
    }

    protected void fireChange(org.geotools.feature.Feature feature, int type) {
        this.fireChange(new org.geotools.feature.Feature[]{feature}, type);
    }

    protected void fireChange(Collection coll, int type) {
        org.geotools.feature.Feature[] features = new org.geotools.feature.Feature[coll.size()];
        features = coll.toArray(features);
        this.fireChange(features, type);
    }

    public FeatureReader reader() throws IOException {
        return new DelegateFeatureReader(this.getSchema(), this.features());
    }

    public FeatureType getSchema() {
        return super.getSchema();
    }

    public abstract ReferencedEnvelope getBounds();

    public abstract int getCount() throws IOException;

    protected FeatureWriter writer() throws IOException {
        throw new UnsupportedOperationException("Modification of this collection is not supported");
    }

    public FeatureIterator features() {
        DelegateFeatureIterator iterator = new DelegateFeatureIterator(this, this.iterator());
        this.open.add(iterator);
        return iterator;
    }

    public final Iterator iterator() {
        Iterator iterator;
        try {
            iterator = this.openIterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.open.add(iterator);
        return iterator;
    }

    protected Iterator openIterator() throws IOException {
        try {
            return new FeatureWriterIterator(this.writer());
        }
        catch (IOException badWriter) {
            return new NoContentIterator(badWriter);
        }
        catch (UnsupportedOperationException readOnly) {
            try {
                return new FeatureReaderIterator(this.reader());
            }
            catch (IOException e) {
                return new NoContentIterator(e);
            }
        }
    }

    public final void close(Iterator close) {
        try {
            this.closeIterator(close);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error closing iterator", e);
        }
        this.open.remove(close);
    }

    protected void closeIterator(Iterator close) throws IOException {
        if (close != null) {
            if (close instanceof FeatureReaderIterator) {
                FeatureReaderIterator iterator = (FeatureReaderIterator)close;
                iterator.close();
            } else if (close instanceof FeatureWriterIterator) {
                FeatureWriterIterator iterator = (FeatureWriterIterator)close;
                iterator.close();
            }
        }
    }

    public void close(FeatureIterator iterator) {
        iterator.close();
        this.open.remove(iterator);
    }

    public int size() {
        try {
            return this.getCount();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "IOException while calculating size() of FeatureCollection", e);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Iterator i = this.open.iterator();
        while (i.hasNext()) {
            Object iterator = i.next();
            try {
                if (iterator instanceof Iterator) {
                    this.closeIterator((Iterator)iterator);
                }
                if (!(iterator instanceof FeatureIterator)) continue;
                ((FeatureIterator)iterator).close();
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isEmpty() {
        FeatureReader reader = null;
        try {
            reader = this.reader();
            try {
                boolean bl = !reader.hasNext();
                return bl;
            }
            catch (IOException e) {
                boolean bl;
                block17: {
                    bl = true;
                    if (reader == null) break block17;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return bl;
                catch (IOException e3) {
                    boolean bl2 = true;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean contains(Object o) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object[] toArray() {
        return this.toArray(new org.geotools.feature.Feature[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] array) {
        ArrayList list = new ArrayList();
        Iterator i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
        }
        finally {
            this.close(i);
        }
        return list.toArray(array);
    }

    public boolean add(Object arg0) {
        return false;
    }

    public boolean remove(Object arg0) {
        return false;
    }

    public boolean containsAll(Collection arg0) {
        return false;
    }

    public boolean addAll(Collection arg0) {
        return false;
    }

    public boolean removeAll(Collection arg0) {
        return false;
    }

    public boolean retainAll(Collection arg0) {
        return false;
    }

    public void clear() {
    }

    public FeatureCollection getParent() {
        return this.parent;
    }

    public void setParent(FeatureCollection collection) {
        this.parent = collection;
    }

    public Object getValue(String xPath) {
        if (xPath.indexOf(this.getFeatureType().getTypeName()) > -1) {
            if (xPath.endsWith("]")) {
                return this.getAttribute(0);
            }
            return this.getAttribute(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object getValue(int index) {
        if (index == 0) {
            FeatureReader reader = null;
            try {
                org.geotools.feature.Feature feature;
                reader = this.reader();
                FeatureType schema = this.getSchema();
                org.geotools.feature.Feature list = new ArrayList();
                while (reader.hasNext()) {
                    feature = reader.next();
                    org.geotools.feature.Feature copy = schema.duplicate(feature);
                    list.add(copy);
                }
                feature = list;
                return feature;
            }
            catch (IOException e) {
                Object var4_8 = null;
                return var4_8;
            }
            catch (NoSuchElementException e) {
                Object var4_9 = null;
                return var4_9;
            }
            catch (IllegalAttributeException e2) {
                Object var4_10 = null;
                return var4_10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return null;
    }

    public void setValue(int position, Object val) {
        if (position == 0 && val instanceof Collection) {
            Collection list = (Collection)val;
            if (!FeatureState.isFeatures(list)) {
                return;
            }
            FeatureWriter writer = null;
            try {
                writer = this.writer();
                while (writer.hasNext()) {
                    writer.next();
                    writer.remove();
                }
                org.geotools.feature.Feature feature2 = null;
                for (org.geotools.feature.Feature feature2 : list) {
                    org.geotools.feature.Feature newFeature = writer.next();
                    Object[] values = feature2.getAttributes(null);
                    for (int a = 0; a < values.length; ++a) {
                        try {
                            newFeature.setAttribute(a, values[a]);
                            continue;
                        }
                        catch (IllegalAttributeException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    writer.write();
                }
            }
            catch (IOException io) {
                throw (ArrayIndexOutOfBoundsException)new ArrayIndexOutOfBoundsException().initCause(io);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException io) {
                        throw (IllegalArgumentException)new IllegalArgumentException("Unsuccessful:" + io).initCause(io);
                    }
                }
            }
        }
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        if (xPath.indexOf(this.getFeatureType().getTypeName()) > -1 && !xPath.endsWith("]")) {
            this.setAttribute(0, attribute);
        }
    }

    public Geometry getPrimaryGeometry() {
        return null;
    }

    public void setPrimaryGeometry(Geometry geometry) throws IllegalAttributeException {
        throw new IllegalAttributeException("DefaultGeometry not supported");
    }

    public final void accepts(org.geotools.feature.visitor.FeatureVisitor visitor, org.geotools.util.ProgressListener progress) throws IOException {
        this.accepts((FeatureVisitor)visitor, (ProgressListener)progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        Iterator iterator = null;
        if (progress == null) {
            progress = new NullProgressListener();
        }
        try {
            float size = this.size();
            float position = 0.0f;
            progress.started();
            iterator = this.iterator();
            while (!progress.isCanceled() && iterator.hasNext()) {
                try {
                    org.geotools.feature.Feature feature = (org.geotools.feature.Feature)iterator.next();
                    visitor.visit((Feature)feature);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                }
                float f = position;
                position = f + 1.0f;
                progress.progress(f / size);
            }
        }
        catch (Throwable throwable) {
            progress.complete();
            this.close(iterator);
            throw throwable;
        }
        progress.complete();
        this.close(iterator);
    }

    public FeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    public FeatureCollection sort(SortBy order) {
        if (order instanceof SortBy2) {
            SortBy2 advanced = (SortBy2)order;
            return this.sort(advanced);
        }
        return null;
    }

    public FeatureCollection sort(SortBy2 order) {
        return null;
    }
}

