/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.EmptyFeatureWriter;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.view.DefaultView;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;
import org.opengis.filter.Filter;

public abstract class AbstractDataStore
implements DataStore {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.data");
    public FeatureListenerManager listenerManager = new FeatureListenerManager();
    protected final boolean isWriteable;
    private InProcessLockingManager lockingManager;

    public AbstractDataStore() {
        this(true);
    }

    public AbstractDataStore(boolean isWriteable) {
        this.isWriteable = isWriteable;
        this.lockingManager = this.createLockingManager();
    }

    protected InProcessLockingManager createLockingManager() {
        return new InProcessLockingManager();
    }

    protected Map createMetadata(String typeName) {
        return Collections.EMPTY_MAP;
    }

    public abstract String[] getTypeNames() throws IOException;

    public abstract FeatureType getSchema(String var1) throws IOException;

    protected abstract FeatureReader getFeatureReader(String var1) throws IOException;

    protected FeatureWriter getFeatureWriter(String typeName) throws IOException {
        throw new UnsupportedOperationException("Schema creation not supported");
    }

    protected FeatureWriter createFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("Schema creation not supported");
    }

    public void createSchema(FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Schema creation not supported");
    }

    public void updateSchema(String typeName, FeatureType featureType) {
        throw new UnsupportedOperationException("Schema modification not supported");
    }

    public FeatureSource getView(Query query) throws IOException, SchemaException {
        return new DefaultView(this.getFeatureSource(query.getTypeName()), query);
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        final FeatureType featureType = this.getSchema(typeName);
        if (this.isWriteable) {
            if (this.lockingManager != null) {
                return new AbstractFeatureLocking(this.getSupportedHints()){

                    public DataStore getDataStore() {
                        return AbstractDataStore.this;
                    }

                    public void addFeatureListener(FeatureListener listener) {
                        AbstractDataStore.this.listenerManager.addFeatureListener(this, listener);
                    }

                    public void removeFeatureListener(FeatureListener listener) {
                        AbstractDataStore.this.listenerManager.removeFeatureListener(this, listener);
                    }

                    public FeatureType getSchema() {
                        return featureType;
                    }
                };
            }
            return new AbstractFeatureStore(this.getSupportedHints()){

                public DataStore getDataStore() {
                    return AbstractDataStore.this;
                }

                public void addFeatureListener(FeatureListener listener) {
                    AbstractDataStore.this.listenerManager.addFeatureListener(this, listener);
                }

                public void removeFeatureListener(FeatureListener listener) {
                    AbstractDataStore.this.listenerManager.removeFeatureListener(this, listener);
                }

                public FeatureType getSchema() {
                    return featureType;
                }
            };
        }
        return new AbstractFeatureSource(this.getSupportedHints()){

            public DataStore getDataStore() {
                return AbstractDataStore.this;
            }

            public void addFeatureListener(FeatureListener listener) {
                AbstractDataStore.this.listenerManager.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                AbstractDataStore.this.listenerManager.removeFeatureListener(this, listener);
            }

            public FeatureType getSchema() {
                return featureType;
            }
        };
    }

    public FeatureReader getFeatureReader(Query query, Transaction transaction) throws IOException {
        Filter filter = query.getFilter();
        String typeName = query.getTypeName();
        String[] propertyNames = query.getPropertyNames();
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.INCLUDE?");
        }
        if (typeName == null) {
            throw new NullPointerException("getFeatureReader requires typeName: use getTypeNames() for a list of available types");
        }
        if (transaction == null) {
            throw new NullPointerException("getFeatureReader requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        FeatureType featureType = this.getSchema(query.getTypeName());
        if (propertyNames != null || query.getCoordinateSystem() != null) {
            try {
                featureType = DataUtilities.createSubType(featureType, propertyNames, query.getCoordinateSystem());
            }
            catch (SchemaException e) {
                LOGGER.log(Level.FINEST, e.getMessage(), e);
                throw new DataSourceException("Could not create Feature Type for query", (Throwable)e);
            }
        }
        if (filter == Filter.EXCLUDE || filter.equals(Filter.EXCLUDE)) {
            return new EmptyFeatureReader(featureType);
        }
        if ((filter = this.getUnsupportedFilter(typeName, filter)) == null) {
            throw new NullPointerException("getUnsupportedFilter shouldn't return null. Do you mean Filter.INCLUDE?");
        }
        Diff diff = null;
        if (transaction != Transaction.AUTO_COMMIT) {
            diff = this.state(transaction).diff(typeName);
        }
        FeatureReader reader = this.getFeatureReader(typeName, query);
        if (diff != null) {
            reader = new DiffFeatureReader(reader, diff, query.getFilter());
        }
        if (!filter.equals(Filter.INCLUDE)) {
            reader = new FilteringFeatureReader(reader, filter);
        }
        if (!featureType.equals(reader.getFeatureType())) {
            LOGGER.fine("Recasting feature type to subtype by using a ReTypeFeatureReader");
            reader = new ReTypeFeatureReader(reader, featureType, false);
        }
        if (query.getMaxFeatures() != Integer.MAX_VALUE) {
            reader = new MaxFeatureReader(reader, query.getMaxFeatures());
        }
        return reader;
    }

    protected FeatureReader getFeatureReader(String typeName, Query query) throws IOException {
        return this.getFeatureReader(typeName);
    }

    protected Filter getUnsupportedFilter(String typeName, Filter filter) {
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionStateDiff state(Transaction transaction) {
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            TransactionStateDiff state = (TransactionStateDiff)transaction.getState((Object)this);
            if (state == null) {
                state = new TransactionStateDiff(this);
                transaction.putState((Object)this, (Transaction.State)state);
            }
            return state;
        }
    }

    public FeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        FeatureWriter writer;
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.INCLUDE?");
        }
        if (filter == Filter.EXCLUDE) {
            FeatureType featureType = this.getSchema(typeName);
            return new EmptyFeatureWriter(featureType);
        }
        if (transaction == null) {
            throw new NullPointerException("getFeatureWriter requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        if (transaction == Transaction.AUTO_COMMIT) {
            try {
                writer = this.createFeatureWriter(typeName, transaction);
            }
            catch (UnsupportedOperationException e) {
                writer = this.getFeatureWriter(typeName);
            }
        } else {
            writer = this.state(transaction).writer(typeName, filter);
        }
        if (this.lockingManager != null) {
            writer = this.lockingManager.checkedWriter(writer, transaction);
        }
        if (filter != Filter.INCLUDE) {
            writer = new FilteringFeatureWriter(writer, filter);
        }
        return writer;
    }

    public FeatureWriter getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, transaction);
    }

    public FeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        FeatureWriter writer = this.getFeatureWriter(typeName, transaction);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    public LockingManager getLockingManager() {
        return this.lockingManager;
    }

    protected Envelope getBounds(Query query) throws IOException {
        return null;
    }

    protected int getCount(Query query) throws IOException {
        return -1;
    }

    protected Set getSupportedHints() {
        return Collections.EMPTY_SET;
    }
}

