/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.defaults;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geotools.catalog.AbstractCatalog;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.CatalogInfo;
import org.geotools.catalog.GeoResource;
import org.geotools.catalog.GeoResourceInfo;
import org.geotools.catalog.Resolve;
import org.geotools.catalog.ResolveChangeEvent;
import org.geotools.catalog.ResolveChangeListener;
import org.geotools.catalog.ResolveDelta;
import org.geotools.catalog.Service;
import org.geotools.catalog.ServiceInfo;
import org.geotools.catalog.defaults.AST;
import org.geotools.catalog.defaults.ASTFactory;
import org.geotools.catalog.defaults.DefaultCatalogInfo;
import org.geotools.catalog.defaults.DefaultResolveChangeEvent;
import org.geotools.catalog.defaults.DefaultResolveDelta;
import org.geotools.util.ListenerList;
import org.geotools.util.ProgressListener;

public class DefaultCatalog
extends AbstractCatalog {
    private HashSet services = new HashSet();
    private CatalogInfo metadata;
    private ListenerList catalogListeners;

    public DefaultCatalog() {
        DefaultCatalogInfo metadata = new DefaultCatalogInfo(){};
        metadata.setTitle("Default Catalog");
        try {
            metadata.setSource(new URI("http://localhost"));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.metadata = metadata;
        this.catalogListeners = new ListenerList();
    }

    public DefaultCatalog(CatalogInfo metadata) {
        this();
        this.metadata = metadata;
    }

    public void addCatalogListener(ResolveChangeListener listener) {
        this.catalogListeners.add(listener);
    }

    public void removeCatalogListener(ResolveChangeListener listener) {
        this.catalogListeners.remove(listener);
    }

    public void add(Service entry) throws UnsupportedOperationException {
        if (entry == null || entry.getIdentifier() == null) {
            throw new NullPointerException("Cannot have a null id");
        }
        this.services.add(entry);
        DefaultResolveDelta deltaAdded = new DefaultResolveDelta((Resolve)entry, ResolveDelta.Kind.ADDED);
        DefaultResolveDelta deltaChanged = new DefaultResolveDelta((Resolve)this, Collections.singletonList(deltaAdded));
        this.fire(new DefaultResolveChangeEvent(this, ResolveChangeEvent.Type.POST_CHANGE, deltaChanged));
    }

    public void remove(Service entry) throws UnsupportedOperationException {
        if (entry == null || entry.getIdentifier() == null) {
            throw new NullPointerException("Cannot have a null id");
        }
        DefaultResolveDelta deltaRemoved = new DefaultResolveDelta((Resolve)entry, ResolveDelta.Kind.REMOVED);
        DefaultResolveDelta deltaChanged = new DefaultResolveDelta((Resolve)this, Collections.singletonList(deltaRemoved));
        this.fire(new DefaultResolveChangeEvent(this, ResolveChangeEvent.Type.PRE_DELETE, deltaChanged));
        this.services.remove(entry);
        this.fire(new DefaultResolveChangeEvent(this, ResolveChangeEvent.Type.POST_CHANGE, deltaRemoved));
    }

    public void replace(URI id, Service entry) throws UnsupportedOperationException {
        if (entry == null || entry.getIdentifier() == null || id == null) {
            throw new NullPointerException("Cannot have a null id");
        }
        List victims = this.findService(id, null);
        ArrayList<DefaultResolveDelta> changes = new ArrayList<DefaultResolveDelta>();
        for (Service service : victims) {
            ArrayList<DefaultResolveDelta> childChanges = new ArrayList<DefaultResolveDelta>();
            try {
                List newChildren = entry.members(null);
                List oldChildren = service.members(null);
                if (oldChildren != null) {
                    block3: for (GeoResource oldChild : oldChildren) {
                        String oldName = oldChild.getIdentifier().toString();
                        for (GeoResource child : newChildren) {
                            String name = child.getIdentifier().toString();
                            if (!oldName.equals(name)) continue;
                            childChanges.add(new DefaultResolveDelta((Resolve)child, (Resolve)oldChild, ResolveDelta.NO_CHILDREN));
                            continue block3;
                        }
                    }
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
            changes.add(new DefaultResolveDelta((Resolve)service, (Resolve)entry, childChanges));
        }
        DefaultResolveDelta deltas = new DefaultResolveDelta((Resolve)this, changes);
        DefaultResolveChangeEvent event = new DefaultResolveChangeEvent(this, ResolveChangeEvent.Type.PRE_DELETE, deltas);
        this.fire(event);
        this.services.removeAll(victims);
        this.services.add(entry);
    }

    public List find(URI query, ProgressListener monitor) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            URL qurl = query.toURL();
            for (Service service : this.services) {
                URL url = service.getIdentifier().toURL();
                if (!url.getProtocol().equalsIgnoreCase(qurl.getProtocol()) || url.getHost() != null && !"".equals(url.getHost()) && (url.getHost() == null || !url.getHost().equalsIgnoreCase(qurl.getHost())) || url.getPath() != null && !"".equals(url.getPath()) && (url.getPath() == null || !url.getPath().equalsIgnoreCase(qurl.getPath())) || url.getQuery() != null && !"".equals(url.getQuery()) && (url.getQuery() == null || !url.getQuery().equalsIgnoreCase(qurl.getQuery())) || url.getAuthority() != null && !"".equals(url.getAuthority()) && (url.getAuthority() == null || !url.getAuthority().equalsIgnoreCase(qurl.getAuthority()))) continue;
                if (qurl.getRef() == null) {
                    list.add(service);
                    continue;
                }
                try {
                    Iterator i;
                    List t = service.members(monitor);
                    Iterator iterator = i = t == null ? null : t.iterator();
                    if (qurl.getRef() != null) {
                        while (i.hasNext()) {
                            GeoResource res = (GeoResource)i.next();
                            if (!qurl.getRef().equals(res.getIdentifier().toURL().getRef())) continue;
                            list.add(res);
                        }
                        continue;
                    }
                    while (i != null && i.hasNext()) {
                        list.add(i.next());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public List findService(URI query, ProgressListener monitor) {
        ArrayList<Service> list = new ArrayList<Service>();
        try {
            URL qurl = query.toURL();
            if (qurl.getRef() != null) {
                return list;
            }
            for (Service service : this.services) {
                URL url = service.getIdentifier().toURL();
                if (!url.getProtocol().equalsIgnoreCase(qurl.getProtocol()) || url.getHost() != null && !"".equals(url.getHost()) && (url.getHost() == null || !url.getHost().equalsIgnoreCase(qurl.getHost())) || url.getPath() != null && !"".equals(url.getPath()) && (url.getPath() == null || !url.getPath().equalsIgnoreCase(qurl.getPath())) || url.getQuery() != null && !"".equals(url.getQuery()) && (url.getQuery() == null || !url.getQuery().equalsIgnoreCase(qurl.getQuery())) || url.getAuthority() != null && !"".equals(url.getAuthority()) && (url.getAuthority() == null || !url.getAuthority().equalsIgnoreCase(qurl.getAuthority()))) continue;
                list.add(service);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List search(String pattern, Envelope bbox, ProgressListener monitor) {
        if ((pattern == null || "".equals(pattern.trim())) && (bbox == null || bbox.isNull())) {
            return new LinkedList();
        }
        AST ast = null;
        if (pattern != null && !"".equals(pattern.trim())) {
            ast = ASTFactory.parse(pattern);
        }
        LinkedList<Object> result = new LinkedList<Object>();
        HashSet tmp = new HashSet();
        tmp.addAll(this.services);
        Iterator services = tmp.iterator();
        if (services != null) {
            while (services.hasNext()) {
                Service service = (Service)services.next();
                if (DefaultCatalog.check(service, ast)) {
                    result.add(service);
                }
                try {
                    Iterator resources;
                    List t = service.members(monitor);
                    Iterator iterator = resources = t == null ? null : t.iterator();
                    while (resources != null && resources.hasNext()) {
                        GeoResource resource = (GeoResource)resources.next();
                        if (!DefaultCatalog.check(resource, ast, bbox)) continue;
                        result.add(resource);
                    }
                }
                catch (IOException e) {
                }
            }
        }
        LinkedList<Object> linkedList = result;
        return linkedList;
    }

    protected static boolean check(Service service, AST pattern) {
        ServiceInfo info;
        if (pattern == null) {
            return false;
        }
        try {
            info = service == null ? null : service.getInfo(null);
        }
        catch (IOException e) {
            info = null;
            e.printStackTrace();
        }
        boolean t = false;
        if (info != null) {
            if (info.getTitle() != null) {
                t = pattern.accept(info.getTitle());
            }
            if (!t && info.getKeywords() != null) {
                String[] keys = info.getKeywords();
                for (int i = 0; !t && i < keys.length; ++i) {
                    if (keys[i] == null) continue;
                    t = pattern.accept(keys[i]);
                }
            }
            if (!t && info.getSchema() != null) {
                t = pattern.accept(info.getSchema().toString());
            }
            if (!t && info.getAbstract() != null) {
                t = pattern.accept(info.getAbstract());
            }
            if (!t && info.getDescription() != null) {
                t = pattern.accept(info.getDescription());
            }
        }
        return t;
    }

    protected static boolean check(GeoResource resource, AST pattern) {
        GeoResourceInfo info;
        if (pattern == null) {
            return true;
        }
        try {
            info = resource == null ? null : resource.getInfo(null);
        }
        catch (IOException e) {
            info = null;
            e.printStackTrace();
        }
        boolean t = false;
        if (info != null) {
            if (info.getTitle() != null) {
                t = pattern.accept(info.getTitle());
            }
            if (!t && info.getName() != null) {
                t = pattern.accept(info.getName());
            }
            if (!t && info.getKeywords() != null) {
                String[] keys = info.getKeywords();
                for (int i = 0; !t && i < keys.length; ++i) {
                    if (keys[i] == null) continue;
                    t = pattern.accept(keys[i]);
                }
            }
            if (!t && info.getSchema() != null) {
                t = pattern.accept(info.getSchema().toString());
            }
            if (!t && info.getDescription() != null) {
                t = pattern.accept(info.getDescription());
            }
        }
        return t;
    }

    protected static boolean check(GeoResource resource, AST pattern, Envelope bbox) {
        if (!DefaultCatalog.check(resource, pattern)) {
            return false;
        }
        if (bbox == null || bbox.isNull()) {
            return true;
        }
        try {
            return bbox.intersects(resource.getInfo(null).getBounds());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void fire(ResolveChangeEvent event) {
        Object[] listeners = this.catalogListeners.getListeners();
        if (listeners.length == 0) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            try {
                ((ResolveChangeListener)listeners[i]).changed(event);
                continue;
            }
            catch (Throwable die) {
                die.printStackTrace();
            }
        }
    }

    public Object resolve(Class adaptee, ProgressListener monitor) {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(Catalog.class)) {
            return this;
        }
        if (adaptee.isAssignableFrom(CatalogInfo.class)) {
            return this.metadata;
        }
        if (adaptee.isAssignableFrom(this.services.getClass())) {
            return this.services;
        }
        if (adaptee.isAssignableFrom(List.class)) {
            return new LinkedList(this.services);
        }
        if (adaptee.isAssignableFrom(this.catalogListeners.getClass())) {
            return this.catalogListeners;
        }
        return null;
    }

    public boolean canResolve(Class adaptee) {
        Object value = this.resolve(adaptee, null);
        return value != null;
    }

    public List members(ProgressListener monitor) {
        return new LinkedList(this.services);
    }

    public Resolve.Status getStatus() {
        return Resolve.Status.CONNECTED;
    }

    public Throwable getMessage() {
        return null;
    }

    public URI getIdentifier() {
        return this.metadata.getSource();
    }
}

